/*
 * Decompiled with CFR 0.152.
 */
package Memory.Heap;

import Allocator.ObjectLayoutMethods;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Memory.Heap.BootHeap;
import Memory.HeapAddress;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Heap {
    public static final List allHeaps = new ArrayList();
    protected final String name;
    protected int verbose;
    protected HeapAddress start;
    protected HeapAddress end;

    public static void boot() {
        BootHeap.init();
        Assert._assert(BootHeap.INSTANCE.refInHeap(HeapAddress.addressOf(BootHeap.INSTANCE)));
    }

    public static boolean refInAnyHeap(HeapAddress heapAddress) {
        Iterator iterator = allHeaps.iterator();
        while (iterator.hasNext()) {
            Heap heap = (Heap)iterator.next();
            if (!heap.refInHeap(heapAddress)) continue;
            return true;
        }
        return false;
    }

    public static boolean addrInAnyHeap(HeapAddress heapAddress) {
        Iterator iterator = allHeaps.iterator();
        while (iterator.hasNext()) {
            Heap heap = (Heap)iterator.next();
            if (!heap.addrInHeap(heapAddress)) continue;
            return true;
        }
        return false;
    }

    public static void showAllHeaps() {
        Debug.writeln(allHeaps.size(), " heaps");
        int n = 0;
        Iterator iterator = allHeaps.iterator();
        while (iterator.hasNext()) {
            Debug.write("Heap ", n, ": ");
            Heap heap = (Heap)iterator.next();
            heap.show();
            ++n;
        }
    }

    public static void clobber(HeapAddress heapAddress, HeapAddress heapAddress2) {
        Debug.write("Zapping region ", heapAddress);
        Debug.write(" .. ", heapAddress2);
        Debug.writeln(" with 0xff****ff: ");
        int n = heapAddress2.difference(heapAddress);
        int n2 = 0;
        while (n2 < n) {
            int n3 = -16776961;
            heapAddress.offset(n2).poke4(n3 |= n2 & 0xFFFF00);
            n2 += 4;
        }
    }

    public void setRegion(HeapAddress heapAddress, HeapAddress heapAddress2) {
        this.start = heapAddress;
        this.end = heapAddress2;
    }

    public int getSize() {
        return this.end.difference(this.start);
    }

    public void zero() {
        boolean bl = false;
        if (this.start.difference(this.start.align(HeapAddress.pageAlign())) == 0) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (this.end.difference(this.end.align(HeapAddress.pageAlign())) == 0) {
            bl2 = true;
        }
        Assert._assert(bl2);
        int n = this.getSize();
        SystemInterface.mem_set(this.start, n, (byte)0);
    }

    public boolean refInHeap(HeapAddress heapAddress) {
        return this.addrInHeap(heapAddress);
    }

    public boolean addrInHeap(HeapAddress heapAddress) {
        boolean bl = false;
        if (heapAddress.difference(this.start) >= 0 && heapAddress.difference(this.end) <= 0) {
            bl = true;
        }
        return bl;
    }

    public void showRange() {
        Debug.write(this.start);
        Debug.write(" .. ", this.end);
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean bl) {
        int n = 26 - this.name.length();
        int n2 = 0;
        while (n2 < n) {
            Debug.write(" ");
            ++n2;
        }
        Debug.write(this.name);
        n2 = this.getSize();
        Debug.write(": ", n2 / 1024);
        Debug.write(" Kb  at  ");
        this.showRange();
        if (bl) {
            Debug.writeln();
        }
    }

    public void touchPages() {
        int n = 1 << HeapAddress.pageAlign();
        int n2 = this.getSize();
        int n3 = n2 - n;
        while (n3 >= 0) {
            this.start.offset(n3).poke4(0);
            n3 -= n;
        }
    }

    public void clobber() {
        Heap.clobber(this.start, this.end);
    }

    public final int paranoidScan(Heap heap, boolean bl) {
        int n = 0;
        Debug.write("Checking heap ");
        this.showRange();
        Debug.write(" for references to ");
        heap.showRange();
        Debug.writeln();
        HeapAddress heapAddress = this.start;
        while (heapAddress.difference(this.end) < 0) {
            HeapAddress heapAddress2 = (HeapAddress)heapAddress.peek();
            if ((heapAddress2.to32BitValue() & 3) == 0 && heap.refInHeap(heapAddress2)) {
                ++n;
                if (bl) {
                    Debug.write("Warning # ", n);
                    Debug.write("  loc ", heapAddress);
                    Debug.writeln(" holds poss ref ", heapAddress2);
                }
            }
            heapAddress = (HeapAddress)heapAddress.offset(HeapAddress.size());
        }
        Debug.write("\nThere were ", n);
        Debug.write(" suspicious references to ");
        heap.showRange();
        Debug.writeln();
        return n;
    }

    public final Object allocateObject(jq_Class jq_Class2) {
        Assert._assert(jq_Class2.isClsInitialized());
        int n = jq_Class2.getInstanceSize();
        Object object = jq_Class2.getVTable();
        return this.allocateObject(n, object);
    }

    public final Object allocateArray(jq_Array jq_Array2, int n) {
        Assert._assert(jq_Array2.isClsInitialized());
        int n2 = jq_Array2.getInstanceSize(n);
        Object object = jq_Array2.getVTable();
        return this.allocateArray(n, n2, object);
    }

    public final Object allocateObject(int n, Object object) throws OutOfMemoryError {
        HeapAddress heapAddress = this.allocateZeroedMemory(n);
        Object object2 = ObjectLayoutMethods.initializeObject(heapAddress, object, n);
        this.postAllocationProcessing(object2);
        return object2;
    }

    public final Object allocateArray(int n, int n2, Object object) throws OutOfMemoryError {
        n2 = HeapAddress.alignInt(n2, HeapAddress.logSize());
        HeapAddress heapAddress = this.allocateZeroedMemory(n2);
        Object object2 = ObjectLayoutMethods.initializeArray(heapAddress, object, n, n2);
        this.postAllocationProcessing(object2);
        return object2;
    }

    protected abstract HeapAddress allocateZeroedMemory(int var1);

    protected abstract void postAllocationProcessing(Object var1);

    private final /* synthetic */ void this() {
        this.verbose = 0;
    }

    protected Heap(String string) {
        this.this();
        this.name = string;
        this.start = this.end = HeapAddress.getNull();
        allHeaps.add(this);
    }
}

