/*
 * Decompiled with CFR 0.152.
 */
package Memory.Heap;

import Allocator.HeapAllocator;
import Memory.Address;
import Memory.Heap.Heap;
import Memory.Heap.ImmortalHeap;
import Memory.HeapAddress;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Util.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LargeHeap
extends Heap {
    private ImmortalHeap immortal;
    private final int pageSize = 4096;
    private final int GC_LARGE_SIZES = 20;
    private final int GC_INITIAL_LARGE_SPACE_PAGES = 200;
    private int usedPages;
    private int largeSpacePages;
    private int large_last_allocated;
    private short[] largeSpaceAlloc;
    private short[] largeSpaceMark;
    private int[] countLargeAlloc;

    public void init() {
        int n = 819200;
        this.start = (HeapAddress)SystemInterface.syscalloc(n);
        if (this.start.isNull()) {
            Debug.writeln("Panic!  Cannot allocate ", n, "bytes.");
            Assert.UNREACHABLE();
        }
        this.end = (HeapAddress)this.start.offset(n);
        this.largeSpaceAlloc = new short[200];
        this.largeSpaceMark = new short[200];
    }

    public int totalMemory() {
        return this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HeapAddress allocateZeroedMemory(int var1_1) {
        var2_2 = 0;
        block3: while (true) {
            var3_3 = (var1_1 + 4095) / 4096;
            var5_5 = this.largeSpacePages - var3_3;
            var6_6 = this;
            synchronized (var6_6) {
                while (true) {
                    block9: {
                        if (this.largeSpaceAlloc[this.large_last_allocated] != 0) break block9;
                        var4_4 = this.large_last_allocated;
                        if (true) ** GOTO lbl32
                    }
                    this.large_last_allocated += this.largeSpaceAlloc[this.large_last_allocated];
                }
                do {
                    var9_7 = var4_4 + 1;
                    while (var9_7 < var4_4 + var3_3) {
                        if (this.largeSpaceAlloc[var9_7] != 0) break;
                        ++var9_7;
                    }
                    if (var9_7 == var4_4 + var3_3) {
                        this.largeSpaceAlloc[var4_4 + var3_3 - 1] = (short)(-var3_3);
                        this.largeSpaceAlloc[var4_4] = (short)var3_3;
                        break block3;
                    }
                    var4_4 = var9_7 + this.largeSpaceAlloc[var9_7];
                    while (this.largeSpaceAlloc[var4_4] != 0) {
                        var4_4 += this.largeSpaceAlloc[var4_4];
                    }
lbl32:
                    // 2 sources

                } while (var4_4 <= var5_5);
            }
            HeapAllocator.heapExhausted(this, var1_1, var2_2++);
        }
        var5_5 = 1 << HeapAddress.pageAlign();
        var6_6 = (HeapAddress)this.start.offset(var5_5 * var4_4);
        SystemInterface.mem_set((Address)var6_6, var1_1, (byte)0);
        this.usedPages += var3_3;
        return var6_6;
    }

    protected void postAllocationProcessing(Object object) {
    }

    public void startCollect() {
        this.usedPages = 0;
        HeapAddress heapAddress = HeapAddress.addressOf(this.largeSpaceMark);
        SystemInterface.mem_set(heapAddress, this.largeSpaceMark.length * 2, (byte)0);
    }

    public void endCollect() {
        short[] sArray = this.largeSpaceAlloc;
        this.largeSpaceAlloc = this.largeSpaceMark;
        this.largeSpaceMark = sArray;
        this.large_last_allocated = 0;
    }

    public boolean isLive(HeapAddress heapAddress) {
        HeapAddress heapAddress2 = heapAddress;
        int n = heapAddress2.difference(this.start) >> 12;
        boolean bl = false;
        if (this.largeSpaceMark[n] != 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mark(HeapAddress heapAddress) {
        HeapAddress heapAddress2 = heapAddress;
        int n = heapAddress2.difference(this.start) >>> 12;
        boolean bl = false;
        if (this.largeSpaceMark[n] != 0) {
            return false;
        }
        boolean bl2 = bl;
        if (bl2) {
            return false;
        }
        LargeHeap largeHeap = this;
        synchronized (largeHeap) {
            boolean bl3 = false;
            if (this.largeSpaceMark[n] != 0) {
                return false;
            }
            bl2 = bl3;
            if (bl2) {
                return false;
            }
            short s = this.largeSpaceAlloc[n];
            this.usedPages += s > 0 ? s : -s;
            if (s == 1) {
                this.largeSpaceMark[n] = 1;
            } else {
                if (s > 0) {
                    int n2 = n + s - 1;
                    this.largeSpaceMark[n2] = -s;
                } else {
                    int n3 = n + s + 1;
                    this.largeSpaceMark[n3] = -s;
                }
                this.largeSpaceMark[n] = s;
            }
            return true;
        }
    }

    private final void countObjects() {
        int n = 0;
        while (n < 20) {
            this.countLargeAlloc[n] = 0;
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = 0;
        while (n < this.largeSpacePages) {
            short s = this.largeSpaceAlloc[n];
            if (s == 0) {
                this.countLargeAlloc[0] = this.countLargeAlloc[0] + 1;
                ++n3;
                ++n;
                continue;
            }
            if (s < 19) {
                short s2 = s;
                this.countLargeAlloc[s2] = this.countLargeAlloc[s2] + 1;
            } else {
                this.countLargeAlloc[19] = this.countLargeAlloc[19] + 1;
            }
            if (n3 > n2) {
                n2 = n3;
            }
            n3 = 0;
            n += s;
        }
        if (n3 > n2) {
            n2 = n3;
        }
        Debug.write("Large Objects Allocated - by num pages\n");
        n = 0;
        while (n < 19) {
            Debug.write("pages ");
            Debug.write(n);
            Debug.write(" count ");
            Debug.write(this.countLargeAlloc[n]);
            Debug.write("\n");
            ++n;
        }
        Debug.write(this.countLargeAlloc[19]);
        Debug.write(" large objects ");
        Debug.write(19);
        Debug.write(" pages or more.\n");
        Debug.write(this.countLargeAlloc[0]);
        Debug.write(" Large Object Space pages are free.\n");
        Debug.write(n2);
        Debug.write(" is largest block of contiguous free pages.\n");
        Debug.write(n4);
        Debug.write(" large objects are old.\n");
    }

    public int freeSpace() {
        return this.usedPages * 4096;
    }

    private final /* synthetic */ void this() {
        this.pageSize = 4096;
        this.GC_LARGE_SIZES = 20;
        this.GC_INITIAL_LARGE_SPACE_PAGES = 200;
        this.usedPages = 0;
    }

    public LargeHeap(ImmortalHeap immortalHeap) {
        super("Large Object Heap");
        this.this();
        this.immortal = immortalHeap;
        this.large_last_allocated = 0;
        this.largeSpacePages = 200;
        this.countLargeAlloc = new int[20];
    }
}

