/*
 * Decompiled with CFR 0.152.
 */
package Memory.Heap;

import Allocator.HeapAllocator;
import Allocator.ObjectLayoutMethods;
import Clazz.jq_Array;
import Memory.Address;
import Memory.Heap.BlockControl;
import Memory.Heap.Heap;
import Memory.Heap.ImmortalHeap;
import Memory.Heap.MallocHeap;
import Memory.Heap.SizeControl;
import Memory.HeapAddress;
import Memory.Manager.CollectorThread;
import Memory.Manager.GCConstants;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.jq_NativeThread;
import Util.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SegregatedListHeap
extends Heap
implements GCConstants {
    public static final boolean LITTLE_ENDIAN = true;
    private static final int OUT_OF_BLOCKS = -1;
    private static final int numBlocksToKeep = 10;
    private Object sysLockFree;
    private Object sysLockBlock;
    private BlockControl[] init_blocks;
    private BlockControl[] blocks;
    private int[] partialBlockList;
    private int num_blocks;
    private int first_freeblock;
    private int highest_block;
    private int blocks_available;
    private MallocHeap mallocHeap;

    /*
     * Unable to fully structure code
     */
    public void init(jq_NativeThread var1_1) {
        this.partialBlockList = new int[GCConstants.GC_SIZES];
        var2_2 = 0;
        while (var2_2 < GCConstants.GC_SIZES) {
            this.partialBlockList[var2_2] = -1;
            ++var2_2;
        }
        var1_1.sizes = new SizeControl[GCConstants.GC_SIZES];
        this.init_blocks = new BlockControl[GCConstants.GC_SIZES];
        var2_2 = 0;
        while (var2_2 < GCConstants.GC_SIZES) {
            var1_1.sizes[var2_2] = new SizeControl();
            this.init_blocks[var2_2] = new BlockControl();
            var1_1.sizes[var2_2].first_block = var2_2;
            var1_1.sizes[var2_2].current_block = var2_2;
            var1_1.sizes[var2_2].ndx = var2_2;
            this.init_blocks[var2_2].mark = new byte[16384 / GCConstants.GC_SIZEVALUES[var2_2]];
            var3_3 = 0;
            while (var3_3 < 16384 / GCConstants.GC_SIZEVALUES[var2_2]) {
                this.init_blocks[var2_2].mark[var3_3] = 0;
                ++var3_3;
            }
            this.init_blocks[var2_2].nextblock = -1;
            this.init_blocks[var2_2].slotsize = GCConstants.GC_SIZEVALUES[var2_2];
            ++var2_2;
        }
        var1_1.GC_INDEX_ARRAY = new SizeControl[(GCConstants.GC_MAX_SMALL_SIZE >> 2) + 1];
        var1_1.GC_INDEX_ARRAY[0] = var1_1.sizes[0];
        var2_2 = 0;
        var3_3 = 4;
        ** GOTO lbl36
        {
            var1_1.GC_INDEX_ARRAY[var3_3 >> 2] = var1_1.sizes[var2_2];
            var3_3 += 4;
            do {
                if (var3_3 <= GCConstants.GC_SIZEVALUES[var2_2]) continue block3;
                ++var2_2;
lbl36:
                // 2 sources

            } while (var2_2 < GCConstants.GC_SIZES);
        }
        var1_1.backingSLHeap = this;
    }

    public void boot(jq_NativeThread jq_NativeThread2, ImmortalHeap immortalHeap) {
        int n = 1024 + GCConstants.GC_SIZES;
        this.start = this.mallocHeap.allocateZeroedMemory(n * 16384);
        if (this.start.isNull()) {
            Debug.writeln("Panic!  Cannot allocate ", n * 16384, "bytes.");
            Assert.UNREACHABLE();
        }
        this.end = (HeapAddress)this.start.offset(n * 16384);
        this.blocks = this.init_blocks;
        int n2 = 0;
        while (n2 < GCConstants.GC_SIZES) {
            this.init_blocks[n2].baseAddr = (HeapAddress)this.start.offset(n2 * 16384);
            this.build_list_for_new_block(this.init_blocks[n2], jq_NativeThread2.sizes[n2]);
            ++n2;
        }
        n2 = this.getSize();
        this.num_blocks = n2 / 16384;
        this.blocks = (BlockControl[])immortalHeap.allocateArray(BlockControl._array, this.num_blocks);
        this.highest_block = this.num_blocks - 1;
        this.blocks_available = this.highest_block - GCConstants.GC_SIZES;
        int n3 = 0;
        while (n3 < GCConstants.GC_SIZES) {
            this.blocks[n3] = this.init_blocks[n3];
            ++n3;
        }
        this.first_freeblock = GCConstants.GC_SIZES;
        this.init_blocks = null;
        n3 = GCConstants.GC_SIZES;
        while (n3 < this.num_blocks) {
            BlockControl blockControl;
            this.blocks[n3] = blockControl = (BlockControl)immortalHeap.allocateObject(BlockControl._class);
            blockControl.baseAddr = (HeapAddress)this.start.offset(n3 * 16384);
            blockControl.nextblock = n3 == this.num_blocks - 1 ? -1 : n3 + 1;
            ++n3;
        }
    }

    protected HeapAddress allocateZeroedMemory(int n) {
        return SegregatedListHeap.allocateFastPath(n);
    }

    protected void postAllocationProcessing(Object object) {
    }

    public static HeapAddress allocateFastPath(int n) throws OutOfMemoryError {
        n = Address.alignInt(n, HeapAddress.logSize());
        jq_NativeThread jq_NativeThread2 = Unsafe.getThreadBlock().getNativeThread();
        HeapAddress heapAddress = HeapAddress.addressOf(jq_NativeThread2.GC_INDEX_ARRAY);
        heapAddress = (HeapAddress)heapAddress.offset(n);
        HeapAddress heapAddress2 = (HeapAddress)heapAddress.peek();
        SizeControl sizeControl = (SizeControl)heapAddress2.asObject();
        HeapAddress heapAddress3 = sizeControl.next_slot;
        if (heapAddress3.isNull()) {
            return jq_NativeThread2.backingSLHeap.allocateSlot(sizeControl, n);
        }
        return SegregatedListHeap.allocateSlotFast(sizeControl, heapAddress3);
    }

    public boolean mark(HeapAddress heapAddress) {
        HeapAddress heapAddress2 = heapAddress;
        int n = heapAddress2.difference(this.start) >> 14;
        BlockControl blockControl = this.blocks[n];
        int n2 = heapAddress2.difference(blockControl.baseAddr);
        int n3 = n2 / blockControl.slotsize;
        if (blockControl.mark[n3] != 0) {
            return false;
        }
        int n4 = 1;
        do {
            HeapAddress heapAddress3 = (HeapAddress)HeapAddress.addressOf(blockControl.mark).offset(n3 >> 2 << 2);
            int n5 = heapAddress3.peek4();
            if (blockControl.mark[n3] != 0) {
                return false;
            }
            int n6 = n3 % 4;
            int n7 = n4 << n6 * 8;
            int n8 = n5 | n7;
            heapAddress3.atomicCas4(n5, n8);
        } while (!Unsafe.isEQ());
        blockControl.live = true;
        return true;
    }

    public boolean isLive(HeapAddress heapAddress) {
        HeapAddress heapAddress2 = heapAddress;
        int n = heapAddress2.difference(this.start) >> 14;
        BlockControl blockControl = this.blocks[n];
        int n2 = heapAddress2.difference(blockControl.baseAddr);
        int n3 = n2 / blockControl.slotsize;
        boolean bl = false;
        if (blockControl.mark[n3] != 0) {
            bl = true;
        }
        return bl;
    }

    protected static HeapAddress allocateSlotFast(SizeControl sizeControl, HeapAddress heapAddress) throws OutOfMemoryError {
        HeapAddress heapAddress2 = heapAddress;
        sizeControl.next_slot = (HeapAddress)heapAddress2.peek();
        heapAddress2.poke(HeapAddress.getNull());
        return heapAddress2;
    }

    protected HeapAddress allocateSlot(SizeControl sizeControl, int n) throws OutOfMemoryError {
        HeapAddress heapAddress;
        int n2 = 0;
        do {
            HeapAddress heapAddress2;
            if (!(heapAddress2 = this.allocateSlotFromBlocks(sizeControl, n)).isNull()) {
                return heapAddress2;
            }
            HeapAllocator.heapExhausted(this, n, n2++);
            sizeControl = Unsafe.getThreadBlock().getNativeThread().GC_INDEX_ARRAY[n >> 2];
        } while ((heapAddress = sizeControl.next_slot).isNull());
        return SegregatedListHeap.allocateSlotFast(sizeControl, heapAddress);
    }

    protected HeapAddress allocateSlotFromBlocks(SizeControl sizeControl, int n) {
        BlockControl blockControl = this.blocks[sizeControl.current_block];
        while (blockControl.nextblock != -1) {
            sizeControl.current_block = blockControl.nextblock;
            blockControl = this.blocks[blockControl.nextblock];
            if (!this.build_list(blockControl, sizeControl)) continue;
            return SegregatedListHeap.allocateSlotFast(sizeControl, sizeControl.next_slot);
        }
        while (this.getPartialBlock(sizeControl.ndx) == 0) {
            sizeControl.current_block = blockControl.nextblock;
            blockControl = this.blocks[blockControl.nextblock];
            if (!this.build_list(blockControl, sizeControl)) continue;
            return SegregatedListHeap.allocateSlotFast(sizeControl, sizeControl.next_slot);
        }
        if (this.getnewblock(sizeControl.ndx) == 0) {
            int n2 = sizeControl.current_block = blockControl.nextblock;
            this.build_list_for_new_block(this.blocks[n2], sizeControl);
            return SegregatedListHeap.allocateSlotFast(sizeControl, sizeControl.next_slot);
        }
        return HeapAddress.getNull();
    }

    protected boolean build_list(BlockControl blockControl, SizeControl sizeControl) {
        byte[] byArray = blockControl.mark;
        boolean bl = false;
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 0) break;
            ++n;
        }
        if (n == byArray.length) {
            HeapAddress heapAddress = HeapAddress.addressOf(byArray);
            SystemInterface.mem_set(heapAddress, byArray.length, (byte)0);
            blockControl.live = false;
            return false;
        }
        HeapAddress heapAddress = (HeapAddress)blockControl.baseAddr.offset(n * blockControl.slotsize);
        SystemInterface.mem_set(heapAddress.offset(4), blockControl.slotsize - 4, (byte)0);
        sizeControl.next_slot = heapAddress;
        ++n;
        while (n < byArray.length) {
            if (byArray[n] == 0) break;
            ++n;
        }
        if (n == byArray.length) {
            heapAddress.poke(HeapAddress.getNull());
            HeapAddress heapAddress2 = HeapAddress.addressOf(byArray);
            SystemInterface.mem_set(heapAddress2, byArray.length, (byte)0);
            blockControl.live = false;
            return true;
        }
        HeapAddress heapAddress3 = (HeapAddress)blockControl.baseAddr.offset(n * blockControl.slotsize);
        heapAddress.poke(heapAddress3);
        heapAddress = heapAddress3;
        SystemInterface.mem_set(heapAddress.offset(4), blockControl.slotsize - 4, (byte)0);
        ++n;
        while (n < byArray.length) {
            if (byArray[n] == 0) {
                heapAddress3 = (HeapAddress)blockControl.baseAddr.offset(n * blockControl.slotsize);
                heapAddress.poke(heapAddress3);
                heapAddress = heapAddress3;
                SystemInterface.mem_set(heapAddress.offset(4), blockControl.slotsize - 4, (byte)0);
            }
            ++n;
        }
        heapAddress.poke(HeapAddress.getNull());
        HeapAddress heapAddress4 = HeapAddress.addressOf(byArray);
        SystemInterface.mem_set(heapAddress4, byArray.length, (byte)0);
        blockControl.live = false;
        return true;
    }

    protected void do_check(BlockControl blockControl, SizeControl sizeControl) {
        int n = 0;
        if (this.blocks[sizeControl.current_block] != blockControl) {
            Assert.UNREACHABLE("BlockControl Inconsistency");
        }
        HeapAddress heapAddress = sizeControl.next_slot;
        while (!heapAddress.isNull()) {
            if (heapAddress.difference(blockControl.baseAddr) < 0 || heapAddress.difference(blockControl.baseAddr.offset(16384)) > 0) {
                Assert.UNREACHABLE("Bad freelist");
            }
            ++n;
            heapAddress = (HeapAddress)heapAddress.peek();
        }
        if (n > blockControl.mark.length) {
            Assert.UNREACHABLE("too many slots");
        }
    }

    protected void build_list_for_new_block(BlockControl blockControl, SizeControl sizeControl) {
        byte[] byArray = blockControl.mark;
        HeapAddress heapAddress = blockControl.baseAddr;
        SystemInterface.mem_set(heapAddress, 16384, (byte)0);
        int n = blockControl.slotsize;
        sizeControl.next_slot = heapAddress;
        int n2 = 0;
        while (n2 < byArray.length - 1) {
            heapAddress.poke(heapAddress.offset(n));
            heapAddress = (HeapAddress)heapAddress.offset(n);
            ++n2;
        }
        HeapAddress heapAddress2 = HeapAddress.addressOf(byArray);
        SystemInterface.mem_set(heapAddress2, byArray.length, (byte)0);
        blockControl.live = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getnewblockx(int n) {
        int n2;
        BlockControl blockControl;
        Object object = this.sysLockBlock;
        synchronized (object) {
            if (this.first_freeblock == -1) {
                HeapAllocator.heapExhausted(this, 0, 0);
            }
            blockControl = this.blocks[this.first_freeblock];
            n2 = this.first_freeblock;
            this.first_freeblock = blockControl.nextblock;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var4_2
            blockControl.nextblock = -1;
        }
        blockControl.slotsize = GCConstants.GC_SIZEVALUES[n];
        int n3 = 16384 / GCConstants.GC_SIZEVALUES[n];
        if (blockControl.mark != null) {
            if (n3 <= blockControl.alloc_size) {
                ObjectLayoutMethods.setArrayLength(blockControl.mark, n3);
                return n2;
            }
            this.mallocHeap.atomicFreeArray(blockControl.mark);
        }
        blockControl.mark = (byte[])this.mallocHeap.atomicAllocateArray(jq_Array.BYTE_ARRAY, n3);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getPartialBlock(int n) {
        jq_NativeThread jq_NativeThread2 = Unsafe.getThreadBlock().getNativeThread();
        SizeControl sizeControl = jq_NativeThread2.sizes[n];
        BlockControl blockControl = this.blocks[sizeControl.current_block];
        Object object = this.sysLockBlock;
        synchronized (object) {
            if (this.partialBlockList[n] == -1) {
                return -1;
            }
            blockControl.nextblock = this.partialBlockList[n];
            BlockControl blockControl2 = this.blocks[this.partialBlockList[n]];
            this.partialBlockList[n] = blockControl2.nextblock;
            blockControl2.nextblock = -1;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getnewblock(int n) {
        jq_NativeThread jq_NativeThread2 = Unsafe.getThreadBlock().getNativeThread();
        SizeControl sizeControl = jq_NativeThread2.sizes[n];
        BlockControl blockControl = this.blocks[sizeControl.current_block];
        Object object = this.sysLockBlock;
        synchronized (object) {
            if (this.first_freeblock == -1) {
                return -1;
            }
            blockControl.nextblock = this.first_freeblock;
            blockControl = this.blocks[this.first_freeblock];
            this.first_freeblock = blockControl.nextblock;
        }
        blockControl.nextblock = -1;
        blockControl.slotsize = GCConstants.GC_SIZEVALUES[n];
        int n2 = 16384 / GCConstants.GC_SIZEVALUES[n];
        if (blockControl.mark != null) {
            if (n2 <= blockControl.alloc_size) {
                ObjectLayoutMethods.setArrayLength(blockControl.mark, n2);
                return 0;
            }
            this.mallocHeap.atomicFreeArray(blockControl.mark);
        }
        blockControl.mark = (byte[])this.mallocHeap.atomicAllocateArray(jq_Array.BYTE_ARRAY, n2);
        return 0;
    }

    protected int getndx(int n) {
        if (n <= GCConstants.GC_SIZEVALUES[0]) {
            return 0;
        }
        if (n <= GCConstants.GC_SIZEVALUES[1]) {
            return 1;
        }
        if (n <= GCConstants.GC_SIZEVALUES[2]) {
            return 2;
        }
        if (n <= GCConstants.GC_SIZEVALUES[3]) {
            return 3;
        }
        if (n <= GCConstants.GC_SIZEVALUES[4]) {
            return 4;
        }
        if (n <= GCConstants.GC_SIZEVALUES[5]) {
            return 5;
        }
        if (n <= GCConstants.GC_SIZEVALUES[6]) {
            return 6;
        }
        if (n <= GCConstants.GC_SIZEVALUES[7]) {
            return 7;
        }
        int n2 = 8;
        while (n2 < GCConstants.GC_SIZES) {
            if (n <= GCConstants.GC_SIZEVALUES[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected boolean isPtrInBlock(HeapAddress heapAddress, SizeControl sizeControl) {
        BlockControl blockControl = this.blocks[sizeControl.current_block];
        HeapAddress heapAddress2 = blockControl.baseAddr;
        int n = heapAddress.difference(heapAddress2);
        HeapAddress heapAddress3 = (HeapAddress)heapAddress.offset(blockControl.slotsize);
        if (n % blockControl.slotsize != 0) {
            Assert.UNREACHABLE("Ptr not to beginning of slot");
        }
        HeapAddress heapAddress4 = (HeapAddress)heapAddress2.offset(16384);
        boolean bl = false;
        if (heapAddress.difference(heapAddress2) >= 0 && heapAddress3.difference(heapAddress4) <= 0) {
            bl = true;
        }
        return bl;
    }

    void dumpblocks(jq_NativeThread jq_NativeThread2) {
        Debug.writeln("\n-- Processor ", jq_NativeThread2.getIndex(), " --");
        int n = 0;
        while (n < GCConstants.GC_SIZES) {
            Debug.write(" Size ", GCConstants.GC_SIZEVALUES[n], "  ");
            BlockControl blockControl = this.blocks[jq_NativeThread2.sizes[n].first_block];
            Debug.write(jq_NativeThread2.sizes[n].first_block);
            while (true) {
                Debug.write("  ", blockControl.nextblock);
                if (blockControl.nextblock == -1) break;
                blockControl = this.blocks[blockControl.nextblock];
            }
            Debug.writeln();
            ++n;
        }
    }

    void dumpblocks() {
        jq_NativeThread jq_NativeThread2 = Unsafe.getThreadBlock().getNativeThread();
        Debug.write(this.first_freeblock, "  is the first freeblock index \n");
        int n = 0;
        while (n < GCConstants.GC_SIZES) {
            Debug.write(n, "th SizeControl first_block = ", jq_NativeThread2.sizes[n].first_block);
            Debug.write(" current_block = ", jq_NativeThread2.sizes[n].current_block, "\n\n");
            ++n;
        }
        n = 0;
        while (n < this.num_blocks) {
            Debug.write(n, "th BlockControl   ");
            Debug.writeln(this.blocks[n].live ? "   live  " : "not live  ");
            Debug.writeln("baseaddr = ", this.blocks[n].baseAddr);
            Debug.writeln("nextblock = ", this.blocks[n].nextblock);
            ++n;
        }
    }

    void clobber(HeapAddress heapAddress, int n) {
        int n2 = -559030611;
        int n3 = 0;
        while (n3 + 3 < n) {
            heapAddress.offset(n3).poke4(n2);
            n3 += 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clobberfree() {
        int n;
        Object object;
        jq_NativeThread jq_NativeThread2 = Unsafe.getThreadBlock().getNativeThread();
        int n2 = 0;
        while (n2 < GCConstants.GC_SIZES) {
            BlockControl blockControl = this.blocks[jq_NativeThread2.sizes[n2].first_block];
            object = blockControl.mark;
            n = 0;
            while (n < ((byte[])object).length) {
                if (object[n] == 0) {
                    this.clobber((HeapAddress)blockControl.baseAddr.offset(n * GCConstants.GC_SIZEVALUES[n2]), GCConstants.GC_SIZEVALUES[n2]);
                }
                ++n;
            }
            n = blockControl.nextblock;
            while (n != -1) {
                blockControl = this.blocks[n];
                object = blockControl.mark;
                int n3 = 0;
                while (n3 < ((byte[])object).length) {
                    if (object[n3] == 0) {
                        this.clobber((HeapAddress)blockControl.baseAddr.offset(n3 * GCConstants.GC_SIZEVALUES[n2]), GCConstants.GC_SIZEVALUES[n2]);
                    }
                    ++n3;
                }
                n = blockControl.nextblock;
            }
            ++n2;
        }
        Object object2 = this.sysLockBlock;
        synchronized (object2) {
            n = this.first_freeblock;
            while (n != -1) {
                object = this.blocks[n];
                this.clobber(object.baseAddr, 16384);
                n = object.nextblock;
            }
            return;
        }
    }

    public long freeMemory() {
        return this.freeBlocks() * 16384;
    }

    public long partialBlockFreeMemory() {
        if (this.verbose >= 2) {
            Debug.write("WARNING: partialBlockFreeMemory not implemented; returning 0\n");
        }
        return 0L;
    }

    protected int emptyOfCurrentBlock(BlockControl blockControl, HeapAddress heapAddress) {
        int n = 0;
        while (!heapAddress.isNull()) {
            n += blockControl.slotsize;
            heapAddress = (HeapAddress)heapAddress.peek();
        }
        return n;
    }

    protected int emptyof(int n, byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] == 0) {
                n2 += GCConstants.GC_SIZEVALUES[n];
            }
            ++n3;
        }
        return n2;
    }

    protected int blocksInChain(BlockControl blockControl) {
        int n = blockControl.nextblock;
        int n2 = 1;
        while (n != -1) {
            ++n2;
            blockControl = this.blocks[n];
            n = blockControl.nextblock;
        }
        return n2;
    }

    protected int blocksToCurrent(SizeControl sizeControl) {
        int n = 1;
        if (sizeControl.first_block == sizeControl.current_block) {
            return 1;
        }
        BlockControl blockControl = this.blocks[sizeControl.first_block];
        int n2 = blockControl.nextblock;
        while (n2 != sizeControl.current_block) {
            ++n;
            blockControl = this.blocks[n2];
            n2 = blockControl.nextblock;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public void setupProcessor(jq_NativeThread var1_1) {
        var2_2 = SizeControl._array.getInstanceSize(GCConstants.GC_SIZES);
        var3_3 = SizeControl._class.getInstanceSize();
        var4_4 = var2_2 + var3_3 * GCConstants.GC_SIZES;
        var5_5 = this.mallocHeap.allocateZeroedMemory(var4_4);
        var1_1.sizes = (SizeControl[])ObjectLayoutMethods.initializeArray(var5_5, SizeControl._array.getVTable(), GCConstants.GC_SIZES, var2_2);
        var5_5 = (HeapAddress)var5_5.offset(var2_2);
        var6_6 = 0;
        while (var6_6 < GCConstants.GC_SIZES) {
            var1_1.sizes[var6_6] = (SizeControl)ObjectLayoutMethods.initializeObject(var5_5, SizeControl._class.getVTable(), var3_3);
            var5_5 = (HeapAddress)var5_5.offset(var3_3);
            ++var6_6;
        }
        var4_4 = SizeControl._array.getInstanceSize(GCConstants.GC_MAX_SMALL_SIZE + 1);
        var5_5 = this.mallocHeap.allocateZeroedMemory(var4_4);
        var1_1.GC_INDEX_ARRAY = (SizeControl[])ObjectLayoutMethods.initializeArray(var5_5, SizeControl._array.getVTable(), (GCConstants.GC_MAX_SMALL_SIZE >> 2) + 1, var4_4);
        var6_6 = 0;
        while (var6_6 < GCConstants.GC_SIZES) {
            var1_1.sizes[var6_6].first_block = var7_7 = this.getnewblockx(var6_6);
            var1_1.sizes[var6_6].current_block = var7_7;
            var1_1.sizes[var6_6].ndx = var6_6;
            this.build_list_for_new_block(this.blocks[var7_7], var1_1.sizes[var6_6]);
            ++var6_6;
        }
        var1_1.GC_INDEX_ARRAY[0] = var1_1.sizes[0];
        var6_6 = 0;
        var7_7 = 4;
        ** GOTO lbl33
        {
            var1_1.GC_INDEX_ARRAY[var7_7 >> 2] = var1_1.sizes[var6_6];
            var7_7 += 4;
            do {
                if (var7_7 <= GCConstants.GC_SIZEVALUES[var6_6]) continue block2;
                ++var6_6;
lbl33:
                // 2 sources

            } while (var6_6 < GCConstants.GC_SIZES);
        }
        var1_1.backingSLHeap = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int freeBlocks() {
        Object object = this.sysLockBlock;
        synchronized (object) {
            if (this.first_freeblock == -1) {
                return 0;
            }
            BlockControl blockControl = this.blocks[this.first_freeblock];
            int n = 1;
            int n2 = blockControl.nextblock;
            while (n2 != -1) {
                blockControl = this.blocks[n2];
                ++n;
                n2 = blockControl.nextblock;
            }
            return n;
        }
    }

    public void postCollectionReport() {
    }

    public void startCollect() {
        this.blocks_available = 0;
        int n = 0;
        while (n < GCConstants.GC_SIZES) {
            boolean bl = false;
            int n2 = this.partialBlockList[n];
            while (n2 != -1) {
                BlockControl blockControl = this.blocks[n2];
                HeapAddress heapAddress = HeapAddress.addressOf(blockControl.mark);
                SystemInterface.mem_set(heapAddress, blockControl.mark.length, (byte)0);
                blockControl.live = false;
                n2 = blockControl.nextblock;
            }
            ++n;
        }
    }

    public void zeromarks(jq_NativeThread jq_NativeThread2) {
        boolean bl = false;
        int n = 0;
        while (n < GCConstants.GC_SIZES) {
            BlockControl blockControl = this.blocks[jq_NativeThread2.sizes[n].current_block];
            int n2 = blockControl.nextblock;
            while (n2 != -1) {
                blockControl = this.blocks[n2];
                HeapAddress heapAddress = HeapAddress.addressOf(blockControl.mark);
                SystemInterface.mem_set(heapAddress, blockControl.mark.length, (byte)0);
                blockControl.live = false;
                n2 = blockControl.nextblock;
            }
            ++n;
        }
    }

    void setupallocation(jq_NativeThread jq_NativeThread2) {
        int n = 0;
        while (n < GCConstants.GC_SIZES) {
            BlockControl blockControl = this.blocks[jq_NativeThread2.sizes[n].first_block];
            SizeControl sizeControl = jq_NativeThread2.sizes[n];
            sizeControl.current_block = sizeControl.first_block;
            if (!this.build_list(blockControl, sizeControl)) {
                sizeControl.next_slot = HeapAddress.getNull();
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sweep(CollectorThread collectorThread) {
        int n;
        BlockControl blockControl;
        int n2 = -1;
        int n3 = 0;
        BlockControl blockControl2 = null;
        jq_NativeThread jq_NativeThread2 = Unsafe.getThreadBlock().getNativeThread();
        int n4 = 0;
        while (n4 < GCConstants.GC_SIZES) {
            blockControl = this.blocks[jq_NativeThread2.sizes[n4].first_block];
            SizeControl sizeControl = jq_NativeThread2.sizes[n4];
            sizeControl.current_block = sizeControl.first_block;
            if (!this.build_list(blockControl, sizeControl)) {
                sizeControl.next_slot = HeapAddress.getNull();
            }
            int n5 = blockControl.nextblock;
            sizeControl.lastBlockToKeep = -1;
            int n6 = 0;
            n = 0;
            while (n5 != -1) {
                BlockControl blockControl3 = this.blocks[n5];
                if (!blockControl3.live) {
                    if (blockControl2 == null) {
                        blockControl2 = blockControl3;
                    }
                    blockControl.nextblock = blockControl3.nextblock;
                    blockControl3.nextblock = n2;
                    n2 = n5;
                    ++n3;
                } else {
                    if (++n6 == 10) {
                        sizeControl.lastBlockToKeep = blockControl.baseAddr.difference(this.start) / 16384;
                    }
                    blockControl = blockControl3;
                }
                n5 = blockControl.nextblock;
            }
            sizeControl.last_allocated = blockControl.baseAddr.difference(this.start) / 16384;
            ++n4;
        }
        n4 = collectorThread.gcOrdinal - 1;
        while (n4 < GCConstants.GC_SIZES) {
            if (this.partialBlockList[n4] != -1) {
                blockControl = this.blocks[this.partialBlockList[n4]];
                int n7 = blockControl.nextblock;
                while (!blockControl.live) {
                    ++n3;
                    if (blockControl2 == null) {
                        blockControl2 = blockControl;
                    }
                    n7 = blockControl.nextblock;
                    blockControl.nextblock = n2;
                    n2 = blockControl.baseAddr.difference(this.start) / 16384;
                    this.partialBlockList[n4] = n7;
                    if (n7 == -1) break;
                    blockControl = this.blocks[n7];
                }
                if (n7 != -1) {
                    int n8 = blockControl.nextblock;
                    while (n8 != -1) {
                        BlockControl blockControl4 = this.blocks[n8];
                        if (!blockControl4.live) {
                            if (blockControl2 == null) {
                                blockControl2 = blockControl4;
                            }
                            blockControl.nextblock = blockControl4.nextblock;
                            blockControl4.nextblock = n2;
                            n2 = n8;
                            ++n3;
                        } else {
                            blockControl = blockControl4;
                        }
                        n8 = blockControl.nextblock;
                    }
                }
            }
            n4 += CollectorThread.numCollectors();
        }
        Object object = this.sysLockFree;
        synchronized (object) {
            if (blockControl2 != null) {
                blockControl2.nextblock = this.first_freeblock;
                this.first_freeblock = n2;
                this.blocks_available += n3;
            }
            int n9 = 0;
            while (n9 < GCConstants.GC_SIZES) {
                SizeControl sizeControl = jq_NativeThread2.sizes[n9];
                if (sizeControl.lastBlockToKeep != -1) {
                    BlockControl blockControl5 = this.blocks[sizeControl.lastBlockToKeep];
                    n = blockControl5.nextblock;
                    if (n != -1) {
                        this.blocks[sizeControl.last_allocated].nextblock = this.partialBlockList[n9];
                        this.partialBlockList[n9] = n;
                        blockControl5.nextblock = -1;
                    }
                }
                ++n9;
            }
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.sysLockFree = new Object();
        this.sysLockBlock = new Object();
    }

    public SegregatedListHeap(String string, MallocHeap mallocHeap) {
        super(string);
        this.this();
        this.mallocHeap = mallocHeap;
    }
}

