/*
 * Decompiled with CFR 0.152.
 */
package Memory.Manager;

import Allocator.DefaultHeapAllocator;
import Memory.HeapAddress;
import Memory.Manager.GCConstants;
import Memory.Manager.GCMapIteratorGroup;
import Memory.Manager.GCWorkQueue;
import Memory.Manager.Handshake;
import Memory.Manager.SynchronizationBarrier;
import Run_Time.Debug;
import Run_Time.Unsafe;
import Scheduler.jq_NativeThread;
import Util.AtomicCounter;

public class CollectorThread
extends Thread
implements GCConstants {
    private static final boolean debug_native = false;
    private static final boolean trace = false;
    static final boolean DISPLAY_OPTIONS_AT_BOOT = false;
    static final boolean TIME_GC_PHASES = false;
    static final boolean MEASURE_WAIT_TIMES = false;
    static final boolean MEASURE_RENDEZVOUS_TIMES = false;
    static final boolean SHOW_RENDEZVOUS_TIMES = false;
    public static AtomicCounter participantCount;
    public static CollectorThread[] collectorThreads;
    public static int collectionCount;
    static Handshake collect;
    static SynchronizationBarrier gcBarrier;
    boolean isActive;
    public int gcOrdinal;
    GCMapIteratorGroup iteratorGroup;
    HeapAddress putBufferStart;
    HeapAddress putBufferTop;
    HeapAddress getBufferStart;
    HeapAddress getBufferTop;
    HeapAddress getBufferEnd;
    HeapAddress extraBuffer;
    HeapAddress extraBuffer2;
    int timeInRendezvous;
    double stoppingTime;
    double startingTime;
    double rendezvousWaitTime;
    int copyCount;
    int rootWorkCount;
    int putWorkCount;
    int getWorkCount;
    int swapBufferCount;
    int putBufferCount;
    int getBufferCount;
    int bufferWaitCount;
    double bufferWaitTime;
    double finishWaitTime;
    int copyCount1;
    int rootWorkCount1;
    int putWorkCount1;
    int getWorkCount1;
    int swapBufferCount1;
    int putBufferCount1;
    int getBufferCount1;
    int bufferWaitCount1;
    double bufferWaitTime1;
    double finishWaitTime1;
    double totalBufferWait;
    double totalFinishWait;
    double totalRendezvousWait;

    static void init() {
        gcBarrier = new SynchronizationBarrier();
        collectorThreads = new CollectorThread[17];
    }

    static void collect(Handshake handshake) {
        handshake.requestAndAwaitCompletion();
    }

    public String toString() {
        return "VM_CollectorThread";
    }

    public static int numCollectors() {
        return participantCount.value();
    }

    public final int getGCOrdinal() {
        return this.gcOrdinal;
    }

    public void run() {
        while (true) {
            Unsafe.getThreadBlock().disableThreadSwitch();
            this.gcOrdinal = participantCount.increment();
            boolean bl = false;
            if (this.gcOrdinal == 1) {
                bl = true;
            }
            gcBarrier.startupRendezvous();
            if (this.gcOrdinal == 1) {
                GCWorkQueue.workQueue.initialSetup(participantCount.value());
            }
            if (this.isActive) {
                DefaultHeapAllocator.collect();
            }
            this.rendezvousWaitTime += gcBarrier.rendezvous(false);
            if (this.gcOrdinal == 1) {
                ++collectionCount;
                collect.notifyCompletion();
                collect = new Handshake();
            }
            this.rendezvousWaitTime += gcBarrier.rendezvous(false);
            boolean bl2 = false;
            if (this.gcOrdinal == 1) {
                bl2 = true;
            }
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
    }

    static void quiesceAttachedProcessors() {
    }

    static void resumeAttachedProcessors() {
    }

    public static CollectorThread createActiveCollectorThread(jq_NativeThread jq_NativeThread2) {
        return new CollectorThread(true, jq_NativeThread2);
    }

    static CollectorThread createPassiveCollectorThread(jq_NativeThread jq_NativeThread2) {
        return new CollectorThread(false, jq_NativeThread2);
    }

    void rendezvous() {
        this.rendezvousWaitTime += gcBarrier.rendezvous(false);
    }

    void rendezvousRecord(double d, double d2) {
    }

    static void printRendezvousTime() {
    }

    public static void boot(int n) {
    }

    void incrementWaitTimeTotals() {
        this.totalBufferWait += this.bufferWaitTime + this.bufferWaitTime1;
        this.totalFinishWait += this.finishWaitTime + this.finishWaitTime1;
        this.totalRendezvousWait += this.rendezvousWaitTime;
    }

    void resetWaitTimers() {
        this.bufferWaitTime = 0.0;
        this.bufferWaitTime1 = 0.0;
        this.finishWaitTime = 0.0;
        this.finishWaitTime1 = 0.0;
        this.rendezvousWaitTime = 0.0;
    }

    static void printThreadWaitTimes() {
        Debug.write("*** Collector Thread Wait Times (in micro-secs)\n");
        int n = 0;
        while (n < jq_NativeThread.native_threads.length) {
            CollectorThread collectorThread = (CollectorThread)jq_NativeThread.native_threads[n].getCurrentThread().getJavaLangThreadObject();
            Debug.write(n);
            Debug.write(" stop ");
            Debug.write((int)(collectorThread.stoppingTime * 1000000.0));
            Debug.write(" start ");
            Debug.write((int)(collectorThread.startingTime * 1000000.0));
            Debug.write(" SBW ");
            if (collectorThread.bufferWaitCount1 > 0) {
                Debug.write(collectorThread.bufferWaitCount1 - 1);
            } else {
                Debug.write(0);
            }
            Debug.write(" SBWT ");
            Debug.write((int)(collectorThread.bufferWaitTime1 * 1000000.0));
            Debug.write(" SFWT ");
            Debug.write((int)(collectorThread.finishWaitTime1 * 1000000.0));
            Debug.write(" FBW ");
            if (collectorThread.bufferWaitCount > 0) {
                Debug.write(collectorThread.bufferWaitCount - 1);
            } else {
                Debug.write(0);
            }
            Debug.write(" FBWT ");
            Debug.write((int)(collectorThread.bufferWaitTime * 1000000.0));
            Debug.write(" FFWT ");
            Debug.write((int)(collectorThread.finishWaitTime * 1000000.0));
            Debug.write(" RWT ");
            Debug.write((int)(collectorThread.rendezvousWaitTime * 1000000.0));
            Debug.write("\n");
            collectorThread.stoppingTime = 0.0;
            collectorThread.startingTime = 0.0;
            collectorThread.rendezvousWaitTime = 0.0;
            GCWorkQueue.resetWaitTimes(collectorThread);
            ++n;
        }
    }

    CollectorThread(boolean bl, jq_NativeThread jq_NativeThread2) {
        this.setDaemon(true);
        this.isActive = bl;
        CollectorThread.collectorThreads[jq_NativeThread2.getIndex()] = this;
    }

    static {
        collect = new Handshake();
        participantCount = new AtomicCounter(0);
    }
}

