/*
 * Decompiled with CFR 0.152.
 */
package Memory.Manager;

import Allocator.ObjectLayoutMethods;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_Reference;
import Memory.Address;
import Memory.CodeAddress;
import Memory.Heap.BootHeap;
import Memory.Heap.Heap;
import Memory.Heap.ImmortalHeap;
import Memory.Heap.LargeHeap;
import Memory.Heap.MallocHeap;
import Memory.Heap.SegregatedListHeap;
import Memory.HeapAddress;
import Memory.Manager.CollectorThread;
import Memory.Manager.GCConstants;
import Memory.Manager.GCUtil;
import Memory.Manager.GCWorkQueue;
import Memory.Manager.ScanObject;
import Memory.Manager.ScanStatics;
import Memory.Manager.ScanThreads;
import Memory.StackAddress;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.jq_NativeThread;
import Scheduler.jq_RegisterState;
import Util.Assert;
import java.lang.reflect.Array;

public class MarkAndSweep
implements GCConstants {
    static int verbose = 0;
    public static final boolean movesObjects = false;
    public static final boolean writeBarrier = false;
    static final int SMALL_SPACE_MAX = 2048;
    static final int GC_RETRY_COUNT = 3;
    static boolean flag2nd = false;
    static boolean gc_collect_now = false;
    private static BootHeap bootHeap = BootHeap.INSTANCE;
    private static MallocHeap mallocHeap = new MallocHeap();
    private static SegregatedListHeap smallHeap = new SegregatedListHeap("Small Object Heap", mallocHeap);
    public static ImmortalHeap immortalHeap = new ImmortalHeap();
    private static LargeHeap largeHeap = new LargeHeap(immortalHeap);
    static boolean gcInProgress = false;

    public static boolean gcInProgress() {
        return gcInProgress;
    }

    public static void init() {
        smallHeap.init(jq_NativeThread.initial_native_thread);
        CollectorThread.init();
    }

    public static void boot() {
        Heap.boot();
        jq_NativeThread jq_NativeThread2 = jq_NativeThread.initial_native_thread;
        smallHeap.boot(jq_NativeThread2, immortalHeap);
        if (verbose >= 1) {
            MarkAndSweep.showParameter();
        }
    }

    static void showParameter() {
        Debug.writeln("\nMark-Sweep Collector (verbose = ", verbose, ")");
        bootHeap.show();
        immortalHeap.show();
        smallHeap.show();
        largeHeap.show();
        Debug.writeln("  Work queue buffer size = ", GCWorkQueue.WORK_BUFFER_SIZE);
    }

    public static Object allocateObject(int n, Object[] objectArray) throws OutOfMemoryError {
        if (n > 2048) {
            return largeHeap.allocateObject(n, objectArray);
        }
        HeapAddress heapAddress = SegregatedListHeap.allocateFastPath(n);
        return ObjectLayoutMethods.initializeObject(heapAddress, objectArray, n);
    }

    public static Object allocateArray(int n, int n2, Object[] objectArray) throws OutOfMemoryError {
        if (n2 > 2048) {
            return largeHeap.allocateArray(n, n2, objectArray);
        }
        HeapAddress heapAddress = SegregatedListHeap.allocateFastPath(n2);
        return ObjectLayoutMethods.initializeArray(heapAddress, objectArray, n, n2);
    }

    public static void heapExhausted(Heap heap, int n, int n2) {
        boolean bl = false;
        if (n2 > 0) {
            bl = flag2nd = true;
        }
        if (heap == smallHeap) {
            if (n2 > 3) {
                GCUtil.outOfMemory("small object space", heap.getSize(), "-X:h=nnn");
            }
            MarkAndSweep.gc1("GC triggered by object request of ", n);
        } else if (heap == largeHeap) {
            if (n2 > 3) {
                GCUtil.outOfMemory("large object space", heap.getSize(), "-X:lh=nnn");
            }
            MarkAndSweep.gc1("GC triggered by large object request of ", n);
        } else {
            Assert.UNREACHABLE("unexpected heap");
        }
    }

    public static void gcSetup(int n) {
        GCWorkQueue.workQueue.initialSetup(n);
    }

    private static final void prepareNonParticipatingVPsForGC() {
    }

    private static final void prepareNonParticipatingVPsForAllocation() {
    }

    public static void collect() {
        if (!gc_collect_now) {
            return;
        }
        StackAddress stackAddress = StackAddress.getBasePointer();
        CodeAddress codeAddress = (CodeAddress)stackAddress.offset(4).peek();
        StackAddress stackAddress2 = (StackAddress)stackAddress.peek();
        jq_RegisterState jq_RegisterState2 = Unsafe.getThreadBlock().getRegisterState();
        jq_RegisterState2.setEip(codeAddress);
        jq_RegisterState2.setEbp(stackAddress2);
        CollectorThread collectorThread = (CollectorThread)Unsafe.getThreadBlock().getJavaLangThreadObject();
        if (gcInProgress) {
            Debug.write("VM_Allocator: Garbage Collection entered recursively \n");
            SystemInterface.die(1000);
        } else {
            gcInProgress = true;
        }
        GCWorkQueue.workQueue.initialSetup(CollectorThread.numCollectors());
        bootHeap.startCollect();
        immortalHeap.startCollect();
        largeHeap.startCollect();
        smallHeap.startCollect();
        MarkAndSweep.prepareNonParticipatingVPsForGC();
        collectorThread.rendezvous();
        GCWorkQueue.resetWorkQBuffers();
        smallHeap.zeromarks(Unsafe.getThreadBlock().getNativeThread());
        collectorThread.rendezvous();
        ScanStatics.scanStatics();
        ScanThreads.scanThreads(null);
        MarkAndSweep.gc_emptyWorkQueue();
        if (collectorThread.getGCOrdinal() == 1) {
            GCWorkQueue.workQueue.reset();
        }
        collectorThread.rendezvous();
        MarkAndSweep.gc_emptyWorkQueue();
        collectorThread.rendezvous();
        smallHeap.clobberfree();
        if (collectorThread.gcOrdinal == 1) {
            if (verbose >= 1) {
                Debug.write("Sweeping large space");
            }
            largeHeap.endCollect();
        }
        smallHeap.sweep(collectorThread);
        collectorThread.rendezvous();
        if (collectorThread.gcOrdinal == 1) {
            MarkAndSweep.prepareNonParticipatingVPsForAllocation();
            gc_collect_now = false;
            gcInProgress = false;
            CollectorThread.printRendezvousTime();
            smallHeap.postCollectionReport();
        }
    }

    static HeapAddress gc_getMatureSpace(int n) {
        Assert.UNREACHABLE();
        return null;
    }

    static void gc_scanObjectOrArray(HeapAddress heapAddress) {
        jq_Reference jq_Reference2 = jq_Reference.getTypeOf(heapAddress.asObject());
        if (jq_Reference2.isClassType()) {
            int[] nArray = ((jq_Class)jq_Reference2).getReferenceOffsets();
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                MarkAndSweep.processPtrValue((HeapAddress)heapAddress.offset(nArray[n]).peek());
                ++n;
            }
        } else if (jq_Reference2.isArrayType()) {
            if (((jq_Array)jq_Reference2).getElementType().isReferenceType()) {
                int n = Array.getLength(heapAddress.asObject());
                HeapAddress heapAddress2 = heapAddress;
                HeapAddress heapAddress3 = (HeapAddress)heapAddress.offset(n * 4);
                while (heapAddress2.difference(heapAddress3) < 0) {
                    MarkAndSweep.processPtrValue((HeapAddress)heapAddress2.peek());
                    heapAddress2 = (HeapAddress)heapAddress2.offset(HeapAddress.size());
                }
            }
        } else {
            Debug.write("VM_Allocator.gc_scanObjectOrArray: type not Array or Class");
            SystemInterface.die(1000);
        }
    }

    static void gc_emptyWorkQueue() {
        HeapAddress heapAddress = GCWorkQueue.getFromWorkBuffer();
        while (!heapAddress.isNull()) {
            MarkAndSweep.gc_scanObjectOrArray(heapAddress);
            heapAddress = GCWorkQueue.getFromWorkBuffer();
        }
    }

    public static void gc() {
        MarkAndSweep.gc1("GC triggered by external call to gc() ", 0);
    }

    public static void gc1(String string, int n) {
        gc_collect_now = true;
        if (verbose >= 1) {
            Debug.writeln(string, n);
        }
        CollectorThread.collect(CollectorThread.collect);
    }

    public static long totalMemory() {
        return smallHeap.getSize() + largeHeap.getSize();
    }

    public static long freeMemory() {
        return smallHeap.freeBlocks() * 16384;
    }

    public static long allSmallFreeMemory() {
        return MarkAndSweep.freeMemory() + smallHeap.partialBlockFreeMemory();
    }

    public static long allSmallUsableMemory() {
        return smallHeap.getSize();
    }

    static boolean gc_isLive(HeapAddress heapAddress) {
        if (bootHeap.refInHeap(heapAddress)) {
            return bootHeap.isLive(heapAddress);
        }
        if (immortalHeap.refInHeap(heapAddress)) {
            return immortalHeap.isLive(heapAddress);
        }
        if (smallHeap.refInHeap(heapAddress)) {
            return smallHeap.isLive(heapAddress);
        }
        if (largeHeap.refInHeap(heapAddress)) {
            return largeHeap.isLive(heapAddress);
        }
        Debug.write("gc_isLive: ref not in any known heap: ", heapAddress);
        Assert.UNREACHABLE();
        return false;
    }

    public static void setupProcessor(jq_NativeThread jq_NativeThread2) {
        if (jq_NativeThread2 != jq_NativeThread.initial_native_thread) {
            smallHeap.setupProcessor(jq_NativeThread2);
        }
    }

    public static void printclass(HeapAddress heapAddress) {
        jq_Reference jq_Reference2 = jq_Reference.getTypeOf(heapAddress.asObject());
        jq_Reference2.getDesc().debugWrite();
    }

    static void processWriteBufferEntry(HeapAddress heapAddress) {
        ScanObject.scanObjectOrArray(heapAddress);
    }

    public static Object getLiveObject(Object object) {
        return object;
    }

    public static boolean processFinalizerCandidate(HeapAddress heapAddress) {
        boolean bl = MarkAndSweep.gc_isLive(heapAddress);
        if (!bl) {
            MarkAndSweep.processPtrValue(heapAddress);
        }
        return bl;
    }

    public static void processPtrField(Address address) {
        address.poke(MarkAndSweep.processPtrValue((HeapAddress)address.peek()));
    }

    public static HeapAddress processPtrValue(HeapAddress heapAddress) {
        if (heapAddress.isNull()) {
            return heapAddress;
        }
        if (smallHeap.refInHeap(heapAddress)) {
            if (smallHeap.mark(heapAddress)) {
                GCWorkQueue.putToWorkBuffer(heapAddress);
            }
            return heapAddress;
        }
        if (largeHeap.refInHeap(heapAddress)) {
            if (largeHeap.mark(heapAddress)) {
                GCWorkQueue.putToWorkBuffer(heapAddress);
            }
            return heapAddress;
        }
        if (bootHeap.refInHeap(heapAddress)) {
            if (bootHeap.mark(heapAddress)) {
                GCWorkQueue.putToWorkBuffer(heapAddress);
            }
            return heapAddress;
        }
        if (immortalHeap.refInHeap(heapAddress)) {
            if (immortalHeap.mark(heapAddress)) {
                GCWorkQueue.putToWorkBuffer(heapAddress);
            }
            return heapAddress;
        }
        if (mallocHeap.refInHeap(heapAddress)) {
            return heapAddress;
        }
        Debug.write("processPtrValue: ref not in any known heap: ", heapAddress);
        Assert.UNREACHABLE();
        return null;
    }
}

