/*
 * Decompiled with CFR 0.152.
 */
package Memory.Manager;

import Allocator.DefaultHeapAllocator;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_Reference;
import Clazz.jq_Type;
import Memory.HeapAddress;
import Memory.Manager.GCUtil;
import Run_Time.Debug;
import java.lang.reflect.Array;

public class ScanObject {
    static void scanObjectOrArray(HeapAddress heapAddress) {
        block3: {
            jq_Reference jq_Reference2;
            Object object;
            block2: {
                object = heapAddress.asObject();
                jq_Reference2 = jq_Reference.getTypeOf(object);
                if (!jq_Reference2.isClassType()) break block2;
                int[] nArray = ((jq_Class)jq_Reference2).getReferenceOffsets();
                int n = 0;
                int n2 = nArray.length;
                while (n < n2) {
                    DefaultHeapAllocator.processPtrField(heapAddress.offset(nArray[n]));
                    ++n;
                }
                break block3;
            }
            jq_Type jq_Type2 = ((jq_Array)jq_Reference2).getElementType();
            if (!jq_Type2.isReferenceType()) break block3;
            int n = Array.getLength(object);
            int n3 = n * HeapAddress.size();
            HeapAddress heapAddress2 = (HeapAddress)heapAddress.offset(0);
            HeapAddress heapAddress3 = (HeapAddress)heapAddress2.offset(n3);
            while (heapAddress2.difference(heapAddress3) < 0) {
                DefaultHeapAllocator.processPtrField(heapAddress2);
                heapAddress2 = (HeapAddress)heapAddress2.offset(HeapAddress.size());
            }
        }
    }

    static void scanObjectOrArray(Object object) {
        ScanObject.scanObjectOrArray(HeapAddress.addressOf(object));
    }

    public static boolean validateRefs(HeapAddress heapAddress, int n) {
        block8: {
            jq_Reference jq_Reference2;
            block7: {
                if (heapAddress.isNull()) {
                    return true;
                }
                if (!GCUtil.validRef(heapAddress)) {
                    Debug.write("ScanObject.validateRefs: Bad Ref = ");
                    GCUtil.dumpRef(heapAddress);
                    return false;
                }
                if (n == 0) {
                    return true;
                }
                jq_Reference2 = jq_Reference.getTypeOf(heapAddress.asObject());
                if (!jq_Reference2.isClassType()) break block7;
                int[] nArray = ((jq_Class)jq_Reference2).getReferenceOffsets();
                int n2 = 0;
                int n3 = nArray.length;
                while (n2 < n3) {
                    HeapAddress heapAddress2 = (HeapAddress)heapAddress.offset(nArray[n2]).peek();
                    if (!ScanObject.validateRefs(heapAddress2, n - 1)) {
                        Debug.write("Referenced from Object: Ref = ");
                        GCUtil.dumpRef(heapAddress);
                        Debug.write("                  At Offset = ");
                        Debug.write(nArray[n2]);
                        Debug.write("\n");
                        return false;
                    }
                    ++n2;
                }
                break block8;
            }
            jq_Type jq_Type2 = ((jq_Array)jq_Reference2).getElementType();
            if (!jq_Type2.isReferenceType()) break block8;
            int n4 = Array.getLength(heapAddress.asObject());
            int n5 = 0;
            int n6 = n4 * HeapAddress.size();
            n5 = 0;
            while (n5 < n6) {
                HeapAddress heapAddress3 = (HeapAddress)heapAddress.offset(n5).peek();
                if (!ScanObject.validateRefs(heapAddress3, n - 1)) {
                    Debug.write("Referenced from Array: Ref = ");
                    GCUtil.dumpRef(heapAddress);
                    Debug.write("                  At Index = ");
                    Debug.write(n5 >> 2);
                    Debug.write("              Array Length = ");
                    Debug.write(n4);
                    Debug.write("\n");
                    return false;
                }
                n5 += HeapAddress.size();
            }
        }
        return true;
    }
}

