/*
 * Decompiled with CFR 0.152.
 */
package Run_Time;

import Main.jq;
import Memory.Address;
import Run_Time.BasicDebugImpl;
import UTF.Utf8;
import Util.Assert;

public abstract class Debug {
    private static byte[] buffer = new byte[16];
    private static int bufferIndex;
    private static Delegate _delegate;

    private static final void writeDecimalToBuffer(int n) {
        boolean bl = false;
        bufferIndex = -1;
        if (n < 0) {
            n = -n;
            Debug.buffer[++Debug.bufferIndex] = 45;
        }
        int n2 = 1000000000;
        while (n2 > 1) {
            int n3 = n / n2;
            n %= n2;
            if (bl || n3 != 0) {
                Debug.buffer[++Debug.bufferIndex] = (byte)(n3 + 48);
                bl = true;
            }
            n2 /= 10;
        }
        Debug.buffer[++Debug.bufferIndex] = (byte)(n + 48);
        Debug.buffer[++Debug.bufferIndex] = 0;
    }

    private static final void writeHexToBuffer(int n) {
        bufferIndex = -1;
        Debug.buffer[++Debug.bufferIndex] = 48;
        Debug.buffer[++Debug.bufferIndex] = 120;
        int n2 = 0;
        while (n2 < 8) {
            int n3 = (n & 0xF0000000) >>> 28;
            Debug.buffer[++Debug.bufferIndex] = n3 < 10 ? (byte)(n3 + 48) : (byte)(n3 + 97 - 10);
            n <<= 4;
            ++n2;
        }
        Debug.buffer[++Debug.bufferIndex] = 0;
        boolean bl = false;
        if (bufferIndex == 10) {
            bl = true;
        }
        Assert._assert(bl);
    }

    public static void write(String string) {
        _delegate.write(string);
    }

    public static void write(byte[] byArray, int n) {
        _delegate.write(byArray, n);
    }

    public static void write(Utf8 utf8) {
        utf8.debugWrite();
    }

    public static void write(char c) {
        Debug.buffer[0] = (byte)c;
        Debug.buffer[1] = 0;
        bufferIndex = 1;
        _delegate.write(buffer, bufferIndex);
    }

    public static void write(int n) {
        Debug.writeDecimalToBuffer(n);
        _delegate.write(buffer, bufferIndex);
    }

    public static void writeHex(int n) {
        Debug.writeHexToBuffer(n);
        _delegate.write(buffer, bufferIndex);
    }

    public static void write(Address address) {
        Debug.writeHex(address.to32BitValue());
    }

    public static void write(int n, String string) {
        Debug.write(n);
        Debug.write(string);
    }

    public static void write(String string, int n) {
        Debug.write(string);
        Debug.write(n);
    }

    public static void write(String string, Address address) {
        Debug.write(string);
        Debug.write(address);
    }

    public static void write(String string, int n, String string2) {
        Debug.write(string);
        Debug.write(n);
        Debug.write(string2);
    }

    public static void write(int n, String string, int n2) {
        Debug.write(n);
        Debug.write(string);
        Debug.write(n2);
    }

    public static void writeln() {
        Debug.writeln("");
    }

    public static void writeln(String string) {
        _delegate.writeln(string);
    }

    public static void writeln(Utf8 utf8) {
        utf8.debugWrite();
        Debug.writeln();
    }

    public static void writeln(int n) {
        Debug.writeDecimalToBuffer(n);
        _delegate.writeln(buffer, bufferIndex);
    }

    public static void writelnHex(int n) {
        Debug.writeHexToBuffer(n);
        _delegate.writeln(buffer, bufferIndex);
    }

    public static void writeln(Address address) {
        Debug.writelnHex(address.to32BitValue());
    }

    public static void writeln(int n, String string) {
        Debug.write(n);
        Debug.writeln(string);
    }

    public static void writeln(String string, int n) {
        Debug.write(string);
        Debug.writeln(n);
    }

    public static void writeln(String string, Address address) {
        Debug.write(string);
        Debug.writeln(address);
    }

    public static void writeln(String string, int n, String string2) {
        Debug.write(string);
        Debug.write(n);
        Debug.writeln(string2);
    }

    public static void die(int n) {
        _delegate.die(n);
    }

    private static final Delegate attemptDelegate(String string) {
        String string2 = "debug delegate";
        try {
            Class<?> clazz = Class.forName(string);
            return (Delegate)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find " + string2 + ' ' + string + ": " + classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Cannot instantiate " + string2 + ' ' + string + ": " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access " + string2 + ' ' + string + ": " + illegalAccessException);
        }
        return null;
    }

    static {
        _delegate = null;
        boolean bl = jq.nullVM;
        if (!bl) {
            _delegate = Debug.attemptDelegate("Run_Time.DebugImpl");
        }
        if (_delegate == null) {
            _delegate = new BasicDebugImpl();
        }
    }

    static interface Delegate {
        public void write(byte[] var1, int var2);

        public void write(String var1);

        public void writeln(byte[] var1, int var2);

        public void writeln(String var1);

        public void die(int var1);
    }
}

