/*
 * Decompiled with CFR 0.152.
 */
package Run_Time;

import Allocator.CodeAllocator;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_CompiledCode;
import Clazz.jq_Method;
import Clazz.jq_Reference;
import Clazz.jq_StaticMethod;
import Clazz.jq_TryCatch;
import Debugger.OnlineDebugger;
import Memory.CodeAddress;
import Memory.StackAddress;
import Run_Time.Monitor;
import Run_Time.Reflection;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import UTF.Utf8;
import Util.Assert;
import Util.Strings;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class ExceptionDeliverer {
    public static boolean TRACE = false;
    public static final jq_StaticMethod _athrow;
    public static final jq_StaticMethod _trap_handler;
    public static final jq_StaticMethod _debug_trap_handler;

    public static void athrow(Throwable throwable) {
        CodeAddress codeAddress = (CodeAddress)StackAddress.getBasePointer().offset(StackAddress.size()).peek();
        StackAddress stackAddress = (StackAddress)StackAddress.getBasePointer().peek();
        ExceptionDeliverer.deliverToCurrentThread(throwable, codeAddress, stackAddress);
        Assert.UNREACHABLE();
    }

    public static void trap_handler(int n) {
        switch (n) {
            case 0: {
                throw new NullPointerException();
            }
            case 1: {
                throw new ArrayIndexOutOfBoundsException();
            }
            case 2: {
                throw new ArithmeticException();
            }
            case 3: {
                throw new StackOverflowError();
            }
        }
        throw new InternalError("unknown hardware exception type: " + n);
    }

    public static void debug_trap_handler(int n) {
        boolean bl = OnlineDebugger.debuggerEntryPoint();
        if (bl) {
            SystemInterface.debugwriteln(">>> Passing on exception code " + n);
            ExceptionDeliverer.trap_handler(n);
            Assert.UNREACHABLE();
        }
    }

    public abstract void deliverToStackFrame(jq_CompiledCode var1, Throwable var2, jq_TryCatch var3, CodeAddress var4, StackAddress var5);

    public abstract Object getThisPointer(jq_CompiledCode var1, CodeAddress var2, StackAddress var3);

    public static void deliverToCurrentThread(Throwable throwable, CodeAddress codeAddress, StackAddress stackAddress) {
        jq_Class jq_Class2 = (jq_Class)jq_Reference.getTypeOf(throwable);
        if (TRACE) {
            SystemInterface.debugwriteln("Delivering exception of type " + jq_Class2 + " to ip=" + codeAddress.stringRep() + " fp=" + stackAddress.stringRep());
        }
        while (true) {
            Object object;
            jq_CompiledCode jq_CompiledCode2 = CodeAllocator.getCodeContaining(codeAddress);
            if (TRACE) {
                SystemInterface.debugwriteln("Checking compiled code " + jq_CompiledCode2);
            }
            if (jq_CompiledCode2 == null || stackAddress.isNull()) {
                System.out.println("Exception in thread \"" + Unsafe.getThreadBlock() + "\" " + throwable);
                throwable.printStackTrace(System.out);
                SystemInterface.die(-1);
                Assert.UNREACHABLE();
                return;
            }
            jq_TryCatch jq_TryCatch2 = jq_CompiledCode2.findCatchBlock(codeAddress, jq_Class2);
            if (jq_TryCatch2 != null) {
                object = (CodeAddress)jq_CompiledCode2.getStart().offset(jq_TryCatch2.getHandlerEntry());
                if (TRACE) {
                    SystemInterface.debugwriteln("Jumping to catch block at " + ((CodeAddress)object).stringRep());
                }
                jq_CompiledCode2.deliverException(jq_TryCatch2, stackAddress, throwable);
                Assert.UNREACHABLE();
                return;
            }
            if (jq_CompiledCode2.getMethod() != null && jq_CompiledCode2.getMethod().isSynchronized()) {
                if (jq_CompiledCode2.getMethod().isStatic()) {
                    object = Reflection.getJDKType(jq_CompiledCode2.getMethod().getDeclaringClass());
                    if (TRACE) {
                        SystemInterface.debugwriteln("Performing monitorexit on static method " + jq_CompiledCode2.getMethod() + ": object " + object);
                    }
                } else {
                    object = jq_CompiledCode2.getThisPointer(codeAddress, stackAddress);
                    if (TRACE) {
                        SystemInterface.debugwriteln("Performing monitorexit on instance method " + jq_CompiledCode2.getMethod() + ": object " + object.getClass() + '@' + Strings.hex(System.identityHashCode(object)));
                    }
                }
                Monitor.monitorexit(object);
            }
            codeAddress = (CodeAddress)stackAddress.offset(StackAddress.size()).peek();
            stackAddress = (StackAddress)stackAddress.peek();
        }
    }

    public static void printStackTrace(Object object, PrintWriter printWriter) {
        StackFrame stackFrame = (StackFrame)object;
        while (stackFrame.next != null) {
            String string;
            CodeAddress codeAddress = stackFrame.ip;
            jq_CompiledCode jq_CompiledCode2 = CodeAllocator.getCodeContaining(codeAddress);
            if (jq_CompiledCode2 != null) {
                jq_Method jq_Method2 = jq_CompiledCode2.getMethod();
                int n = codeAddress.difference(jq_CompiledCode2.getStart());
                if (jq_Method2 != null) {
                    Utf8 utf8 = jq_Method2.getDeclaringClass().getSourceFile();
                    int n2 = jq_CompiledCode2.getBytecodeIndex(codeAddress);
                    int n3 = jq_Method2.getLineNumber(n2);
                    string = "\tat " + jq_Method2 + " (" + utf8 + ':' + n3 + " bc:" + n2 + " off:" + Strings.hex(n) + ')';
                } else {
                    string = "\tat <unknown cc> (start:" + jq_CompiledCode2.getStart().stringRep() + " off:" + Strings.hex(n) + ')';
                }
            } else {
                string = "\tat <unknown addr> (ip:" + codeAddress.stringRep() + ')';
            }
            printWriter.println(string.toCharArray());
            stackFrame = stackFrame.next;
        }
    }

    public static void printStackTrace(Object object, PrintStream printStream) {
        StackFrame stackFrame = (StackFrame)object;
        while (stackFrame.next != null) {
            String string;
            CodeAddress codeAddress = stackFrame.ip;
            jq_CompiledCode jq_CompiledCode2 = CodeAllocator.getCodeContaining(codeAddress);
            if (jq_CompiledCode2 != null) {
                jq_Method jq_Method2 = jq_CompiledCode2.getMethod();
                int n = codeAddress.difference(jq_CompiledCode2.getStart());
                if (jq_Method2 != null) {
                    Utf8 utf8 = jq_Method2.getDeclaringClass().getSourceFile();
                    int n2 = jq_CompiledCode2.getBytecodeIndex(codeAddress);
                    int n3 = jq_Method2.getLineNumber(n2);
                    string = "\tat " + jq_Method2 + " (" + utf8 + ':' + n3 + " bc:" + n2 + " off:" + Strings.hex(n) + ')';
                } else {
                    string = "\tat <unknown cc> (start:" + jq_CompiledCode2.getStart().stringRep() + " off:" + Strings.hex(n) + ')';
                }
            } else {
                string = "\tat <unknown addr> (ip:" + codeAddress.stringRep() + ')';
            }
            printStream.println(string.toCharArray());
            stackFrame = stackFrame.next;
        }
    }

    public static void printStackTrace(Object object) {
        StackFrame stackFrame = (StackFrame)object;
        while (stackFrame.next != null) {
            String string;
            CodeAddress codeAddress = stackFrame.ip;
            jq_CompiledCode jq_CompiledCode2 = CodeAllocator.getCodeContaining(codeAddress);
            if (jq_CompiledCode2 != null) {
                jq_Method jq_Method2 = jq_CompiledCode2.getMethod();
                int n = codeAddress.difference(jq_CompiledCode2.getStart());
                if (jq_Method2 != null) {
                    Utf8 utf8 = jq_Method2.getDeclaringClass().getSourceFile();
                    int n2 = jq_CompiledCode2.getBytecodeIndex(codeAddress);
                    int n3 = jq_Method2.getLineNumber(n2);
                    string = "\tat " + jq_Method2 + " (" + utf8 + ':' + n3 + " bc:" + n2 + " off:" + Strings.hex(n) + ')';
                } else {
                    string = "\tat <unknown cc> (start:" + jq_CompiledCode2.getStart().stringRep() + " off:" + Strings.hex(n) + ')';
                }
            } else {
                string = "\tat <unknown addr> (ip:" + codeAddress.stringRep() + ')';
            }
            SystemInterface.debugwriteln(string);
            stackFrame = stackFrame.next;
        }
    }

    public static Object getStackTrace() {
        CodeAddress codeAddress = (CodeAddress)StackAddress.getBasePointer().offset(StackAddress.size()).peek();
        StackAddress stackAddress = (StackAddress)StackAddress.getBasePointer().peek();
        StackFrame stackFrame = new StackFrame(stackAddress, codeAddress);
        stackFrame.fillInStackTrace();
        return stackFrame;
    }

    static {
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LRun_Time/ExceptionDeliverer;");
        _athrow = jq_Class2.getOrCreateStaticMethod("athrow", "(Ljava/lang/Throwable;)V");
        _trap_handler = jq_Class2.getOrCreateStaticMethod("trap_handler", "(I)V");
        _debug_trap_handler = jq_Class2.getOrCreateStaticMethod("debug_trap_handler", "(I)V");
    }

    public static class StackFrame {
        protected StackAddress fp;
        protected CodeAddress ip;
        protected StackFrame next;

        public void fillInStackTrace() {
            StackFrame stackFrame = this;
            while (!stackFrame.fp.isNull()) {
                CodeAddress codeAddress = (CodeAddress)stackFrame.fp.offset(StackAddress.size()).peek();
                StackAddress stackAddress = (StackAddress)stackFrame.fp.peek();
                stackFrame = stackFrame.next = new StackFrame(stackAddress, codeAddress);
            }
        }

        public int getSize() {
            StackFrame stackFrame = this;
            int n = 0;
            while (stackFrame != null) {
                stackFrame = stackFrame.next;
                ++n;
            }
            return n;
        }

        public StackFrame getNext() {
            return this.next;
        }

        public StackAddress getFP() {
            return this.fp;
        }

        public CodeAddress getIP() {
            return this.ip;
        }

        public String toString() {
            return CodeAllocator.getCodeContaining(this.ip) + " ip=" + this.ip.stringRep() + " fp=" + this.fp.stringRep();
        }

        public StackFrame(StackAddress stackAddress, CodeAddress codeAddress) {
            this.fp = stackAddress;
            this.ip = codeAddress;
        }
    }
}

