/*
 * Decompiled with CFR 0.152.
 */
package Run_Time;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;

public abstract class MathSupport {
    public static double maxint = 2.147483647E9;
    public static double minint = -2.147483648E9;
    public static double maxlong = 9.223372036854776E18;
    public static double minlong = -9.223372036854776E18;
    public static final jq_Class _class = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LRun_Time/MathSupport;");
    public static final jq_StaticMethod _lmul = _class.getOrCreateStaticMethod("lmul", "(JJ)J");
    public static final jq_StaticMethod _ldiv = _class.getOrCreateStaticMethod("ldiv", "(JJ)J");
    public static final jq_StaticMethod _lrem = _class.getOrCreateStaticMethod("lrem", "(JJ)J");
    public static final jq_StaticField _maxint = _class.getOrCreateStaticField("maxint", "D");
    public static final jq_StaticField _minint = _class.getOrCreateStaticField("minint", "D");
    public static final jq_StaticField _maxlong = _class.getOrCreateStaticField("maxlong", "D");
    public static final jq_StaticField _minlong = _class.getOrCreateStaticField("minlong", "D");

    public static boolean ucmp(int n, int n2) {
        if (n2 < 0 && n >= 0) {
            return true;
        }
        if (n2 >= 0 && n < 0) {
            return false;
        }
        boolean bl = false;
        if (n < n2) {
            bl = true;
        }
        return bl;
    }

    public static boolean ulcmp(long l, long l2) {
        if (l2 < 0L && l >= 0L) {
            return true;
        }
        if (l2 >= 0L && l < 0L) {
            return false;
        }
        boolean bl = false;
        if (l < l2) {
            bl = true;
        }
        return bl;
    }

    public static int udiv(int n, int n2) {
        if (n2 < 0) {
            if (n < 0 && n >= n2) {
                return 1;
            }
            return 0;
        }
        if (n >= 0) {
            return n / n2;
        }
        int n3 = n >>> 1;
        int n4 = n3 / n2;
        int n5 = (n3 % n2 << 1) + (n & 1);
        return (n4 << 1) + n5 / n2;
    }

    public static int urem(int n, int n2) {
        if (n2 < 0) {
            if (n < 0 && n >= n2) {
                return n - n2;
            }
            return n;
        }
        if (n >= 0) {
            return n % n2;
        }
        int n3 = n >>> 1;
        int n4 = (n3 % n2 << 1) + (n & 1);
        return n4 % n2;
    }

    public static long umul(int n, int n2) {
        char c = (char)n;
        char c2 = (char)(n >> 16);
        char c3 = (char)n2;
        char c4 = (char)(n2 >> 16);
        long l = 0L;
        int n3 = c * c3;
        if (n3 < 0) {
            l += Integer.MAX_VALUE;
            n3 -= Integer.MAX_VALUE;
        }
        l += (long)n3;
        n3 = c2 * c3;
        if (n3 < 0) {
            l += 0x7FFFFFFF0000L;
            n3 -= Integer.MAX_VALUE;
        }
        l += (long)n3 << 16;
        n3 = c * c4;
        if (n3 < 0) {
            l += 0x7FFFFFFF0000L;
            n3 -= Integer.MAX_VALUE;
        }
        return l += (long)n3 << 16;
    }

    public static long imul(int n, int n2) {
        int n3;
        int n4;
        boolean bl;
        int n5;
        char c = MathSupport.HHALF(n);
        char c2 = MathSupport.LHALF(n);
        char c3 = MathSupport.HHALF(n2);
        char c4 = MathSupport.LHALF(n2);
        int n6 = c2 * c4;
        if (c == '\u0000' && c3 == '\u0000') {
            return (long)n6 & (long)-1;
        }
        if (!MathSupport.ucmp(c, c2)) {
            n5 = c - c2;
            bl = false;
        } else {
            n5 = c2 - c;
            bl = true;
        }
        if (!MathSupport.ucmp(c4, c3)) {
            n4 = c4 - c3;
        } else {
            n4 = c3 - c4;
            bl ^= true;
        }
        int n7 = n5 * n4;
        int n8 = c * c3;
        int n9 = n8 + MathSupport.HHALF(n8);
        int n10 = MathSupport.LHUP(n8);
        if (bl) {
            n3 = n10;
            n9 -= MathSupport.HHALF(n7) + MathSupport.ucmp(n3, n10 -= MathSupport.LHUP(n7));
        } else {
            n3 = n10;
            n9 += MathSupport.HHALF(n7) + MathSupport.ucmp(n10 += MathSupport.LHUP(n7), n3);
        }
        n3 = n10;
        n9 += MathSupport.HHALF(n6) + MathSupport.ucmp(n10 += MathSupport.LHUP(n6), n3);
        if (MathSupport.ucmp(n10 += n6, n6)) {
            ++n9;
        }
        return MathSupport.COMBINEQ(n9, n10);
    }

    public static long lmul(long l, long l2) {
        long l3;
        long l4;
        boolean bl;
        long l5;
        if (l >= 0L) {
            l5 = l;
            bl = false;
        } else {
            l5 = -l;
            bl = true;
        }
        if (l2 >= 0L) {
            l4 = l2;
        } else {
            l4 = -l2;
            bl ^= true;
        }
        int n = MathSupport.HHALFQ(l5);
        int n2 = MathSupport.LHALFQ(l5);
        int n3 = MathSupport.HHALFQ(l4);
        int n4 = MathSupport.LHALFQ(l4);
        if (n == 0 && n3 == 0) {
            l3 = MathSupport.imul(n2, n4);
        } else {
            int n5;
            int n6;
            boolean bl2;
            long l6 = MathSupport.imul(n2, n4);
            if (!MathSupport.ucmp(n, n2)) {
                bl2 = false;
                n6 = n - n2;
            } else {
                bl2 = true;
                n6 = n2 - n;
            }
            if (!MathSupport.ucmp(n4, n3)) {
                n5 = n4 - n3;
            } else {
                n5 = n3 - n4;
                bl2 ^= true;
            }
            int n7 = n6 * n5;
            int n8 = (int)MathSupport.umul(n, n3);
            l3 = MathSupport.COMBINEQ(n8 + (bl2 ? -n7 : n7) + MathSupport.LHALFQ(l6) + MathSupport.HHALFQ(l6), MathSupport.HHALFQ(l6));
        }
        return bl ? -l3 : l3;
    }

    public static long ulmul(long l, long l2) {
        char c = (char)l;
        char c2 = (char)(l >> 16);
        char c3 = (char)(l >> 32);
        char c4 = (char)(l >> 48);
        char c5 = (char)l2;
        char c6 = (char)(l2 >> 16);
        char c7 = (char)(l2 >> 32);
        char c8 = (char)(l2 >> 48);
        long l3 = 0L;
        int n = c * c5;
        if (n < 0) {
            l3 += Integer.MAX_VALUE;
            n -= Integer.MAX_VALUE;
        }
        l3 += (long)n;
        n = c2 * c5;
        if (n < 0) {
            l3 += 0x7FFFFFFF0000L;
            n -= Integer.MAX_VALUE;
        }
        l3 += (long)n << 16;
        n = c * c6;
        if (n < 0) {
            l3 += 0x7FFFFFFF0000L;
            n -= Integer.MAX_VALUE;
        }
        l3 += (long)n << 16;
        n = c3 * c5;
        if (n < 0) {
            l3 += 0x7FFFFFFF00000000L;
            n -= Integer.MAX_VALUE;
        }
        l3 += (long)n << 32;
        n = c2 * c6;
        if (n < 0) {
            l3 += 0x7FFFFFFF00000000L;
            n -= Integer.MAX_VALUE;
        }
        l3 += (long)n << 32;
        n = c * c7;
        if (n < 0) {
            l3 += 0x7FFFFFFF00000000L;
            n -= Integer.MAX_VALUE;
        }
        l3 += (long)n << 32;
        n = c4 * c5;
        if (n < 0) {
            l3 += -281474976710656L;
            n -= Integer.MAX_VALUE;
        }
        l3 += (long)n << 48;
        n = c3 * c6;
        if (n < 0) {
            l3 += -281474976710656L;
            n -= Integer.MAX_VALUE;
        }
        l3 += (long)n << 48;
        n = c2 * c7;
        if (n < 0) {
            l3 += -281474976710656L;
            n -= Integer.MAX_VALUE;
        }
        l3 += (long)n << 48;
        n = c * c8;
        if (n < 0) {
            l3 += -281474976710656L;
            n -= Integer.MAX_VALUE;
        }
        return l3 += (long)n << 48;
    }

    public static long ldiv(long l, long l2) {
        boolean bl = false;
        if (l < 0L) {
            l = -l;
            bl ^= true;
        }
        if (l2 < 0L) {
            l2 = -l2;
            bl ^= true;
        }
        l = MathSupport.uldivrem(l, l2, false);
        if (bl) {
            l = -l;
        }
        return l;
    }

    public static long lrem(long l, long l2) {
        boolean bl = false;
        if (l < 0L) {
            l = -l;
            bl ^= true;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        l = MathSupport.uldivrem(l, l2, true);
        if (bl) {
            l = -l;
        }
        return l;
    }

    private static final int HHALFQ(long l) {
        return (int)(l >> 32);
    }

    private static final int LHALFQ(long l) {
        return (int)l;
    }

    private static final char HHALF(int n) {
        return (char)(n >> 16);
    }

    private static final char LHALF(int n) {
        return (char)n;
    }

    private static final int LHUP(int n) {
        return n << 16;
    }

    private static final int COMBINE(char c, char c2) {
        return c << 16 | c2;
    }

    private static final long COMBINEQ(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static long uldivrem(long l, long l2, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (l2 == 0L) {
            throw new ArithmeticException();
        }
        if (MathSupport.ulcmp(l, l2)) {
            if (bl) {
                return l;
            }
            return 0L;
        }
        char[] cArray = new char[5];
        char[] cArray2 = new char[5];
        char[] cArray3 = new char[5];
        cArray[0] = '\u0000';
        cArray[1] = MathSupport.HHALF(MathSupport.HHALFQ(l));
        cArray[2] = MathSupport.LHALF(MathSupport.HHALFQ(l));
        cArray[3] = MathSupport.HHALF(MathSupport.LHALFQ(l));
        cArray[4] = MathSupport.LHALF(MathSupport.LHALFQ(l));
        cArray2[1] = MathSupport.HHALF(MathSupport.HHALFQ(l2));
        cArray2[2] = MathSupport.LHALF(MathSupport.HHALFQ(l2));
        cArray2[3] = MathSupport.HHALF(MathSupport.LHALFQ(l2));
        cArray2[4] = MathSupport.LHALF(MathSupport.LHALFQ(l2));
        int n4 = 4;
        while (cArray2[n2 + 1] == '\u0000') {
            if (--n4 == 1) {
                char c = cArray2[n2 + 2];
                char c2 = (char)MathSupport.udiv(cArray[n + 1], c);
                int n5 = MathSupport.COMBINE((char)MathSupport.urem(cArray[n + 1], c), cArray[n + 2]);
                char c3 = (char)MathSupport.udiv(n5, c);
                n5 = MathSupport.COMBINE((char)MathSupport.urem(n5, c), cArray[n + 3]);
                char c4 = (char)MathSupport.udiv(n5, c);
                n5 = MathSupport.COMBINE((char)MathSupport.urem(n5, c), cArray[n + 4]);
                char c5 = (char)MathSupport.udiv(n5, c);
                if (bl) {
                    return MathSupport.urem(n5, c);
                }
                return MathSupport.COMBINEQ(MathSupport.COMBINE(c2, c3), MathSupport.COMBINE(c4, c5));
            }
            ++n2;
        }
        int n6 = 4 - n4;
        while (cArray[n + 1] == '\u0000') {
            --n6;
            ++n;
        }
        int n7 = 4 - n6;
        while (--n7 >= 0) {
            cArray3[n3 + n7] = '\u0000';
        }
        n3 += 4 - n6;
        int n8 = 0;
        int n9 = cArray2[n2 + 1];
        while (MathSupport.ucmp(n9, 32768)) {
            ++n8;
            n9 <<= 1;
        }
        if (n8 > 0) {
            MathSupport.shl(cArray, n, n6 + n4, n8);
            MathSupport.shl(cArray2, n2 + 1, n4 - 1, n8);
        }
        int n10 = 0;
        char c = cArray2[n2 + 1];
        char c6 = cArray2[n2 + 2];
        do {
            int n11;
            int n12;
            char c7 = cArray[n + n10];
            int n13 = cArray[n + n10 + 1];
            char c8 = cArray[n + n10 + 2];
            boolean bl2 = false;
            if (c7 == c) {
                n12 = 65536;
                n11 = n13;
                bl2 = true;
            } else {
                int n14 = MathSupport.COMBINE(c7, (char)n13);
                n12 = MathSupport.udiv(n14, c);
                n11 = MathSupport.urem(n14, c);
            }
            while (bl2 || MathSupport.ucmp(MathSupport.COMBINE((char)n11, c8), (int)MathSupport.umul(c6, n12))) {
                bl2 = false;
                --n12;
                if ((n11 += c) >= 65536) break;
            }
            n9 = 0;
            n7 = n4;
            while (n7 > 0) {
                n9 = cArray[n + n7 + n10] - (int)MathSupport.umul(cArray2[n2 + n7], n12) - n9;
                cArray[n + n7 + n10] = MathSupport.LHALF(n9);
                n9 = 65536 - MathSupport.HHALF(n9) & (char)-1;
                --n7;
            }
            n9 = cArray[n + n10] - n9;
            cArray[n + n10] = MathSupport.LHALF(n9);
            if (MathSupport.HHALF(n9) != '\u0000') {
                --n12;
                n9 = 0;
                n7 = n4;
                while (n7 > 0) {
                    cArray[n + n7 + n10] = MathSupport.LHALF(n9 += cArray[n + n7 + n10] + cArray2[n2 + n7]);
                    n9 = MathSupport.HHALF(n9);
                    --n7;
                }
                cArray[n + n10] = MathSupport.LHALF(cArray[n + n10] + n9);
            }
            cArray3[n3 + n10] = (char)n12;
        } while (++n10 <= n6);
        if (bl) {
            if (n8 != 0) {
                n7 = n6 + n4;
                while (n7 > n6) {
                    cArray[n + n7] = (char)(cArray[n + n7] >>> n8 | MathSupport.LHALF(cArray[n + n7 - 1] << 16 - n8));
                    --n7;
                }
                cArray[n + n7] = '\u0000';
            }
            return MathSupport.COMBINEQ(MathSupport.COMBINE(cArray[1], cArray[2]), MathSupport.COMBINE(cArray[3], cArray[4]));
        }
        return MathSupport.COMBINEQ(MathSupport.COMBINE(cArray3[1], cArray3[2]), MathSupport.COMBINE(cArray3[3], cArray3[4]));
    }

    private static final void shl(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            cArray[n + n4] = (char)(MathSupport.LHALF(cArray[n + n4] << n3) | cArray[n + n4 + 1] >>> 16 - n3);
            ++n4;
        }
        cArray[n + n4] = MathSupport.LHALF(cArray[n + n4] << n3);
    }
}

