/*
 * Decompiled with CFR 0.152.
 */
package Run_Time;

import Allocator.DefaultHeapAllocator;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_StaticMethod;
import Memory.HeapAddress;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.jq_Thread;
import Util.Assert;
import Util.Strings;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Monitor {
    public static boolean TRACE = false;
    public static final jq_Class _class = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LRun_Time/Monitor;");
    public static final jq_StaticMethod _monitorenter = _class.getOrCreateStaticMethod("monitorenter", "(Ljava/lang/Object;)V");
    public static final jq_StaticMethod _monitorexit = _class.getOrCreateStaticMethod("monitorexit", "(Ljava/lang/Object;)V");
    public static final jq_InstanceField _atomic_count = _class.getOrCreateInstanceField("atomic_count", "I");
    int atomic_count;
    jq_Thread monitor_owner;
    int entry_count;
    int semaphore;

    public static int getLockEntryCount(Object object) {
        int n = HeapAddress.addressOf(object).offset(-8).peek4();
        if (n < 0) {
            Monitor monitor = Monitor.getMonitor(n);
            if (TRACE) {
                SystemInterface.debugwriteln("Getting fat lock entry count: " + monitor.entry_count);
            }
            return monitor.entry_count;
        }
        int n2 = (n & 0x1F0) >> 4;
        if ((n & 0x7FFFFE00) != 0) {
            ++n2;
        }
        if (TRACE) {
            SystemInterface.debugwriteln("Getting thin lock entry count, lockword=" + Strings.hex8(n) + ", count=" + n2);
        }
        return n2;
    }

    public static void monitorenter(Object object) {
        jq_Thread jq_Thread2 = Unsafe.getThreadBlock();
        int n = jq_Thread2.getThreadId();
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(object).offset(-8);
        int n2 = heapAddress.peek4() & 7;
        int n3 = n2 | n;
        int n4 = heapAddress.atomicCas4(n2, n3);
        if (Unsafe.isEQ()) {
            return;
        }
        int n5 = n4 ^ n3;
        if (n5 >= 496) {
            if (n5 == 496) {
                if (TRACE) {
                    SystemInterface.debugwriteln("Thin lock counter overflow, inflating lock...");
                }
                int n6 = 33;
                Monitor monitor = Monitor.allocateInflatedLock();
                monitor.monitor_owner = jq_Thread2;
                monitor.entry_count = n6;
                n3 = HeapAddress.addressOf(monitor).to32BitValue() | Integer.MIN_VALUE | n2;
                boolean bl = false;
                if (HeapAddress.addressOf(object).offset(-8).peek4() == n4) {
                    bl = true;
                }
                Assert._assert(bl);
                HeapAddress.addressOf(object).offset(-8).poke4(n3);
            } else {
                if (TRACE) {
                    SystemInterface.debugwriteln(jq_Thread2 + " tid " + Strings.hex(n) + ": Lock contention with tid " + Strings.hex(n4 & 0x7FFFFE00) + ", inflating...");
                }
                int n7 = 1;
                Monitor monitor = Monitor.allocateInflatedLock();
                monitor.monitor_owner = jq_Thread2;
                monitor.entry_count = n7;
                Monitor.installInflatedLock(object, monitor);
            }
        } else if (n5 < 0) {
            Monitor monitor = Monitor.getMonitor(n4);
            monitor.lock(jq_Thread2);
        } else {
            HeapAddress.addressOf(object).offset(-8).poke4(n4 + 16);
        }
    }

    public static void monitorexit(Object object) {
        jq_Thread jq_Thread2 = Unsafe.getThreadBlock();
        int n = jq_Thread2.getThreadId();
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(object).offset(-8);
        int n2 = heapAddress.peek4();
        int n3 = n2 ^ n;
        if (n3 < 0) {
            Monitor monitor = Monitor.getMonitor(n2);
            monitor.unlock(jq_Thread2);
        } else if (n3 <= 7) {
            heapAddress.atomicAnd(7);
        } else if (n3 <= 503) {
            heapAddress.atomicSub(16);
        } else {
            SystemInterface.debugwriteln("Thin lock not owned by us (" + Strings.hex8(n) + ")! lockword=" + Strings.hex8(n2));
            throw new IllegalMonitorStateException();
        }
    }

    public static Monitor getMonitor(int n) {
        int n2 = n & 0x7FFFFFF8;
        HeapAddress heapAddress = HeapAddress.address32(n2);
        return (Monitor)heapAddress.asObject();
    }

    public static Monitor allocateInflatedLock() {
        return (Monitor)DefaultHeapAllocator.allocateObjectAlign8(_class.getInstanceSize(), _class.getVTable());
    }

    public void free() {
    }

    public static void installInflatedLock(Object object, Monitor monitor) {
        boolean bl = false;
        if (monitor.monitor_owner == Unsafe.getThreadBlock()) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (monitor.entry_count >= 1) {
            bl2 = true;
        }
        Assert._assert(bl2);
        while (true) {
            HeapAddress heapAddress;
            int n;
            if ((n = (heapAddress = (HeapAddress)HeapAddress.addressOf(object).offset(-8)).peek4()) < 0) {
                boolean bl3 = false;
                if (monitor.entry_count == 1) {
                    bl3 = true;
                }
                Assert._assert(bl3);
                monitor.free();
                Monitor monitor2 = Monitor.getMonitor(n);
                if (TRACE) {
                    SystemInterface.debugwriteln("Inflated by another thread! lockword=" + Strings.hex8(n) + " lock=" + monitor2);
                }
                boolean bl4 = false;
                if (monitor != monitor2) {
                    bl4 = true;
                }
                Assert._assert(bl4);
                monitor2.lock(Unsafe.getThreadBlock());
                return;
            }
            int n2 = n & 7;
            HeapAddress heapAddress2 = HeapAddress.addressOf(monitor);
            if ((heapAddress2.to32BitValue() & 7) != 0 || (heapAddress2.to32BitValue() & Integer.MIN_VALUE) != 0) {
                Assert.UNREACHABLE("Monitor object has address " + heapAddress2.stringRep());
            }
            int n3 = heapAddress2.to32BitValue() | Integer.MIN_VALUE | n2;
            heapAddress.atomicCas4(n2, n3);
            if (Unsafe.isEQ()) {
                if (TRACE) {
                    SystemInterface.debugwriteln("Obtained inflated lock! new lockword=" + Strings.hex8(n3));
                }
                return;
            }
            if (TRACE) {
                SystemInterface.debugwriteln("Failed to obtain inflated lock, lockword was " + Strings.hex8(n));
            }
            Thread.yield();
        }
    }

    public void lock(jq_Thread jq_Thread2) {
        jq_Thread jq_Thread3 = this.monitor_owner;
        if (jq_Thread3 == jq_Thread2) {
            boolean bl = false;
            if (this.atomic_count >= 0) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            if (this.entry_count > 0) {
                bl2 = true;
            }
            Assert._assert(bl2);
            ++this.entry_count;
            if (TRACE) {
                SystemInterface.debugwriteln("We (" + jq_Thread2 + ") own lock " + this + ", incrementing entry count: " + this.entry_count);
            }
            return;
        }
        if (TRACE) {
            SystemInterface.debugwriteln("We (" + jq_Thread2 + ") are attempting to obtain lock " + this);
        }
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(this).offset(_atomic_count.getOffset());
        heapAddress.atomicAdd(1);
        if (!Unsafe.isEQ()) {
            if (TRACE) {
                SystemInterface.debugwriteln("Lock " + this + " cannot be obtained (owned by " + jq_Thread3 + ", or there are other waiters); waiting on semaphore (" + this.atomic_count + " waiters)");
            }
            this.waitOnSemaphore();
            if (TRACE) {
                SystemInterface.debugwriteln("We (" + jq_Thread2 + ") finished waiting on " + this);
            }
        } else if (TRACE) {
            SystemInterface.debugwriteln(this + " is unlocked, we (" + jq_Thread2 + ") obtain it.");
        }
        boolean bl = false;
        if (this.monitor_owner == null) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl3 = false;
        if (this.entry_count == 0) {
            bl3 = true;
        }
        Assert._assert(bl3);
        boolean bl4 = false;
        if (this.atomic_count >= 0) {
            bl4 = true;
        }
        Assert._assert(bl4);
        if (TRACE) {
            SystemInterface.debugwriteln("We (" + jq_Thread2 + ") obtained lock " + this);
        }
        this.monitor_owner = jq_Thread2;
        this.entry_count = 1;
    }

    public void unlock(jq_Thread jq_Thread2) {
        jq_Thread jq_Thread3 = this.monitor_owner;
        if (jq_Thread3 != jq_Thread2) {
            SystemInterface.debugwriteln("We (" + jq_Thread2 + ") tried to unlock lock " + this + " owned by " + jq_Thread3);
            throw new IllegalMonitorStateException();
        }
        if (--this.entry_count > 0) {
            if (TRACE) {
                SystemInterface.debugwriteln("Decrementing lock " + this + " entry count " + this.entry_count);
            }
            return;
        }
        if (TRACE) {
            SystemInterface.debugwriteln("We (" + jq_Thread2 + ") are unlocking lock " + this + ", current waiters=" + this.atomic_count);
        }
        this.monitor_owner = null;
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(this).offset(_atomic_count.getOffset());
        heapAddress.atomicSub(1);
        if (Unsafe.isGE()) {
            if (TRACE) {
                SystemInterface.debugwriteln(this.atomic_count + 1 + " threads are waiting on released lock " + this + ", releasing semaphore.");
            }
            this.releaseSemaphore();
        } else if (TRACE) {
            SystemInterface.debugwriteln("No threads are waiting on released lock " + this + '.');
        }
    }

    public void waitOnSemaphore() {
        if (this.semaphore == 0) {
            this.semaphore = SystemInterface.init_semaphore();
        }
        while (true) {
            int n;
            if ((n = SystemInterface.wait_for_single_object(this.semaphore, 10)) == 258) {
                Thread.yield();
                continue;
            }
            if (n == 0) {
                return;
            }
            SystemInterface.debugwriteln("Bad return value from WaitForSingleObject: " + n);
        }
    }

    public void releaseSemaphore() {
        if (this.semaphore == 0) {
            this.semaphore = SystemInterface.init_semaphore();
        }
        SystemInterface.release_semaphore(this.semaphore, 1);
    }

    private final /* synthetic */ void this() {
        this.atomic_count = 0;
        this.entry_count = 0;
    }

    private Monitor() {
        this.this();
    }
}

