/*
 * Decompiled with CFR 0.152.
 */
package Run_Time;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_StaticField;
import Main.jq;
import Memory.Address;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.Debug;
import Run_Time.Unsafe;
import Scheduler.jq_RegisterState;
import Scheduler.jq_Thread;
import UTF.Utf8;
import Util.Assert;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class SystemInterface {
    public static CodeAddress open_library_4;
    public static CodeAddress get_proc_address_8;
    public static CodeAddress close_library_4;
    public static final Collection libraries;
    public static CodeAddress debugwrite_8;
    public static CodeAddress debugwwrite_8;
    public static CodeAddress debugwriteln_8;
    public static CodeAddress debugwwriteln_8;
    public static CodeAddress syscalloc_4;
    public static CodeAddress sysfree_4;
    public static CodeAddress die_4;
    public static CodeAddress currentTimeMillis_0;
    public static CodeAddress mem_cpy_12;
    public static CodeAddress mem_set_12;
    public static CodeAddress file_open_12;
    public static CodeAddress file_stat_8;
    public static CodeAddress file_readbytes_12;
    public static CodeAddress file_writebyte_8;
    public static CodeAddress file_writebytes_12;
    public static CodeAddress file_sync_4;
    public static CodeAddress file_seek_16;
    public static CodeAddress file_close_4;
    public static CodeAddress console_available_0;
    public static CodeAddress main_argc_0;
    public static CodeAddress main_argv_length_4;
    public static CodeAddress main_argv_8;
    public static CodeAddress fs_getdcwd_12;
    public static CodeAddress fs_fullpath_12;
    public static CodeAddress fs_gettruename_4;
    public static CodeAddress fs_getfileattributes_4;
    public static CodeAddress fs_access_8;
    public static CodeAddress fs_getfiletime_4;
    public static CodeAddress fs_stat_size_4;
    public static CodeAddress fs_remove_4;
    public static CodeAddress fs_opendir_4;
    public static CodeAddress fs_readdir_4;
    public static CodeAddress fs_closedir_4;
    public static CodeAddress fs_mkdir_4;
    public static CodeAddress fs_rename_8;
    public static CodeAddress fs_chmod_8;
    public static CodeAddress fs_setfiletime_12;
    public static CodeAddress fs_getlogicaldrives_0;
    public static CodeAddress yield_0;
    public static CodeAddress msleep_4;
    public static CodeAddress create_thread_8;
    public static CodeAddress init_thread_0;
    public static CodeAddress resume_thread_4;
    public static CodeAddress suspend_thread_4;
    public static CodeAddress set_thread_priority_8;
    public static CodeAddress allocate_stack_4;
    public static CodeAddress get_current_thread_handle_0;
    public static CodeAddress get_thread_context_8;
    public static CodeAddress set_thread_context_8;
    public static CodeAddress set_current_context_8;
    public static CodeAddress set_interval_timer_8;
    public static CodeAddress init_semaphore_0;
    public static CodeAddress wait_for_single_object_8;
    public static CodeAddress release_semaphore_8;
    public static final jq_Class _class;
    public static final jq_StaticField _debugwrite;
    public static final jq_StaticField _debugwriteln;
    public static final jq_InstanceField _string_value;
    public static final jq_InstanceField _string_offset;
    public static final jq_InstanceField _string_count;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int _O_RDONLY = 0;
    public static final int _O_WRONLY = 1;
    public static final int _O_RDWR = 2;
    public static final int _O_APPEND = 8;
    public static final int _O_CREAT = 256;
    public static final int _O_TRUNC = 512;
    public static final int _O_EXCL = 1024;
    public static final int _O_TEXT = 16384;
    public static final int _O_BINARY = 32768;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    public static final int FILE_ATTRIBUTE_READONLY = 1;
    public static final int FILE_ATTRIBUTE_HIDDEN = 2;
    public static final int FILE_ATTRIBUTE_SYSTEM = 4;
    public static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    public static final int FILE_ATTRIBUTE_ARCHIVE = 32;
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    public static final int FILE_ATTRIBUTE_TEMPORARY = 256;
    public static final int readdir_name_offset = 11;
    public static final int _S_IEXEC = 64;
    public static final int _S_IWRITE = 128;
    public static final int _S_IREAD = 256;
    public static final int THREAD_BASE_PRIORITY_LOWRT = 15;
    public static final int THREAD_BASE_PRIORITY_MAX = 2;
    public static final int THREAD_BASE_PRIORITY_MIN = -2;
    public static final int THREAD_BASE_PRIORITY_IDLE = -15;
    public static final int THREAD_PRIORITY_LOWEST = -2;
    public static final int THREAD_PRIORITY_BELOW_NORMAL = -1;
    public static final int THREAD_PRIORITY_NORMAL = 0;
    public static final int THREAD_PRIORITY_HIGHEST = 2;
    public static final int THREAD_PRIORITY_ABOVE_NORMAL = 1;
    public static final int THREAD_PRIORITY_TIME_CRITICAL = 15;
    public static final int THREAD_PRIORITY_IDLE = -15;
    public static final int ITIMER_VIRTUAL = 1;
    public static final int INFINITE = -1;
    public static final int WAIT_ABANDONED = 128;
    public static final int WAIT_OBJECT_0 = 0;
    public static final int WAIT_TIMEOUT = 258;

    public static int open_library(byte[] byArray) {
        Unsafe.pushArgA(HeapAddress.addressOf(byArray));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(open_library_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static void close_library(int n) {
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(close_library_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static CodeAddress get_proc_address(int n, byte[] byArray) {
        Unsafe.pushArgA(HeapAddress.addressOf(byArray));
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            CodeAddress codeAddress = (CodeAddress)Unsafe.invokeA(get_proc_address_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return codeAddress;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Library registerLibrary(String string) {
        Collection collection = libraries;
        synchronized (collection) {
            block5: {
                Library library;
                Object object = libraries.iterator();
                do {
                    if (object.hasNext()) continue;
                    object = new Library(string);
                    if (((Library)object).open()) {
                        libraries.add(object);
                        return object;
                    }
                    break block5;
                } while (!string.equals((library = (Library)object.next()).getName()));
                return library;
            }
            return null;
        }
    }

    public static ExternalLink tryLink(String string) {
        ExternalLink externalLink = new ExternalLink(string);
        if (!externalLink.resolve().isNull()) {
            return externalLink;
        }
        return null;
    }

    public static void debugwrite(String string) {
        if (!jq.RunningNative) {
            System.err.println(string);
            return;
        }
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(string).offset(_string_value.getOffset()).peek();
        int n = HeapAddress.addressOf(string).offset(_string_offset.getOffset()).peek4();
        int n2 = HeapAddress.addressOf(string).offset(_string_count.getOffset()).peek4();
        Unsafe.pushArg(n2);
        Unsafe.pushArgA(heapAddress.offset(n * 2));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(debugwwrite_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static void debugwrite(Utf8 utf8) {
        utf8.debugWrite();
    }

    public static void debugwrite(byte[] byArray) {
        SystemInterface.debugwrite(byArray, byArray.length);
    }

    public static void debugwrite(byte[] byArray, int n) {
        Unsafe.pushArg(n);
        Unsafe.pushArgA(HeapAddress.addressOf(byArray));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(debugwrite_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static void debugwriteln(String string) {
        if (!jq.RunningNative) {
            System.err.println(string);
            return;
        }
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(string).offset(_string_value.getOffset()).peek();
        int n = HeapAddress.addressOf(string).offset(_string_offset.getOffset()).peek4();
        int n2 = HeapAddress.addressOf(string).offset(_string_count.getOffset()).peek4();
        Unsafe.pushArg(n2);
        Unsafe.pushArgA(heapAddress.offset(n * 2));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(debugwwriteln_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static void debugwriteln(byte[] byArray) {
        SystemInterface.debugwriteln(byArray, byArray.length);
    }

    public static void debugwriteln(byte[] byArray, int n) {
        Unsafe.pushArg(n);
        Unsafe.pushArgA(HeapAddress.addressOf(byArray));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(debugwriteln_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static Address syscalloc(int n) {
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Address address = Unsafe.invokeA(syscalloc_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return address;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return null;
        }
    }

    public static void sysfree(Address address) {
        Unsafe.pushArgA(address);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(sysfree_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static void die(int n) {
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(die_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            throw new InternalError();
        }
    }

    public static byte[] toCString(String string) {
        try {
            byte[] byArray = string.getBytes(DEFAULT_ENCODING);
            byte[] byArray2 = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String fromCString(Address address) {
        int n = 0;
        while (address.offset(n).peek1() != 0) {
            ++n;
        }
        byte[] byArray = new byte[n];
        SystemInterface.mem_cpy(HeapAddress.addressOf(byArray), address, n);
        return new String(byArray);
    }

    public static long currentTimeMillis() {
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            long l = Unsafe.invoke(currentTimeMillis_0);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return l;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0L;
        }
    }

    public static void mem_cpy(Address address, Address address2, int n) {
        Unsafe.pushArg(n);
        Unsafe.pushArgA(address2);
        Unsafe.pushArgA(address);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(mem_cpy_12);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static void mem_set(Address address, int n, byte by) {
        Unsafe.pushArg(by);
        Unsafe.pushArg(n);
        Unsafe.pushArgA(address);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(mem_set_12);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static int file_open(String string, int n, int n2) {
        byte[] byArray = SystemInterface.toCString(string);
        Unsafe.pushArg(n2);
        Unsafe.pushArg(n);
        Unsafe.pushArgA(HeapAddress.addressOf(byArray));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n3 = (int)Unsafe.invoke(file_open_12);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n3;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int file_stat(String string, Stat stat) {
        byte[] byArray = SystemInterface.toCString(string);
        Unsafe.pushArgA(HeapAddress.addressOf(stat));
        Unsafe.pushArgA(HeapAddress.addressOf(byArray));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(file_stat_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int file_readbytes(int n, Address address, int n2) {
        Unsafe.pushArg(n2);
        Unsafe.pushArgA(address);
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n3 = (int)Unsafe.invoke(file_readbytes_12);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n3;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int file_writebyte(int n, int n2) {
        Unsafe.pushArg(n2);
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n3 = (int)Unsafe.invoke(file_writebyte_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n3;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int file_writebytes(int n, Address address, int n2) {
        Unsafe.pushArg(n2);
        Unsafe.pushArgA(address);
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n3 = (int)Unsafe.invoke(file_writebytes_12);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n3;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int file_sync(int n) {
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n2 = (int)Unsafe.invoke(file_sync_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static long file_seek(int n, long l, int n2) {
        Unsafe.pushArg(n2);
        Unsafe.pushArg((int)(l >> 32));
        Unsafe.pushArg((int)l);
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            long l2 = Unsafe.invoke(file_seek_16);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return l2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0L;
        }
    }

    public static int file_close(int n) {
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n2 = (int)Unsafe.invoke(file_close_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int console_available() {
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(console_available_0);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int main_argc() {
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(main_argc_0);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int main_argv_length(int n) {
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n2 = (int)Unsafe.invoke(main_argv_length_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static void main_argv(int n, byte[] byArray) {
        Unsafe.pushArgA(HeapAddress.addressOf(byArray));
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(main_argv_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static int fs_getdcwd(int n, byte[] byArray) {
        Unsafe.pushArg(byArray.length);
        Unsafe.pushArgA(HeapAddress.addressOf(byArray));
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n2 = (int)Unsafe.invoke(fs_getdcwd_12);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int fs_fullpath(String string, byte[] byArray) {
        Unsafe.pushArg(byArray.length);
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        Unsafe.pushArgA(HeapAddress.addressOf(byArray));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(fs_fullpath_12);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static Address fs_gettruename(String string) {
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Address address = Unsafe.invokeA(fs_gettruename_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return address;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return null;
        }
    }

    public static int fs_getfileattributes(String string) {
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(fs_getfileattributes_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int fs_access(String string, int n) {
        Unsafe.pushArg(n);
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n2 = (int)Unsafe.invoke(fs_access_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static long fs_getfiletime(String string) {
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            long l = Unsafe.invoke(fs_getfiletime_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return l;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0L;
        }
    }

    public static long fs_stat_size(String string) {
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            long l = Unsafe.invoke(fs_stat_size_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return l;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0L;
        }
    }

    public static int fs_remove(String string) {
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(fs_remove_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int fs_opendir(String string) {
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(fs_opendir_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static Address fs_readdir(int n) {
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Address address = Unsafe.invokeA(fs_readdir_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return address;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return null;
        }
    }

    public static int fs_closedir(int n) {
        Unsafe.pushArg(n);
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n2 = (int)Unsafe.invoke(fs_closedir_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int fs_mkdir(String string) {
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(fs_mkdir_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int fs_rename(String string, String string2) {
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string2)));
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(fs_rename_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int fs_chmod(String string, int n) {
        Unsafe.pushArg(n);
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n2 = (int)Unsafe.invoke(fs_chmod_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int fs_setfiletime(String string, long l) {
        Unsafe.pushArg((int)(l >> 32));
        Unsafe.pushArg((int)l);
        Unsafe.pushArgA(HeapAddress.addressOf(SystemInterface.toCString(string)));
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(fs_setfiletime_12);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int fs_getlogicaldrives() {
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(fs_getlogicaldrives_0);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static void yield() {
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(yield_0);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static void msleep(int n) {
        try {
            Unsafe.pushArg(n);
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(msleep_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static int create_thread(CodeAddress codeAddress, HeapAddress heapAddress) {
        try {
            Unsafe.pushArgA(heapAddress);
            Unsafe.pushArgA(codeAddress);
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(create_thread_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int init_thread() {
        try {
            int n = (int)Unsafe.invoke(init_thread_0);
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int resume_thread(int n) {
        try {
            Unsafe.pushArg(n);
            Assert._assert(Unsafe.getThreadBlock().isThreadSwitchEnabled() ^ true);
            int n2 = (int)Unsafe.invoke(resume_thread_4);
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int suspend_thread(int n) {
        try {
            Unsafe.pushArg(n);
            Assert._assert(Unsafe.getThreadBlock().isThreadSwitchEnabled() ^ true);
            int n2 = (int)Unsafe.invoke(suspend_thread_4);
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int set_thread_priority(int n, int n2) {
        try {
            Unsafe.pushArg(n2);
            Unsafe.pushArg(n);
            Assert._assert(Unsafe.getThreadBlock().isThreadSwitchEnabled() ^ true);
            int n3 = (int)Unsafe.invoke(set_thread_priority_8);
            return n3;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static StackAddress allocate_stack(int n) {
        try {
            Unsafe.pushArg(n);
            Unsafe.getThreadBlock().disableThreadSwitch();
            StackAddress stackAddress = (StackAddress)Unsafe.invokeA(allocate_stack_4);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return stackAddress;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return null;
        }
    }

    public static int get_current_thread_handle() {
        try {
            Assert._assert(Unsafe.getThreadBlock().isThreadSwitchEnabled() ^ true);
            int n = (int)Unsafe.invoke(get_current_thread_handle_0);
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static boolean get_thread_context(int n, jq_RegisterState jq_RegisterState2) {
        try {
            Unsafe.pushArgA(HeapAddress.addressOf(jq_RegisterState2));
            Unsafe.pushArg(n);
            Assert._assert(Unsafe.getThreadBlock().isThreadSwitchEnabled() ^ true);
            int n2 = (int)Unsafe.invoke(get_thread_context_8);
            boolean bl = false;
            if (n2 != 0) {
                bl = true;
            }
            return bl;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return false;
        }
    }

    public static boolean set_thread_context(int n, jq_RegisterState jq_RegisterState2) {
        try {
            Unsafe.pushArgA(HeapAddress.addressOf(jq_RegisterState2));
            Unsafe.pushArg(n);
            Assert._assert(Unsafe.getThreadBlock().isThreadSwitchEnabled() ^ true);
            int n2 = (int)Unsafe.invoke(set_thread_context_8);
            boolean bl = false;
            if (n2 != 0) {
                bl = true;
            }
            return bl;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return false;
        }
    }

    public static void set_current_context(jq_Thread jq_Thread2, jq_RegisterState jq_RegisterState2) {
        try {
            Unsafe.pushArgA(HeapAddress.addressOf(jq_RegisterState2));
            Unsafe.pushArgA(HeapAddress.addressOf(jq_Thread2));
            Assert._assert(Unsafe.getThreadBlock().isThreadSwitchEnabled() ^ true);
            Unsafe.invoke(set_current_context_8);
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static void set_interval_timer(int n, int n2) {
        try {
            Unsafe.pushArg(n2);
            Unsafe.pushArg(n);
            Unsafe.getThreadBlock().disableThreadSwitch();
            Unsafe.invoke(set_interval_timer_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
        }
    }

    public static int init_semaphore() {
        try {
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(init_semaphore_0);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int wait_for_single_object(int n, int n2) {
        try {
            Unsafe.pushArg(n2);
            Unsafe.pushArg(n);
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n3 = (int)Unsafe.invoke(wait_for_single_object_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n3;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static int release_semaphore(int n, int n2) {
        try {
            Unsafe.pushArg(n2);
            Unsafe.pushArg(n);
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n3 = (int)Unsafe.invoke(release_semaphore_8);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n3;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    static {
        libraries = new LinkedList();
        _class = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LRun_Time/SystemInterface;");
        _debugwrite = _class.getOrCreateStaticField("debugwrite_8", "LMemory/CodeAddress;");
        _debugwriteln = _class.getOrCreateStaticField("debugwriteln_8", "LMemory/CodeAddress;");
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("Ljava/lang/String;");
        _string_value = jq_Class2.getOrCreateInstanceField("value", "[C");
        _string_offset = jq_Class2.getOrCreateInstanceField("offset", "I");
        _string_count = jq_Class2.getOrCreateInstanceField("count", "I");
    }

    public static class ExternalLink {
        private final String name;
        private Library library;
        private CodeAddress address;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CodeAddress resolve() {
            block6: {
                if (!this.address.isNull()) {
                    return this.address;
                }
                Collection collection = libraries;
                synchronized (collection) {
                    Library library;
                    Iterator iterator = libraries.iterator();
                    do {
                        if (!iterator.hasNext()) {
                            break block6;
                        }
                        library = (Library)iterator.next();
                        this.address = library.getProcAddress(this.name);
                    } while (this.address.isNull());
                    this.library = library;
                    library.registerLink(this);
                    return this.address;
                }
            }
            Debug.write("Error: cannot resolve external procedure ");
            Debug.writeln(this.name);
            return CodeAddress.getNull();
        }

        public CodeAddress resolve(Library library) {
            if (!this.address.isNull()) {
                return this.address;
            }
            this.address = library.getProcAddress(this.name);
            if (!this.address.isNull()) {
                this.library = library;
                library.registerLink(this);
            }
            return this.address;
        }

        public void unlink() {
            if (this.library != null) {
                this.library.unlink(this);
            }
            this._unlink();
        }

        void _unlink() {
            this.library = null;
            this.address = CodeAddress.getNull();
        }

        public ExternalLink(String string) {
            this.name = string;
            this.library = null;
            this.address = CodeAddress.getNull();
        }
    }

    public static class Library {
        private final String name;
        private int library_pointer;
        private boolean opened;
        private final Collection externals;

        public String getName() {
            return this.name;
        }

        public synchronized boolean open() {
            if (this.opened) {
                return true;
            }
            this.library_pointer = SystemInterface.open_library(SystemInterface.toCString(this.name));
            if (this.library_pointer == 0) {
                return false;
            }
            this.opened = true;
            return true;
        }

        public CodeAddress getProcAddress(String string) {
            if (!this.opened) {
                this.open();
            }
            CodeAddress codeAddress = SystemInterface.get_proc_address(this.library_pointer, SystemInterface.toCString(string));
            return codeAddress;
        }

        public ExternalLink resolve(String string) {
            ExternalLink externalLink = new ExternalLink(string);
            CodeAddress codeAddress = externalLink.resolve(this);
            if (!codeAddress.isNull()) {
                return externalLink;
            }
            return null;
        }

        public synchronized void registerLink(ExternalLink externalLink) {
            this.externals.add(externalLink);
        }

        public synchronized void unlink(ExternalLink externalLink) {
            this.externals.remove(externalLink);
        }

        public synchronized void close() {
            Iterator iterator = this.externals.iterator();
            while (iterator.hasNext()) {
                ExternalLink externalLink = (ExternalLink)iterator.next();
                externalLink._unlink();
                iterator.remove();
            }
            if (this.opened) {
                SystemInterface.close_library(this.library_pointer);
                this.opened = false;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.close();
        }

        public Library(String string) {
            this.name = string;
            this.opened = false;
            this.externals = new LinkedList();
        }
    }

    public static abstract class Stat {
    }
}

