/*
 * Decompiled with CFR 0.152.
 */
package Support;

import java.util.Random;

public final class JMath {
    public static final double PI = Double.longBitsToDouble(4614256656552045848L);
    public static final double E = Math.E;
    private static Random random;
    private static final double huge = 1.0E300;
    private static final double tiny = 1.0E-300;
    private static final double[] TWO52;
    private static final double NEGATIVE_ZERO;
    private static final double[] halF;
    private static final double twom1000;
    private static final double o_threshold;
    private static final double u_threshold;
    private static final double[] ln2HI;
    private static final double[] ln2LO;
    private static final double invln2;
    private static final double P1;
    private static final double P2;
    private static final double P3;
    private static final double P4;
    private static final double P5;
    private static final double ln2_hi;
    private static final double ln2_lo;
    private static final double Lg1;
    private static final double Lg2;
    private static final double Lg3;
    private static final double Lg4;
    private static final double Lg5;
    private static final double Lg6;
    private static final double Lg7;
    private static double S1;
    private static double S2;
    private static double S3;
    private static double S4;
    private static double S5;
    private static double S6;
    private static final double one;
    private static final double C1;
    private static final double C2;
    private static final double C3;
    private static final double C4;
    private static final double C5;
    private static final double C6;
    private static final double pio4;
    private static final double pio4lo;
    private static final double[] T;
    private static final double pio2_hi;
    private static final double pio2_lo;
    private static final double pio4_hi;
    private static final double pS0;
    private static final double pS1;
    private static final double pS2;
    private static final double pS3;
    private static final double pS4;
    private static final double pS5;
    private static final double qS1;
    private static final double qS2;
    private static final double qS3;
    private static final double qS4;
    private static final double[] atanhi;
    private static final double[] atanlo;
    private static final double[] aT;
    private static final double pi_o_4;
    private static final double pi_o_2;
    private static final double pi_lo;
    private static final int[] two_over_pi;
    private static final int[] npio2_hw;
    private static final double zero = 0.0;
    private static final double half;
    private static final double two24;
    private static final double invpio2;
    private static final double pio2_1;
    private static final double pio2_1t;
    private static final double pio2_2;
    private static final double pio2_2t;
    private static final double pio2_3;
    private static final double pio2_3t;
    private static final double[] PIo2;
    private static final double twon24;
    private static final double[] bp;
    private static final double[] dp_h;
    private static final double[] dp_l;
    private static final double two53;
    private static final double L1;
    private static final double L2;
    private static final double L3;
    private static final double L4;
    private static final double L5;
    private static final double L6;
    private static final double lg2;
    private static final double lg2_h;
    private static final double lg2_l = -1.904654299957768E-9;
    private static final double ovt = 8.008566259537294E-17;
    private static final double cp;
    private static final double cp_h;
    private static final double cp_l;
    private static final double ivln2;
    private static final double ivln2_h;
    private static final double ivln2_l;
    private static final double two54;
    private static final double twom54;

    public static final strictfp int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final strictfp long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static final strictfp float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    public static final strictfp double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static final strictfp int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final strictfp long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    public static final strictfp float min(float f, float f2) {
        float f3;
        if (Float.isNaN(f)) {
            return f;
        }
        float f4 = f3 = f <= f2 ? f : f2;
        if (f3 == 0.0f && Float.floatToIntBits(f2) == Integer.MIN_VALUE) {
            f3 = f2;
        }
        return f3;
    }

    public static final strictfp double min(double d, double d2) {
        double d3;
        if (Double.isNaN(d)) {
            return d;
        }
        double d4 = d3 = d <= d2 ? d : d2;
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d2) == Long.MIN_VALUE) {
            d3 = d2;
        }
        return d3;
    }

    public static final strictfp int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final strictfp long max(long l, long l2) {
        return l > l2 ? l : l2;
    }

    public static final strictfp float max(float f, float f2) {
        float f3;
        if (Float.isNaN(f)) {
            return f;
        }
        float f4 = f3 = f >= f2 ? f : f2;
        if (f3 == 0.0f && Float.floatToIntBits(f) == Integer.MIN_VALUE) {
            f3 = f2;
        }
        return f3;
    }

    public static final strictfp double max(double d, double d2) {
        double d3;
        if (Double.isNaN(d)) {
            return d;
        }
        double d4 = d3 = d >= d2 ? d : d2;
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d) == Long.MIN_VALUE) {
            d3 = d2;
        }
        return d3;
    }

    public static final strictfp int round(float f) {
        return (int)JMath.floor(f + 0.5f);
    }

    public static final strictfp long round(double d) {
        return (long)JMath.floor(d + 0.5);
    }

    public static final synchronized strictfp double random() {
        if (random == null) {
            random = new Random();
        }
        return random.nextDouble();
    }

    public static final double ceil(double d) {
        if (d == 0.0) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        int n = ((int)(l >> 52) & 0x7FF) - 1023;
        if (n < 0) {
            if (d < 0.0) {
                return NEGATIVE_ZERO;
            }
            if (d == 0.0) {
                return d;
            }
            return 1.0;
        }
        if (n < 53) {
            long l2 = 0xFFFFFFFFFFFFFL >>> n;
            if ((l2 & l) == 0L) {
                return d;
            }
            if (d > 0.0) {
                l += 0x10000000000000L >> n;
            }
            l &= l2 ^ -1L;
        } else if (n == 1024) {
            return d;
        }
        return Double.longBitsToDouble(l);
    }

    public static final double floor(double d) {
        if (d == 0.0) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        int n = ((int)(l >> 52) & 0x7FF) - 1023;
        if (n < 0) {
            if (d < 0.0) {
                return -1.0;
            }
            if (d == 0.0) {
                return d;
            }
            return 0.0;
        }
        if (n < 53) {
            long l2 = 0xFFFFFFFFFFFFFL >>> n;
            if ((l2 & l) == 0L) {
                return d;
            }
            if (d < 0.0) {
                l += 0x10000000000000L >> n;
            }
            l &= l2 ^ -1L;
        } else if (n == 1024) {
            return d;
        }
        return Double.longBitsToDouble(l);
    }

    public static final double rint(double d) {
        long l;
        if (d == 0.0) {
            return d;
        }
        long l2 = Double.doubleToLongBits(d);
        int n = (int)(l2 >> 63 & 1L);
        int n2 = ((int)(l2 >> 52) & 0x7FF) - 1023;
        if (n2 < 0) {
            if (d < -0.5) {
                return -1.0;
            }
            if (d > 0.5) {
                return 1.0;
            }
            if (n == 0) {
                return 0.0;
            }
            return NEGATIVE_ZERO;
        }
        if (n2 < 53 ? ((l = 0xFFFFFFFFFFFFFL >>> n2) & l2) == 0L : n2 == 1024) {
            return d;
        }
        d = Double.longBitsToDouble(l2);
        double d2 = TWO52[n] + d;
        return d2 - TWO52[n];
    }

    public static final double IEEEremainder(double d, double d2) {
        int n = JMath.__HI(d);
        int n2 = JMath.__LO(d);
        int n3 = JMath.__HI(d2);
        int n4 = JMath.__LO(d2);
        int n5 = n & Integer.MIN_VALUE;
        n &= Integer.MAX_VALUE;
        if (((n3 &= Integer.MAX_VALUE) | n4) == 0) {
            return d * d2 / (d * d2);
        }
        if (n >= 0x7FF00000 || n3 >= 0x7FF00000 && (n3 - 0x7FF00000 | n4) != 0) {
            return d * d2 / (d * d2);
        }
        if (n3 <= 0x7FDFFFFF) {
            d %= d2 + d2;
        }
        if ((n - n3 | n2 - n4) == 0) {
            return 0.0 * d;
        }
        d = JMath.abs(d);
        d2 = JMath.abs(d2);
        if (n3 < 0x200000) {
            if (d + d > d2 && (d -= d2) + d >= d2) {
                d -= d2;
            }
        } else {
            double d3 = 0.5 * d2;
            if (d > d3 && (d -= d2) >= d3) {
                d -= d2;
            }
        }
        n2 = JMath.__HI(d);
        return JMath.setHI(d, n2 ^= n5);
    }

    public static final double sqrt(double d) {
        long l = Double.doubleToLongBits(d);
        if ((l & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
            return d * d + d;
        }
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return d;
        }
        long l2 = l >> 52;
        l &= 0xFFFFFFFFFFFFFL;
        if (l2 != 0L) {
            l |= 0x10000000000000L;
        }
        if (((l2 -= 1023L) & 1L) != 0L) {
            l += l;
        }
        l2 >>= 1;
        l2 += 1023L;
        l += l;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0x20000000000000L;
        while (l5 != 0L) {
            long l6 = l4 + l5;
            if (l6 <= l) {
                l4 = l6 + l5;
                l -= l6;
                l3 += l5;
            }
            l += l;
            l5 >>= 1;
        }
        if (l != 0L) {
            l3 += l3 & 1L;
        }
        l = l2 << 52 | 0xFFFFFFFFFFFFFL & l3 >> 1;
        return Double.longBitsToDouble(l);
    }

    public static final double exp(double d) {
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = JMath.__HI(d);
        int n3 = n2 >>> 31 & 1;
        if ((n2 &= Integer.MAX_VALUE) >= 1082535490) {
            if (n2 >= 0x7FF00000) {
                if ((n2 & 0xFFFFF | JMath.__LO(d)) != 0) {
                    return d + d;
                }
                return n3 == 0 ? d : 0.0;
            }
            if (d > o_threshold) {
                return Double.POSITIVE_INFINITY;
            }
            if (d < u_threshold) {
                return twom1000 * twom1000;
            }
        }
        if (n2 > 1071001154) {
            if (n2 < 1072734898) {
                d3 = d - ln2HI[n3];
                d4 = ln2LO[n3];
                n = 1 - n3 - n3;
            } else {
                n = (int)(invln2 * d + halF[n3]);
                d2 = n;
                d3 = d - d2 * ln2HI[0];
                d4 = d2 * ln2LO[0];
            }
            d = d3 - d4;
        } else if (n2 < 0x3E300000) {
            if (1.0E300 + d > one) {
                return one + d;
            }
        } else {
            n = 0;
        }
        d2 = d * d;
        double d5 = d - d2 * (P1 + d2 * (P2 + d2 * (P3 + d2 * (P4 + d2 * P5))));
        if (n == 0) {
            return one - (d * d5 / (d5 - (double)2) - d);
        }
        double d6 = one - (d4 - d * d5 / ((double)2 - d5) - d3);
        long l = Double.doubleToLongBits(d6);
        l = n >= -1021 ? (l += (long)n << 52) : (l += (long)n + 1000L << 52);
        return Double.longBitsToDouble(l);
    }

    public static final double log(double d) {
        int n = JMath.__HI(d);
        int n2 = JMath.__LO(d);
        int n3 = 0;
        if (n < 0x100000) {
            if ((n & Integer.MAX_VALUE | n2) == 0) {
                return -two54 / 0.0;
            }
            if (n < 0) {
                return (d - d) / 0.0;
            }
            n3 -= 54;
            n = JMath.__HI(d *= two54);
        }
        if (n >= 0x7FF00000) {
            return d + d;
        }
        n3 += (n >> 20) - 1023;
        int n4 = (n &= 0xFFFFF) + 614244 & 0x100000;
        d = JMath.setHI(d, n | n4 ^ 0x3FF00000);
        n3 += n4 >> 20;
        double d2 = d - 1.0;
        if ((0xFFFFF & 2 + n) < 3) {
            if (d2 == 0.0) {
                if (n3 == 0) {
                    return 0.0;
                }
                double d3 = n3;
                return d3 * ln2_hi + d3 * ln2_lo;
            }
            double d4 = d2 * d2 * (0.5 - 0.3333333333333333 * d2);
            if (n3 == 0) {
                return d2 - d4;
            }
            double d5 = n3;
            return d5 * ln2_hi - (d4 - d5 * ln2_lo - d2);
        }
        double d6 = d2 / ((double)2 + d2);
        double d7 = n3;
        double d8 = d6 * d6;
        n4 = n - 398458;
        double d9 = d8 * d8;
        int n5 = 440401 - n;
        double d10 = d9 * (Lg2 + d9 * (Lg4 + d9 * Lg6));
        double d11 = d8 * (Lg1 + d9 * (Lg3 + d9 * (Lg5 + d9 * Lg7)));
        double d12 = d11 + d10;
        if ((n4 |= n5) > 0) {
            double d13 = 0.5 * d2 * d2;
            if (n3 == 0) {
                return d2 - (d13 - d6 * (d13 + d12));
            }
            return d7 * ln2_hi - (d13 - (d6 * (d13 + d12) + d7 * ln2_lo) - d2);
        }
        if (n3 == 0) {
            return d2 - d6 * (d2 - d12);
        }
        return d7 * ln2_hi - (d6 * (d2 - d12) - d7 * ln2_lo - d2);
    }

    public static final double sin(double d) {
        double[] dArray = new double[2];
        double d2 = 0.0;
        int n = JMath.__HI(d);
        if ((n &= Integer.MAX_VALUE) <= 1072243195) {
            return JMath.__kernel_sin(d, d2, 0);
        }
        if (n >= 0x7FF00000) {
            return d - d;
        }
        int n2 = JMath.__ieee754_rem_pio2(d, dArray);
        switch (n2 & 3) {
            case 0: {
                return JMath.__kernel_sin(dArray[0], dArray[1], 1);
            }
            case 1: {
                return JMath.__kernel_cos(dArray[0], dArray[1]);
            }
            case 2: {
                return -JMath.__kernel_sin(dArray[0], dArray[1], 1);
            }
        }
        return -JMath.__kernel_cos(dArray[0], dArray[1]);
    }

    static final double __kernel_sin(double d, double d2, int n) {
        int n2 = JMath.__HI(d) & Integer.MAX_VALUE;
        if (n2 < 1044381696 && (int)d == 0) {
            return d;
        }
        double d3 = d * d;
        double d4 = d3 * d;
        double d5 = S2 + d3 * (S3 + d3 * (S4 + d3 * (S5 + d3 * S6)));
        if (n == 0) {
            return d + d4 * (S1 + d3 * d5);
        }
        return d - (d3 * (half * d2 - d4 * d5) - d2 - d4 * S1);
    }

    public static final double cos(double d) {
        double d2 = 0.0;
        double[] dArray = new double[2];
        int n = JMath.__HI(d);
        if ((n &= Integer.MAX_VALUE) <= 1072243195) {
            return JMath.__kernel_cos(d, d2);
        }
        if (n >= 0x7FF00000) {
            return d - d;
        }
        int n2 = JMath.__ieee754_rem_pio2(d, dArray);
        switch (n2 & 3) {
            case 0: {
                return JMath.__kernel_cos(dArray[0], dArray[1]);
            }
            case 1: {
                return -JMath.__kernel_sin(dArray[0], dArray[1], 1);
            }
            case 2: {
                return -JMath.__kernel_cos(dArray[0], dArray[1]);
            }
        }
        return JMath.__kernel_sin(dArray[0], dArray[1], 1);
    }

    private static final double __kernel_cos(double d, double d2) {
        double d3 = 0.0;
        int n = JMath.__HI(d) & Integer.MAX_VALUE;
        if (n < 1044381696 && (int)d == 0) {
            return one;
        }
        double d4 = d * d;
        double d5 = d4 * (C1 + d4 * (C2 + d4 * (C3 + d4 * (C4 + d4 * (C5 + d4 * C6)))));
        if (n < 0x3FD33333) {
            return one - (0.5 * d4 - (d4 * d5 - d * d2));
        }
        d3 = n > 1072234496 ? 0.28125 : JMath.set(n - 0x200000, 0);
        double d6 = 0.5 * d4 - d3;
        double d7 = one - d3;
        return d7 - (d6 - (d4 * d5 - d * d2));
    }

    public static final double tan(double d) {
        double d2 = 0.0;
        int n = JMath.__HI(d);
        if ((n &= Integer.MAX_VALUE) <= 1072243195) {
            return JMath.__kernel_tan(d, d2, 1);
        }
        if (n >= 0x7FF00000) {
            return d - d;
        }
        double[] dArray = new double[2];
        int n2 = JMath.__ieee754_rem_pio2(d, dArray);
        return JMath.__kernel_tan(dArray[0], dArray[1], 1 - ((n2 & 1) << 1));
    }

    private static final double __kernel_tan(double d, double d2, int n) {
        double d3;
        double d4;
        double d5;
        int n2 = JMath.__HI(d);
        int n3 = n2 & Integer.MAX_VALUE;
        if (n3 < 0x3E300000 && (int)d == 0) {
            if ((n3 | JMath.__LO(d) | n + 1) == 0) {
                return one / JMath.abs(d);
            }
            return n == 1 ? d : -one / d;
        }
        if (n3 >= 1072010280) {
            if (n2 < 0) {
                d = -d;
                d2 = -d2;
            }
            d5 = pio4 - d;
            d4 = pio4lo - d2;
            d = d5 + d4;
            d2 = 0.0;
        }
        d5 = d * d;
        d4 = d5 * d5;
        double d6 = T[1] + d4 * (T[3] + d4 * (T[5] + d4 * (T[7] + d4 * (T[9] + d4 * T[11]))));
        double d7 = d5 * (T[2] + d4 * (T[4] + d4 * (T[6] + d4 * (T[8] + d4 * (T[10] + d4 * T[12])))));
        double d8 = d5 * d;
        d6 = d2 + d5 * (d8 * (d6 + d7) + d2);
        d4 = d + (d6 += T[0] * d8);
        if (n3 >= 1072010280) {
            d7 = n;
            return (double)(1 - (n2 >> 30 & 2)) * (d7 - (double)2 * (d - (d4 * d4 / (d4 + d7) - d6)));
        }
        if (n == 1) {
            return d4;
        }
        d5 = d4;
        d5 = JMath.setLO(d5, 0);
        d7 = d6 - (d5 - d);
        double d9 = d3 = -1.0 / d4;
        d9 = JMath.setLO(d9, 0);
        d8 = 1.0 + d9 * d5;
        return d9 + d3 * (d8 + d9 * d7);
    }

    public static final double asin(double d) {
        double d2 = 0.0;
        int n = JMath.__HI(d);
        int n2 = n & Integer.MAX_VALUE;
        if (n2 >= 0x3FF00000) {
            if ((n2 - 0x3FF00000 | JMath.__LO(d)) == 0) {
                return d * pio2_hi + d * pio2_lo;
            }
            return (d - d) / (d - d);
        }
        if (n2 < 1071644672) {
            if (n2 < 1044381696) {
                if (1.0E300 + d > one) {
                    return d;
                }
            } else {
                d2 = d * d;
            }
            double d3 = d2 * (pS0 + d2 * (pS1 + d2 * (pS2 + d2 * (pS3 + d2 * (pS4 + d2 * pS5)))));
            double d4 = one + d2 * (qS1 + d2 * (qS2 + d2 * (qS3 + d2 * qS4)));
            double d5 = d3 / d4;
            return d + d * d5;
        }
        double d6 = one - JMath.abs(d);
        d2 = d6 * 0.5;
        double d7 = d2 * (pS0 + d2 * (pS1 + d2 * (pS2 + d2 * (pS3 + d2 * (pS4 + d2 * pS5)))));
        double d8 = one + d2 * (qS1 + d2 * (qS2 + d2 * (qS3 + d2 * qS4)));
        double d9 = JMath.sqrt(d2);
        if (n2 >= 0x3FEF3333) {
            d6 = d7 / d8;
            d2 = pio2_hi - ((double)2 * (d9 + d9 * d6) - pio2_lo);
        } else {
            d6 = d9;
            d6 = JMath.setLO(d6, 0);
            double d10 = (d2 - d6 * d6) / (d9 + d6);
            double d11 = d7 / d8;
            d7 = (double)2 * d9 * d11 - (pio2_lo - (double)2 * d10);
            d8 = pio4_hi - (double)2 * d6;
            d2 = pio4_hi - (d7 - d8);
        }
        return n > 0 ? d2 : -d2;
    }

    public static final double acos(double d) {
        double d2;
        int n = JMath.__HI(d);
        int n2 = n & Integer.MAX_VALUE;
        if (n2 >= 0x3FF00000) {
            if ((n2 - 0x3FF00000 | JMath.__LO(d)) == 0) {
                if (n > 0) {
                    return 0.0;
                }
                return PI + (double)2 * pio2_lo;
            }
            return (d - d) / (d - d);
        }
        if (n2 < 1071644672) {
            if (n2 <= 1012924416) {
                return pio2_hi + pio2_lo;
            }
            double d3 = d * d;
            double d4 = d3 * (pS0 + d3 * (pS1 + d3 * (pS2 + d3 * (pS3 + d3 * (pS4 + d3 * pS5)))));
            double d5 = one + d3 * (qS1 + d3 * (qS2 + d3 * (qS3 + d3 * qS4)));
            double d6 = d4 / d5;
            return pio2_hi - (d - (pio2_lo - d * d6));
        }
        if (n < 0) {
            double d7 = (one + d) * 0.5;
            double d8 = d7 * (pS0 + d7 * (pS1 + d7 * (pS2 + d7 * (pS3 + d7 * (pS4 + d7 * pS5)))));
            double d9 = one + d7 * (qS1 + d7 * (qS2 + d7 * (qS3 + d7 * qS4)));
            double d10 = JMath.sqrt(d7);
            double d11 = d8 / d9;
            double d12 = d11 * d10 - pio2_lo;
            return PI - (double)2 * (d10 + d12);
        }
        double d13 = (one - d) * 0.5;
        double d14 = d2 = JMath.sqrt(d13);
        d14 = JMath.setLO(d14, 0);
        double d15 = (d13 - d14 * d14) / (d2 + d14);
        double d16 = d13 * (pS0 + d13 * (pS1 + d13 * (pS2 + d13 * (pS3 + d13 * (pS4 + d13 * pS5)))));
        double d17 = one + d13 * (qS1 + d13 * (qS2 + d13 * (qS3 + d13 * qS4)));
        double d18 = d16 / d17;
        double d19 = d18 * d2 + d15;
        return (double)2 * (d14 + d19);
    }

    public static final double atan(double d) {
        int n;
        int n2 = JMath.__HI(d);
        int n3 = n2 & Integer.MAX_VALUE;
        if (n3 >= 0x44100000) {
            if (n3 > 0x7FF00000 || n3 == 0x7FF00000 && JMath.__LO(d) != 0) {
                return d + d;
            }
            if (n2 > 0) {
                return atanhi[3] + atanlo[3];
            }
            return -atanhi[3] - atanlo[3];
        }
        if (n3 < 1071382528) {
            if (n3 < 1042284544 && 1.0E300 + d > one) {
                return d;
            }
            n = -1;
        } else {
            d = JMath.abs(d);
            if (n3 < 0x3FF30000) {
                if (n3 < 1072037888) {
                    n = 0;
                    d = ((double)2 * d - one) / ((double)2 + d);
                } else {
                    n = 1;
                    d = (d - one) / (d + one);
                }
            } else if (n3 < 1073971200) {
                n = 2;
                d = (d - 1.5) / (one + 1.5 * d);
            } else {
                n = 3;
                d = -1.0 / d;
            }
        }
        double d2 = d * d;
        double d3 = d2 * d2;
        double d4 = d2 * (aT[0] + d3 * (aT[2] + d3 * (aT[4] + d3 * (aT[6] + d3 * (aT[8] + d3 * aT[10])))));
        double d5 = d3 * (aT[1] + d3 * (aT[3] + d3 * (aT[5] + d3 * (aT[7] + d3 * aT[9]))));
        if (n < 0) {
            return d - d * (d4 + d5);
        }
        d2 = atanhi[n] - (d * (d4 + d5) - atanlo[n] - d);
        return n2 < 0 ? -d2 : d2;
    }

    public static final double atan2(double d, double d2) {
        int n = JMath.__HI(d2);
        int n2 = n & Integer.MAX_VALUE;
        int n3 = JMath.__LO(d2);
        int n4 = JMath.__HI(d);
        int n5 = n4 & Integer.MAX_VALUE;
        int n6 = JMath.__LO(d);
        if ((n2 | (n3 | -n3) >>> 31) > 0x7FF00000 || (n5 | (n6 | -n6) >>> 31) > 0x7FF00000) {
            return d2 + d;
        }
        if ((n - 0x3FF00000 | n3) == 0) {
            return JMath.atan(d);
        }
        int n7 = n4 >> 31 & 1 | n >> 30 & 2;
        if ((n5 | n6) == 0) {
            switch (n7) {
                case 0: 
                case 1: {
                    return d;
                }
                case 2: {
                    return PI + 1.0E-300;
                }
                case 3: {
                    return -PI - 1.0E-300;
                }
            }
        }
        if ((n2 | n3) == 0) {
            return n4 < 0 ? -pi_o_2 - 1.0E-300 : pi_o_2 + 1.0E-300;
        }
        if (n2 == 0x7FF00000) {
            if (n5 == 0x7FF00000) {
                switch (n7) {
                    case 0: {
                        return pi_o_4 + 1.0E-300;
                    }
                    case 1: {
                        return -pi_o_4 - 1.0E-300;
                    }
                    case 2: {
                        return (double)3 * pi_o_4 + 1.0E-300;
                    }
                    case 3: {
                        return -3.0 * pi_o_4 - 1.0E-300;
                    }
                }
            } else {
                switch (n7) {
                    case 0: {
                        return 0.0;
                    }
                    case 1: {
                        return -0.0;
                    }
                    case 2: {
                        return PI + 1.0E-300;
                    }
                    case 3: {
                        return -PI - 1.0E-300;
                    }
                }
            }
        }
        if (n5 == 0x7FF00000) {
            return n4 < 0 ? -pi_o_2 - 1.0E-300 : pi_o_2 + 1.0E-300;
        }
        int n8 = n5 - n2 >> 20;
        double d3 = n8 > 60 ? pi_o_2 + 0.5 * pi_lo : (n < 0 && n8 < -60 ? 0.0 : JMath.atan(JMath.abs(d / d2)));
        switch (n7) {
            case 0: {
                return d3;
            }
            case 1: {
                return JMath.setHI(d3, JMath.__HI(d3) ^ Integer.MIN_VALUE);
            }
            case 2: {
                return PI - (d3 - pi_lo);
            }
        }
        return d3 - pi_lo - PI;
    }

    private static final int __ieee754_rem_pio2(double d, double[] dArray) {
        double d2 = 0.0;
        double[] dArray2 = new double[3];
        int n = JMath.__HI(d);
        int n2 = n & Integer.MAX_VALUE;
        if (n2 <= 1072243195) {
            dArray[0] = d;
            dArray[1] = 0.0;
            return 0;
        }
        if (n2 < 1073928572) {
            if (n > 0) {
                d2 = d - pio2_1;
                if (n2 != 1073291771) {
                    dArray[0] = d2 - pio2_1t;
                    dArray[1] = d2 - dArray[0] - pio2_1t;
                } else {
                    dArray[0] = (d2 -= pio2_2) - pio2_2t;
                    dArray[1] = d2 - dArray[0] - pio2_2t;
                }
                return 1;
            }
            d2 = d + pio2_1;
            if (n2 != 1073291771) {
                dArray[0] = d2 + pio2_1t;
                dArray[1] = d2 - dArray[0] + pio2_1t;
            } else {
                dArray[0] = (d2 += pio2_2) + pio2_2t;
                dArray[1] = d2 - dArray[0] + pio2_2t;
            }
            return -1;
        }
        if (n2 <= 1094263291) {
            double d3 = JMath.abs(d);
            int n3 = (int)(d3 * invpio2 + half);
            double d4 = n3;
            double d5 = d3 - d4 * pio2_1;
            double d6 = d4 * pio2_1t;
            if (n3 < 32 && n2 != npio2_hw[n3 - 1]) {
                dArray[0] = d5 - d6;
            } else {
                int n4 = n2 >> 20;
                dArray[0] = d5 - d6;
                int n5 = n4 - (JMath.__HI(dArray[0]) >> 20 & 0x7FF);
                if (n5 > 16) {
                    d3 = d5;
                    d6 = d4 * pio2_2;
                    d5 = d3 - d6;
                    d6 = d4 * pio2_2t - (d3 - d5 - d6);
                    dArray[0] = d5 - d6;
                    n5 = n4 - (JMath.__HI(dArray[0]) >> 20 & 0x7FF);
                    if (n5 > 49) {
                        d3 = d5;
                        d6 = d4 * pio2_3;
                        d5 = d3 - d6;
                        d6 = d4 * pio2_3t - (d3 - d5 - d6);
                        dArray[0] = d5 - d6;
                    }
                }
            }
            dArray[1] = d5 - dArray[0] - d6;
            if (n < 0) {
                dArray[0] = -dArray[0];
                dArray[1] = -dArray[1];
                return -n3;
            }
            return n3;
        }
        if (n2 >= 0x7FF00000) {
            dArray[0] = dArray[1] = d - d;
            return 0;
        }
        long l = Double.doubleToLongBits(d);
        long l2 = (0x7FF0000000000000L & l) >> 52;
        l -= (l2 -= 1046L) << 52;
        d2 = Double.longBitsToDouble(l &= Long.MAX_VALUE);
        int n6 = 0;
        while (n6 < 2) {
            dArray2[n6] = (int)d2;
            d2 = (d2 - dArray2[n6]) * two24;
            ++n6;
        }
        dArray2[2] = d2;
        int n7 = 3;
        while (dArray2[n7 - 1] == 0.0) {
            --n7;
        }
        int n8 = JMath.__kernel_rem_pio2(dArray2, dArray, (int)l2, n7);
        if (n < 0) {
            dArray[0] = -dArray[0];
            dArray[1] = -dArray[1];
            return -n8;
        }
        return n8;
    }

    private static final int __kernel_rem_pio2(double[] dArray, double[] dArray2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        double d;
        double d2;
        int n6;
        double[] dArray3 = new double[20];
        double[] dArray4 = new double[20];
        double[] dArray5 = new double[20];
        int[] nArray = new int[20];
        int n7 = n6 = 4;
        int n8 = n2 - 1;
        int n9 = (n - 3) / 24;
        if (n9 < 0) {
            n9 = 0;
        }
        int n10 = n - 24 * (n9 + 1);
        int n11 = n9 - n8;
        int n12 = n8 + n6;
        int n13 = 0;
        while (n13 <= n12) {
            dArray3[n13] = n11 < 0 ? 0.0 : (double)two_over_pi[n11];
            ++n13;
            ++n11;
        }
        n13 = 0;
        while (n13 <= n6) {
            n11 = 0;
            d2 = 0.0;
            while (n11 <= n8) {
                d2 += dArray[n11] * dArray3[n8 + n13 - n11];
                ++n11;
            }
            dArray4[n13] = d2;
            ++n13;
        }
        int n14 = n6;
        while (true) {
            n13 = 0;
            n11 = n14;
            d = dArray4[n14];
            while (n11 > 0) {
                d2 = (int)(twon24 * d);
                nArray[n13] = (int)(d - two24 * d2);
                d = dArray4[n11 - 1] + d2;
                ++n13;
                --n11;
            }
            d = JMath.scalbn(d, n10);
            d -= 8.0 * JMath.floor(d * 0.125);
            n5 = (int)d;
            d -= (double)n5;
            n4 = 0;
            if (n10 > 0) {
                n13 = nArray[n14 - 1] >> 24 - n10;
                n5 += n13;
                int n15 = n14 - 1;
                nArray[n15] = nArray[n15] - (n13 << 24 - n10);
                n4 = nArray[n14 - 1] >> 23 - n10;
            } else if (n10 == 0) {
                n4 = nArray[n14 - 1] >> 23;
            } else if (d >= 0.5) {
                n4 = 2;
            }
            if (n4 > 0) {
                ++n5;
                boolean bl = false;
                n13 = 0;
                while (n13 < n14) {
                    n11 = nArray[n13];
                    if (!bl) {
                        if (n11 != 0) {
                            bl = true;
                            nArray[n13] = 0x1000000 - n11;
                        }
                    } else {
                        nArray[n13] = 0xFFFFFF - n11;
                    }
                    ++n13;
                }
                if (n10 > 0) {
                    switch (n10) {
                        case 1: {
                            int n16 = n14 - 1;
                            nArray[n16] = nArray[n16] & 0x7FFFFF;
                            break;
                        }
                        case 2: {
                            int n17 = n14 - 1;
                            nArray[n17] = nArray[n17] & 0x3FFFFF;
                        }
                    }
                }
                if (n4 == 2) {
                    d = one - d;
                    if (bl) {
                        d -= JMath.scalbn(one, n10);
                    }
                }
            }
            if (d != 0.0) break;
            n11 = 0;
            n13 = n14 - 1;
            while (n13 >= n6) {
                n11 |= nArray[n13];
                --n13;
            }
            if (n11 != 0) break;
            n3 = 1;
            while (nArray[n6 - n3] == 0) {
                ++n3;
            }
            n13 = n14 + 1;
            while (n13 <= n14 + n3) {
                dArray3[n8 + n13] = two_over_pi[n9 + n13];
                n11 = 0;
                d2 = 0.0;
                while (n11 <= n8) {
                    d2 += dArray[n11] * dArray3[n8 + n13 - n11];
                    ++n11;
                }
                dArray4[n13] = d2;
                ++n13;
            }
            n14 += n3;
        }
        if (d == 0.0) {
            --n14;
            n10 -= 24;
            while (nArray[n14] == 0) {
                --n14;
                n10 -= 24;
            }
        } else if ((d = JMath.scalbn(d, -n10)) >= two24) {
            d2 = (int)(twon24 * d);
            nArray[n14] = (int)(d - two24 * d2);
            n10 += 24;
            nArray[++n14] = (int)d2;
        } else {
            nArray[n14] = (int)d;
        }
        d2 = JMath.scalbn(one, n10);
        n13 = n14;
        while (n13 >= 0) {
            dArray4[n13] = d2 * (double)nArray[n13];
            d2 *= twon24;
            --n13;
        }
        n13 = n14;
        while (n13 >= 0) {
            d2 = 0.0;
            n3 = 0;
            while (n3 <= n7 && n3 <= n14 - n13) {
                d2 += PIo2[n3] * dArray4[n13 + n3];
                ++n3;
            }
            dArray5[n14 - n13] = d2;
            --n13;
        }
        d2 = 0.0;
        n13 = n14;
        while (n13 >= 0) {
            d2 += dArray5[n13];
            --n13;
        }
        dArray2[0] = n4 == 0 ? d2 : -d2;
        d2 = dArray5[0] - d2;
        n13 = 1;
        while (n13 <= n14) {
            d2 += dArray5[n13];
            ++n13;
        }
        dArray2[1] = n4 == 0 ? d2 : -d2;
        return n5 & 7;
    }

    public static final double pow(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        int n;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        int n2;
        int n3;
        int n4 = JMath.__HI(d);
        int n5 = JMath.__LO(d);
        int n6 = JMath.__HI(d2);
        int n7 = JMath.__LO(d2);
        int n8 = n4 & Integer.MAX_VALUE;
        int n9 = n6 & Integer.MAX_VALUE;
        if ((n9 | n7) == 0) {
            return one;
        }
        if (n8 > 0x7FF00000 || n8 == 0x7FF00000 && n5 != 0 || n9 > 0x7FF00000 || n9 == 0x7FF00000 && n7 != 0) {
            return d + d2;
        }
        int n10 = 0;
        if (n4 < 0) {
            if (n9 >= 0x43400000) {
                n10 = 2;
            } else if (n9 >= 0x3FF00000) {
                n3 = (n9 >> 20) - 1023;
                if (n3 > 20) {
                    n2 = n7 >>> 52 - n3;
                    if (n2 << 52 - n3 == n7) {
                        n10 = 2 - (n2 & 1);
                    }
                } else if (n7 == 0 && (n2 = n9 >> 20 - n3) << 20 - n3 == n9) {
                    n10 = 2 - (n2 & 1);
                }
            }
        }
        if (n7 == 0) {
            if (n9 == 0x7FF00000) {
                if ((n8 - 0x3FF00000 | n5) == 0) {
                    return d2 - d2;
                }
                if (n8 >= 0x3FF00000) {
                    return n6 >= 0 ? d2 : 0.0;
                }
                return n6 < 0 ? -d2 : 0.0;
            }
            if (n9 == 0x3FF00000) {
                if (n6 < 0) {
                    return one / d;
                }
                return d;
            }
            if (n6 == 0x40000000) {
                return d * d;
            }
            if (n6 == 1071644672 && n4 >= 0) {
                return JMath.sqrt(d);
            }
        }
        double d13 = JMath.abs(d);
        if (n5 == 0 && (n8 == 0x7FF00000 || n8 == 0 || n8 == 0x3FF00000)) {
            double d14 = d13;
            if (n6 < 0) {
                d14 = one / d14;
            }
            if (n4 < 0) {
                if ((n8 - 0x3FF00000 | n10) == 0) {
                    d14 = (d14 - d14) / (d14 - d14);
                } else if (n10 == 1) {
                    d14 = -d14;
                }
            }
            return d14;
        }
        if (((n4 >> 31) + 1 | n10) == 0) {
            return (d - d) / (d - d);
        }
        if (n9 > 1105199104) {
            if (n9 > 1139802112) {
                if (n8 <= 0x3FEFFFFF) {
                    return n6 < 0 ? Double.POSITIVE_INFINITY : 0.0;
                }
                if (n8 >= 0x3FF00000) {
                    return n6 > 0 ? Double.POSITIVE_INFINITY : 0.0;
                }
            }
            if (n8 < 0x3FEFFFFF) {
                return n6 < 0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            if (n8 > 0x3FF00000) {
                return n6 > 0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            d12 = d - 1.0;
            d11 = d12 * d12 * (0.5 - d12 * (0.3333333333333333 - d12 * 0.25));
            d10 = ivln2_h * d12;
            d9 = d12 * ivln2_l - d11 * ivln2;
            d8 = d10 + d9;
            d8 = JMath.setLO(d8, 0);
            d7 = d9 - (d8 - d10);
        } else {
            n = 0;
            if (n8 < 0x100000) {
                n -= 53;
                n8 = JMath.__HI(d13 *= two53);
            }
            n += (n8 >> 20) - 1023;
            n2 = n8 & 0xFFFFF;
            n8 = n2 | 0x3FF00000;
            if (n2 <= 235662) {
                n3 = 0;
            } else if (n2 < 767610) {
                n3 = 1;
            } else {
                n3 = 0;
                ++n;
                n8 -= 0x100000;
            }
            d13 = JMath.setHI(d13, n8);
            d10 = d13 - bp[n3];
            d9 = one / (d13 + bp[n3]);
            double d15 = d6 = d10 * d9;
            d15 = JMath.setLO(d15, 0);
            double d16 = 0.0;
            d16 = JMath.setHI(d16, (n8 >> 1 | 0x20000000) + 524288 + (n3 << 18));
            double d17 = d13 - (d16 - bp[n3]);
            double d18 = d9 * (d10 - d15 * d16 - d15 * d17);
            double d19 = d6 * d6;
            d5 = d19 * d19 * (L1 + d19 * (L2 + d19 * (L3 + d19 * (L4 + d19 * (L5 + d19 * L6)))));
            d19 = d15 * d15;
            d16 = (double)3 + d19 + (d5 += d18 * (d15 + d6));
            d16 = JMath.setLO(d16, 0);
            d17 = d5 - (d16 - (double)3 - d19);
            d10 = d15 * d16;
            d9 = d18 * d16 + d17 * d6;
            d4 = d10 + d9;
            d4 = JMath.setLO(d4, 0);
            d3 = d9 - (d4 - d10);
            double d20 = cp_h * d4;
            double d21 = cp_l * d4 + d3 * cp + dp_l[n3];
            d12 = n;
            d8 = d20 + d21 + dp_h[n3] + d12;
            d8 = JMath.setLO(d8, 0);
            d7 = d21 - (d8 - d12 - dp_h[n3] - d20);
        }
        d6 = one;
        if (((n4 >> 31) + 1 | n10 - 1) == 0) {
            d6 = -one;
        }
        double d22 = d2;
        d22 = JMath.setLO(d22, 0);
        d3 = (d2 - d22) * d8 + d2 * d7;
        d4 = d22 * d8;
        double d23 = d3 + d4;
        n2 = JMath.__HI(d23);
        int n11 = JMath.__LO(d23);
        if (n2 >= 0x40900000) {
            if ((n2 - 0x40900000 | n11) != 0) {
                return d6 * 1.0E300 * 1.0E300;
            }
            if (d3 + 8.008566259537294E-17 > d23 - d4) {
                return d6 * 1.0E300 * 1.0E300;
            }
        } else if ((n2 & Integer.MAX_VALUE) >= 1083231232) {
            if ((n2 - -1064252416 | n11) != 0) {
                return d6 * 1.0E-300 * 1.0E-300;
            }
            if (d3 <= d23 - d4) {
                return d6 * 1.0E-300 * 1.0E-300;
            }
        }
        n11 = n2 & Integer.MAX_VALUE;
        n3 = (n11 >> 20) - 1023;
        n = 0;
        if (n11 > 1071644672) {
            n = n2 + (0x100000 >> n3 + 1);
            n3 = ((n & Integer.MAX_VALUE) >> 20) - 1023;
            d12 = 0.0;
            d12 = JMath.setHI(d12, n & ~(1048575 >> n3));
            n = (n & 0xFFFFF | 0x100000) >> 20 - n3;
            if (n2 < 0) {
                n = -n;
            }
            d4 -= d12;
        }
        d12 = d3 + d4;
        d12 = JMath.setLO(d12, 0);
        d10 = d12 * lg2_h;
        d9 = (d3 - (d12 - d4)) * lg2 + d12 * -1.904654299957768E-9;
        d23 = d10 + d9;
        d11 = d9 - (d23 - d10);
        d12 = d23 * d23;
        d8 = d23 - d12 * (P1 + d12 * (P2 + d12 * (P3 + d12 * (P4 + d12 * P5))));
        d5 = d23 * d8 / (d8 - (double)2) - (d11 + d23 * d11);
        d23 = one - (d5 - d23);
        n2 = JMath.__HI(d23);
        if ((n2 += n << 20) >> 20 <= 0) {
            d23 = JMath.scalbn(d23, n);
        } else {
            n11 = JMath.__HI(d23);
            d23 = JMath.setHI(d23, n11 += n << 20);
        }
        return d6 * d23;
    }

    private static final double copysign(double d, double d2) {
        long l = Double.doubleToLongBits(d);
        long l2 = Double.doubleToLongBits(d2);
        l = Long.MAX_VALUE * l | Long.MIN_VALUE & l2;
        return Double.longBitsToDouble(l);
    }

    private static final double scalbn(double d, int n) {
        int n2 = JMath.__HI(d);
        int n3 = JMath.__LO(d);
        int n4 = (n2 & 0x7FF00000) >> 20;
        if (n4 == 0) {
            if ((n3 | n2 & Integer.MAX_VALUE) == 0) {
                return d;
            }
            n2 = JMath.__HI(d *= two54);
            n4 = ((n2 & 0x7FF00000) >> 20) - 54;
            if (n < -50000) {
                return 1.0E-300 * d;
            }
        }
        if (n4 == 2047) {
            return d + d;
        }
        if ((n4 += n) > 2046) {
            return 1.0E300 * JMath.copysign(1.0E300, d);
        }
        if (n4 > 0) {
            return JMath.setHI(d, n2 & 0x800FFFFF | n4 << 20);
        }
        if (n4 <= -54) {
            if (n > 50000) {
                return 1.0E300 * JMath.copysign(1.0E300, d);
            }
        } else {
            return 1.0E-300 * JMath.copysign(1.0E-300, d);
        }
        return twom54 * JMath.setHI(d, n2 & 0x800FFFFF | (n4 += 54) << 20);
    }

    private static final double set(int n, int n2) {
        return Double.longBitsToDouble((long)n << 32 | (long)n2);
    }

    private static final double setLO(double d, int n) {
        long l = Double.doubleToLongBits(d);
        l &= 0xFFFFFFFF00000000L;
        return Double.longBitsToDouble(l |= (long)n);
    }

    private static final double setHI(double d, int n) {
        long l = Double.doubleToLongBits(d);
        l &= 0xFFFFFFFFL;
        return Double.longBitsToDouble(l |= (long)n << 32);
    }

    private static final int __HI(double d) {
        return (int)((long)-1 & Double.doubleToLongBits(d) >> 32);
    }

    private static final int __LO(double d) {
        return (int)((long)-1 & Double.doubleToLongBits(d));
    }

    static {
        TWO52 = new double[]{Double.longBitsToDouble(0x4330000000000000L), Double.longBitsToDouble(-4382002437431492608L)};
        NEGATIVE_ZERO = Double.longBitsToDouble(Long.MIN_VALUE);
        halF = new double[]{0.5, -0.5};
        twom1000 = Double.longBitsToDouble(0x170000000000000L);
        o_threshold = Double.longBitsToDouble(4649454530587146735L);
        u_threshold = Double.longBitsToDouble(-4573606559926636463L);
        ln2HI = new double[]{Double.longBitsToDouble(4604418534311723008L), Double.longBitsToDouble(-4618953502543052800L)};
        ln2LO = new double[]{Double.longBitsToDouble(4461442080421002358L), Double.longBitsToDouble(-4761929956433773450L)};
        invln2 = Double.longBitsToDouble(4609176140021203710L);
        P1 = Double.longBitsToDouble(4595172819793696062L);
        P2 = Double.longBitsToDouble(-4654820494858601069L);
        P3 = Double.longBitsToDouble(4544508515198557740L);
        P4 = Double.longBitsToDouble(-4702957295668925455L);
        P5 = Double.longBitsToDouble(4496342204012209360L);
        ln2_hi = Double.longBitsToDouble(4604418534311723008L);
        ln2_lo = Double.longBitsToDouble(4461442080421002358L);
        Lg1 = Double.longBitsToDouble(4604180019048437139L);
        Lg2 = Double.longBitsToDouble(4600877379321592324L);
        Lg3 = Double.longBitsToDouble(4598818590951641945L);
        Lg4 = Double.longBitsToDouble(4597174411056806063L);
        Lg5 = Double.longBitsToDouble(4595719342595441630L);
        Lg6 = Double.longBitsToDouble(4594685411790997151L);
        Lg7 = Double.longBitsToDouble(4594499633228436036L);
        S1 = -0.16666666666666632;
        S2 = 0.00833333333332249;
        S3 = -1.984126982985795E-4;
        S4 = 2.7557313707070068E-6;
        S5 = -2.5050760253406863E-8;
        S6 = 1.58969099521155E-10;
        one = Double.longBitsToDouble(0x3FF0000000000000L);
        C1 = Double.longBitsToDouble(4586165620538955084L);
        C2 = Double.longBitsToDouble(-4659324094485802633L);
        C3 = Double.longBitsToDouble(4537941361668330896L);
        C4 = Double.longBitsToDouble(-4714566979978243411L);
        C5 = Double.longBitsToDouble(4477121870137962948L);
        C6 = Double.longBitsToDouble(-4780295122622859052L);
        pio4 = Double.longBitsToDouble(4605249457297304856L);
        pio4lo = Double.longBitsToDouble(4359948597267291143L);
        T = new double[]{Double.longBitsToDouble(4599676419421066595L), Double.longBitsToDouble(4593971859893059194L), Double.longBitsToDouble(4587938466107703806L), Double.longBitsToDouble(4581960672245896759L), Double.longBitsToDouble(4576262931677611155L), Double.longBitsToDouble(4570429193025094440L), Double.longBitsToDouble(4564358403679355669L), Double.longBitsToDouble(4558562946408670465L), Double.longBitsToDouble(4553182066015801448L), Double.longBitsToDouble(4545397049192321702L), Double.longBitsToDouble(4544897349388904425L), Double.longBitsToDouble(-4687273268743220365L), Double.longBitsToDouble(4538267711989316308L)};
        pio2_hi = Double.longBitsToDouble(4609753056924675352L);
        pio2_lo = Double.longBitsToDouble(4364452196894661639L);
        pio4_hi = Double.longBitsToDouble(4605249457297304856L);
        pS0 = Double.longBitsToDouble(4595172819793696085L);
        pS1 = Double.longBitsToDouble(-4623835544539140227L);
        pS2 = Double.longBitsToDouble(4596417465768494165L);
        pS3 = Double.longBitsToDouble(-4637438604930937029L);
        pS4 = Double.longBitsToDouble(4560439845004096136L);
        pS5 = Double.longBitsToDouble(4540259411154564873L);
        qS1 = Double.longBitsToDouble(-4610777653840302773L);
        qS2 = Double.longBitsToDouble(4611733184086379208L);
        qS3 = Double.longBitsToDouble(-4618997306433404583L);
        qS4 = Double.longBitsToDouble(4590215604441354882L);
        atanhi = new double[]{Double.longBitsToDouble(4602023952714414927L), Double.longBitsToDouble(4605249457297304856L), Double.longBitsToDouble(4607027438436873883L), Double.longBitsToDouble(4609753056924675352L)};
        atanlo = new double[]{Double.longBitsToDouble(4357843414468748770L), Double.longBitsToDouble(4359948597267291143L), Double.longBitsToDouble(4354989122426817469L), Double.longBitsToDouble(4364452196894661639L)};
        aT = new double[]{Double.longBitsToDouble(4599676419421066509L), Double.longBitsToDouble(-4626998257160492092L), Double.longBitsToDouble(4594314991288484863L), Double.longBitsToDouble(-4630701217362536847L), Double.longBitsToDouble(4591215095208222830L), Double.longBitsToDouble(-4633165035261879699L), Double.longBitsToDouble(4589464229703073105L), Double.longBitsToDouble(-4634804155249132134L), Double.longBitsToDouble(4587333258118041067L), Double.longBitsToDouble(-4637946461342241745L), Double.longBitsToDouble(4580351289466214929L)};
        pi_o_4 = Double.longBitsToDouble(4605249457297304856L);
        pi_o_2 = Double.longBitsToDouble(4609753056924675352L);
        pi_lo = Double.longBitsToDouble(4368955796522032135L);
        two_over_pi = new int[]{10680707, 0x6E4E44, 1387004, 2578385, 16069853, 12639074, 9804092, 4427841, 16666979, 11263675, 12935607, 2387514, 0x424DD2, 14681673, 3074569, 13734428, 16653803, 1880361, 10960616, 8533493, 3062596, 8710556, 7349940, 6258241, 3772886, 3769171, 3798172, 8675211, 12450088, 3874808, 9961438, 366607, 15675153, 9132554, 7151469, 3571407, 2607881, 12013382, 4155038, 6285869, 7677882, 13102053, 15825725, 473591, 9065106, 15363067, 6271263, 9264392, 5636912, 4652155, 7056368, 13614112, 10155062, 1944035, 9527646, 15080200, 6658437, 6231200, 6832269, 16767104, 5075751, 3212806, 1398474, 7579849, 6349435, 12618859};
        npio2_hw = new int[]{1073291771, 1074340347, 1074977148, 1075388923, 1075800698, 1076025724, 1076231611, 1076437499, 1076643386, 1076849274, 1076971356, 1077074300, 1077177244, 1077280187, 1077383131, 1077486075, 1077589019, 1077691962, 1077794906, 1077897850, 1077968460, 1078019932, 1078071404, 1078122876, 1078174348, 1078225820, 1078277292, 1078328763, 1078380235, 1078431707, 1078483179, 1078534651};
        half = Double.longBitsToDouble(4602678819172646912L);
        two24 = Double.longBitsToDouble(4715268809856909312L);
        invpio2 = Double.longBitsToDouble(4603909380684499075L);
        pio2_1 = Double.longBitsToDouble(4609753056924401664L);
        pio2_1t = Double.longBitsToDouble(4454258360616903473L);
        pio2_2 = Double.longBitsToDouble(4454258360616747008L);
        pio2_2t = Double.longBitsToDouble(4297306550709743731L);
        pio2_3 = Double.longBitsToDouble(4297306550709518336L);
        pio2_3t = Double.longBitsToDouble(4142048980368378305L);
        PIo2 = new double[]{Double.longBitsToDouble(4609753056584663040L), Double.longBitsToDouble(4500296887714185216L), Double.longBitsToDouble(4393339057296375808L), Double.longBitsToDouble(4285399695318056960L), Double.longBitsToDouble(4174867106174599168L), Double.longBitsToDouble(4069606033725587456L), Double.longBitsToDouble(3955147982449410048L), Double.longBitsToDouble(3848874662444400640L)};
        twon24 = Double.longBitsToDouble(4499096027743125504L);
        bp = new double[]{1.0, 1.5};
        double[] dArray = new double[2];
        dArray[1] = Double.longBitsToDouble(4603444093224222720L);
        dp_h = dArray;
        double[] dArray2 = new double[2];
        dArray2[1] = Double.longBitsToDouble(4489242115478376454L);
        dp_l = dArray2;
        two53 = Double.longBitsToDouble(0x4340000000000000L);
        L1 = Double.longBitsToDouble(4603579539098120963L);
        L2 = Double.longBitsToDouble(4601392076422097919L);
        L3 = Double.longBitsToDouble(4599676419357746765L);
        L4 = Double.longBitsToDouble(4598584653024936193L);
        L5 = Double.longBitsToDouble(4597478449480325989L);
        L6 = Double.longBitsToDouble(4596625081194860271L);
        lg2 = Double.longBitsToDouble(4604418534313441775L);
        lg2_h = Double.longBitsToDouble(4604418534330597376L);
        cp = Double.longBitsToDouble(4606838314010018813L);
        cp_h = Double.longBitsToDouble(4606838314073325568L);
        cp_l = Double.longBitsToDouble(-4738297118486494731L);
        ivln2 = Double.longBitsToDouble(4609176140021203710L);
        ivln2_h = Double.longBitsToDouble(4609176139934466048L);
        ivln2_l = Double.longBitsToDouble(4491406094830001988L);
        two54 = Double.longBitsToDouble(4850376798678024192L);
        twom54 = Double.longBitsToDouble(4363988038922010624L);
    }
}

