/*
 * Decompiled with CFR 0.152.
 */
package UTF;

import Clazz.jq_ClassFileConstants;
import Run_Time.Debug;
import UTF.UTFDataFormatError;
import Util.Assert;
import Util.Collections.UnmodifiableIterator;
import java.io.DataOutput;
import java.io.IOException;

public class Utf8
implements jq_ClassFileConstants {
    public static boolean TRACE = false;
    public static final int STARTING_TABLE_SIZE = 16384;
    public static final int STARTING_HASH_SIZE = 9999;
    public static final int STARTING_CHAIN_SIZE = 4;
    public static Utf8[] table = new Utf8[16384];
    public static int size = -1;
    public static int[][] chains = new int[9999][];
    public static final Utf8 BYTE_DESC = Utf8.get("B");
    public static final Utf8 CHAR_DESC = Utf8.get("C");
    public static final Utf8 DOUBLE_DESC = Utf8.get("D");
    public static final Utf8 FLOAT_DESC = Utf8.get("F");
    public static final Utf8 INT_DESC = Utf8.get("I");
    public static final Utf8 LONG_DESC = Utf8.get("J");
    public static final Utf8 SHORT_DESC = Utf8.get("S");
    public static final Utf8 BOOLEAN_DESC = Utf8.get("Z");
    public static final Utf8 VOID_DESC = Utf8.get("V");
    public static boolean NO_NEW = false;
    public static final boolean USE_CACHE = true;
    public static final boolean DEBUG = true;
    static final boolean STRICTLY_CHECK_FORMAT = false;
    static final boolean ALLOW_NORMAL_UTF8 = false;
    static final boolean ALLOW_PSEUDO_UTF8 = true;
    static final boolean WRITE_PSEUDO_UTF8 = true;
    private byte[] data;
    private int hash;
    private String cache;

    public static Utf8 get(String string) {
        return Utf8.get(Utf8.toUtf8(string));
    }

    public static Utf8 get(byte[] byArray) {
        int n = Utf8.getID(byArray);
        return table[n];
    }

    public static Utf8 get(byte[] byArray, int n, int n2) {
        int n3 = Utf8.getID(byArray, n, n2);
        return table[n3];
    }

    public static int getID(byte[] byArray) {
        int n = Utf8.hashCode(byArray);
        int n2 = Math.abs(n) % chains.length;
        int[] nArray = chains[n2];
        if (nArray == null) {
            nArray = new int[4];
            Utf8.chains[n2] = nArray;
            return Utf8.addToTable_helper(byArray, n, nArray, 0);
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3] - 1;
            if (n4 == -1) {
                return Utf8.addToTable_helper(byArray, n, nArray, n3);
            }
            Utf8 utf8 = table[n4];
            if (Utf8.memcmp(utf8.data, byArray)) {
                return n4;
            }
            ++n3;
        }
        int[] nArray2 = new int[nArray.length << 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Utf8.chains[n2] = nArray2;
        return Utf8.addToTable_helper(byArray, n, nArray2, nArray.length);
    }

    public static int getID(byte[] byArray, int n, int n2) {
        int n3 = Utf8.hashCode(byArray, n, n2);
        int n4 = Math.abs(n3) % chains.length;
        int[] nArray = chains[n4];
        if (nArray == null) {
            nArray = new int[4];
            Utf8.chains[n4] = nArray;
            byte[] byArray2 = new byte[n2 - n];
            System.arraycopy(byArray, n, byArray2, 0, n2 - n);
            return Utf8.addToTable_helper(byArray2, n3, nArray, 0);
        }
        int n5 = 0;
        while (n5 < nArray.length) {
            Object object;
            int n6 = nArray[n5] - 1;
            if (n6 == -1) {
                object = new byte[n2 - n];
                System.arraycopy(byArray, n, object, 0, n2 - n);
                return Utf8.addToTable_helper((byte[])object, n3, nArray, n5);
            }
            object = table[n6];
            if (Utf8.memcmp(((Utf8)object).data, byArray, n, n2)) {
                return n6;
            }
            ++n5;
        }
        int[] nArray2 = new int[nArray.length << 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Utf8.chains[n4] = nArray2;
        byte[] byArray3 = new byte[n2 - n];
        System.arraycopy(byArray, n, byArray3, 0, n2 - n);
        return Utf8.addToTable_helper(byArray3, n3, nArray2, nArray.length);
    }

    public boolean isValidMethodDescriptor() {
        if (this.data.length < 3) {
            return false;
        }
        if (this.data[0] != 40) {
            return false;
        }
        int n = 1;
        while (this.data[n] != 41) {
            switch (this.data[n]) {
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 90: 
                case 91: {
                    break;
                }
                case 76: {
                    do {
                        if (++n != this.data.length) continue;
                        return false;
                    } while (this.data[n] != 59);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (++n != this.data.length) continue;
            return false;
        }
        boolean bl = false;
        if (this.data[++n] == 86 && n == this.data.length - 1 || this.isValidTypeDescriptor(n)) {
            bl = true;
        }
        return bl;
    }

    public boolean isValidTypeDescriptor() {
        return this.isValidTypeDescriptor(0);
    }

    private final boolean isValidTypeDescriptor(int n) {
        block5: while (true) {
            if (this.data.length == n) {
                return false;
            }
            switch (this.data[n]) {
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 90: {
                    boolean bl = false;
                    if (n == this.data.length - 1) {
                        bl = true;
                    }
                    return bl;
                }
                case 91: {
                    ++n;
                    continue block5;
                }
                case 76: {
                    do {
                        if (++n != this.data.length) continue;
                        return false;
                    } while (this.data[n] != 59);
                    boolean bl = false;
                    if (n == this.data.length - 1) {
                        bl = true;
                    }
                    return bl;
                }
            }
            break;
        }
        return false;
    }

    public boolean isDescriptor(byte by) {
        boolean bl = false;
        if (this.data.length > 0 && this.data[0] == by) {
            bl = true;
        }
        return bl;
    }

    public Utf8 getArrayElementDescriptor() {
        Assert._assert(this.isDescriptor((byte)91));
        return Utf8.get(this.data, 1, this.data.length);
    }

    public Utf8 getClassName() {
        Assert._assert(this.isDescriptor((byte)76));
        return Utf8.get(this.data, 1, this.data.length - 1);
    }

    public Utf8 getAsArrayDescriptor() {
        Assert._assert(this.isValidTypeDescriptor());
        byte[] byArray = new byte[this.data.length + 1];
        byArray[0] = 91;
        System.arraycopy(this.data, 0, byArray, 1, this.data.length);
        return Utf8.get(byArray);
    }

    public Utf8 getAsClassDescriptor() {
        boolean bl = false;
        if (this.data[0] != 91) {
            bl = true;
        }
        Assert._assert(bl);
        byte[] byArray = new byte[this.data.length + 2];
        byArray[0] = 76;
        System.arraycopy(this.data, 0, byArray, 1, this.data.length);
        byArray[this.data.length + 1] = 59;
        return Utf8.get(byArray);
    }

    public MethodDescriptorIterator getParamDescriptors() {
        return new MethodDescriptorIterator();
    }

    private static final boolean memcmp(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }

    private static final boolean memcmp(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray.length != n2 - n) {
            return false;
        }
        int n3 = byArray.length;
        while (--n3 >= 0) {
            if (byArray[n3] == byArray2[n3 + n]) continue;
            return false;
        }
        return true;
    }

    private static final int addToTable_helper(byte[] byArray, int n, int[] nArray, int n2) {
        if (NO_NEW) {
            Assert.UNREACHABLE("Trying to add Utf8 " + Utf8.fromUtf8(byArray));
        }
        if (++size == table.length) {
            Utf8.growTable_helper();
        }
        if (!Utf8.checkUtf8(byArray)) {
            Utf8.fromUtf8(byArray);
            Assert.UNREACHABLE();
        }
        Utf8.table[Utf8.size] = new Utf8(byArray, n);
        nArray[n2] = size + 1;
        if (TRACE) {
            System.out.println("allocated new Utf8: " + table[size]);
        }
        return size;
    }

    private static final void growTable_helper() {
        Utf8[] utf8Array = new Utf8[size << 1];
        System.arraycopy(table, 0, utf8Array, 0, size);
        table = utf8Array;
    }

    public static int hashCode(byte[] byArray) {
        int n = 4999;
        int n2 = byArray.length;
        while (--n2 >= 0) {
            n = 2999 * n + byArray[n2];
        }
        return n;
    }

    public static int hashCode(byte[] byArray, int n, int n2) {
        int n3 = 4999;
        int n4 = n2;
        while (--n4 >= n) {
            n3 = 2999 * n3 + byArray[n4];
        }
        return n3;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        if (this.cache != null) {
            return this.cache;
        }
        this.cache = Utf8.fromUtf8(this.data);
        return this.cache;
    }

    public void dump(DataOutput dataOutput) throws IOException {
        boolean bl = false;
        if (this.data.length <= (char)-1) {
            bl = true;
        }
        Assert._assert(bl);
        dataOutput.writeChar(this.data.length);
        dataOutput.write(this.data);
    }

    public void debugWrite() {
        Debug.write(this.data, this.data.length);
    }

    public static String fromUtf8(byte[] byArray) throws UTFDataFormatError {
        char[] cArray = new char[byArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        while (n2 < n3) {
            byte by;
            if ((by = byArray[n2++]) >= 0) {
                cArray[n++] = (char)by;
                continue;
            }
            try {
                char c;
                byte by2 = byArray[n2++];
                if (by < -32) {
                    int n4 = n++;
                    char c2 = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                    cArray[n4] = c2;
                    c = c2;
                    continue;
                }
                c = byArray[n2++];
                int n5 = n++;
                char c3 = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | c & 0x3F);
                cArray[n5] = c3;
                char c4 = c3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UTFDataFormatError("unexpected end at location " + n2);
            }
        }
        return new String(cArray, 0, n);
    }

    public static byte[] toUtf8(String string) {
        byte[] byArray = new byte[Utf8.lengthUtf8(string)];
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n++] = (byte)(0xE0 | (byte)(c >> 12));
                byArray[n++] = (byte)(0x80 | (c & 0xFC0) >> 6);
                byArray[n++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray[n++] = (byte)(0xC0 | (byte)(c >> 6));
                byArray[n++] = (byte)(0x80 | c & 0x3F);
            }
            ++n2;
        }
        return byArray;
    }

    public static int lengthUtf8(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            n = c >= '\u0001' && c <= '\u007f' ? ++n : (c > '\u07ff' ? (n += 3) : (n += 2));
            ++n2;
        }
        return n;
    }

    public static boolean checkUtf8(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            byte by;
            if ((by = byArray[n++]) >= 0) continue;
            try {
                char c;
                byte by2 = byArray[n++];
                if (by < -32) {
                    c = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                    continue;
                }
                c = byArray[n++];
                char c2 = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | c & 0x3F);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
        }
        return true;
    }

    private Utf8(byte[] byArray, int n) {
        this.data = byArray;
        this.hash = n;
        this.cache = Utf8.fromUtf8(byArray);
    }

    public class MethodDescriptorIterator
    extends UnmodifiableIterator {
        int currentIndex;

        public boolean hasNext() {
            boolean bl = false;
            if (Utf8.this.data[this.currentIndex + 1] != 41) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            return this.nextUtf8();
        }

        public Utf8 nextUtf8() {
            byte by = Utf8.this.data[++this.currentIndex];
            int n = this.currentIndex;
            while (by == 91) {
                by = Utf8.this.data[++this.currentIndex];
            }
            if (by == 76) {
                while (by != 59) {
                    by = Utf8.this.data[++this.currentIndex];
                }
            } else if (by != 66 && by != 67 && by != 68 && by != 70 && by != 73 && by != 74 && by != 83 && by != 90) {
                throw new ClassFormatError("bad method descriptor: " + Utf8.fromUtf8(Utf8.this.data) + " index: " + this.currentIndex);
            }
            return Utf8.get(Utf8.this.data, n, this.currentIndex + 1);
        }

        public Utf8 getReturnDescriptor() {
            Assert._assert(this.hasNext() ^ true);
            return Utf8.get(Utf8.this.data, this.currentIndex + 2, Utf8.this.data.length);
        }

        MethodDescriptorIterator() {
            Assert._assert(Utf8.this.isDescriptor((byte)40));
            this.currentIndex = 0;
        }
    }
}

