/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

import Util.Collections.MaxPriorityQueue;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class BinHeapPriorityQueue
extends AbstractCollection
implements MaxPriorityQueue {
    private static final int DEFAULT_SIZE = 16;
    private HashMap item2entry;
    private Entry[] heap;
    private int size;

    public boolean insert(Object object, int n) {
        if (this.item2entry.containsKey(object)) {
            boolean bl = false;
            if (this.setPriority(object, n) != n) {
                bl = true;
            }
            return bl;
        }
        this.ensureCapacity(this.size + 1);
        Entry entry = new Entry();
        entry.item = object;
        entry.priority = n;
        entry.heapIndex = this.size;
        this.heap[this.size] = entry;
        ++this.size;
        this.percolate(entry);
        return true;
    }

    public int getPriority(Object object) {
        Entry entry = (Entry)this.item2entry.get(object);
        if (entry == null) {
            throw new NoSuchElementException(object.toString());
        }
        return entry.priority;
    }

    public int setPriority(Object object, int n) {
        Entry entry = (Entry)this.item2entry.get(object);
        if (entry == null) {
            throw new NoSuchElementException(object.toString());
        }
        int n2 = entry.priority;
        entry.priority = n;
        this.priorityChanged(entry, n - n2);
        return n2;
    }

    public void changePriority(Object object, int n) {
        Entry entry = (Entry)this.item2entry.get(object);
        if (entry == null) {
            throw new NoSuchElementException(object.toString());
        }
        entry.priority += n;
        this.priorityChanged(entry, n);
    }

    public Object peekMax() {
        return this.heap[0].item;
    }

    public Object deleteMax() {
        if (this.size == 0) {
            throw new NoSuchElementException("Heap is empty");
        }
        Object object = this.heap[0].item;
        this.removeEntry(this.heap[0]);
        return object;
    }

    public boolean remove(Object object) {
        Entry entry = (Entry)this.item2entry.get(object);
        if (entry == null) {
            return false;
        }
        this.removeEntry(entry);
        return true;
    }

    public boolean contains(Object object) {
        return this.item2entry.containsKey(object);
    }

    public Iterator iterator() {
        return new HeapIterator();
    }

    public void clear() {
        this.item2entry.clear();
        Arrays.fill(this.heap, null);
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < this.size) {
            stringBuffer.append(" (").append(this.heap[n].item).append(", ").append(this.heap[n].priority).append(")");
            ++n;
        }
        return stringBuffer.append(" ]").toString();
    }

    private final void removeEntry(Entry entry) {
        Entry entry2 = this.heap[this.size - 1];
        this.swap(entry, entry2);
        this.heap[this.size - 1] = null;
        --this.size;
        this.priorityChanged(entry2, entry2.priority - entry.priority);
        this.item2entry.remove(entry.item);
    }

    private final void ensureCapacity(int n) {
        if (this.heap.length >= n) {
            return;
        }
        Entry[] entryArray = new Entry[Math.max(n, this.heap.length * 2)];
        System.arraycopy(this.heap, 0, entryArray, 0, this.heap.length);
        this.heap = entryArray;
    }

    private final void priorityChanged(Entry entry, int n) {
        if (n > 0) {
            this.percolate(entry);
        } else if (n < 0) {
            this.siftDown(entry);
        }
    }

    private final void percolate(Entry entry) {
        while (entry.heapIndex > 0) {
            Entry entry2 = this.heap[(entry.heapIndex - 1) / 2];
            if (entry.priority <= entry2.priority) break;
            this.swap(entry2, entry);
        }
    }

    private final void siftDown(Entry entry) {
        while (entry.heapIndex * 2 + 1 < this.size) {
            Entry entry2;
            Entry entry3 = this.heap[entry.heapIndex * 2 + 1];
            Entry entry4 = entry.heapIndex * 2 + 2 < this.size ? this.heap[entry.heapIndex * 2 + 2] : null;
            Entry entry5 = entry2 = entry4 == null || entry3.priority > entry4.priority ? entry3 : entry4;
            if (entry.priority >= entry2.priority) break;
            this.swap(entry, entry2);
        }
    }

    private final void swap(Entry entry, Entry entry2) {
        int n;
        int n2 = entry.heapIndex;
        entry.heapIndex = n = entry2.heapIndex;
        this.heap[n] = entry;
        entry2.heapIndex = n2;
        this.heap[n2] = entry2;
    }

    public BinHeapPriorityQueue() {
        this(16);
    }

    public BinHeapPriorityQueue(int n) {
        this.item2entry = new HashMap(n);
        this.heap = new Entry[n];
        n = 0;
    }

    class Entry {
        int priority;
        int heapIndex;
        Object item;

        Entry() {
        }
    }

    class HeapIterator
    implements Iterator {
        Iterator hashIterator;
        Entry current;

        public boolean hasNext() {
            return this.hashIterator.hasNext();
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this.hashIterator.next();
            this.current = (Entry)entry.getValue();
            return entry.getKey();
        }

        public void remove() {
            this.hashIterator.remove();
            BinHeapPriorityQueue.this.removeEntry(this.current);
        }

        HeapIterator() {
            this.hashIterator = BinHeapPriorityQueue.this.item2entry.entrySet().iterator();
        }
    }
}

