/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

import Util.Assert;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;

public class CollectionTestWrapper
implements Set,
SortedSet,
List {
    private final Collection c1;
    private final Collection c2;

    public int size() {
        int n = this.c1.size();
        int n2 = this.c2.size();
        boolean bl = false;
        if (n == n2) {
            bl = true;
        }
        Assert._assert(bl);
        return n;
    }

    public boolean isEmpty() {
        boolean bl = this.c1.isEmpty();
        boolean bl2 = this.c2.isEmpty();
        Assert._assert(bl ^ bl2 ^ true);
        return bl;
    }

    public boolean contains(Object object) {
        boolean bl = this.c1.contains(object);
        boolean bl2 = this.c2.contains(object);
        Assert._assert(bl ^ bl2 ^ true);
        return bl;
    }

    private final boolean isStable() {
        if (this.c1 instanceof SortedSet && this.c2 instanceof SortedSet) {
            return true;
        }
        return this.c1 instanceof List && this.c2 instanceof List;
    }

    public Iterator iterator() {
        Iterator iterator = this.c1.iterator();
        Iterator iterator2 = this.c2.iterator();
        return new TestIterator(this.c1, this.c2, iterator, iterator2, this.isStable());
    }

    public Object[] toArray() {
        Object[] objectArray = this.c1.toArray();
        Object[] objectArray2 = this.c2.toArray();
        boolean bl = false;
        if (objectArray.length == objectArray2.length) {
            bl = true;
        }
        Assert._assert(bl);
        if (this.c1 instanceof List || this.c1 instanceof SortedSet) {
            int n = 0;
            while (n < objectArray.length) {
                boolean bl2 = false;
                if (objectArray[n] == objectArray2[n]) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                ++n;
            }
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass(), objectArray.length);
        Object[] objectArray3 = this.c1.toArray(objectArray);
        Object[] objectArray4 = this.c2.toArray(objectArray2);
        boolean bl = false;
        if (objectArray3.length == objectArray4.length) {
            bl = true;
        }
        Assert._assert(bl);
        if (this.c1 instanceof List || this.c1 instanceof SortedSet) {
            int n = 0;
            while (n < objectArray3.length) {
                boolean bl2 = false;
                if (objectArray3[n] == objectArray4[n]) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                ++n;
            }
        }
        return objectArray3;
    }

    public boolean add(Object object) {
        boolean bl = this.c1.add(object);
        boolean bl2 = this.c2.add(object);
        Assert._assert(bl ^ bl2 ^ true);
        Assert._assert(this.c1.contains(object));
        Assert._assert(this.c2.contains(object));
        return bl;
    }

    public boolean remove(Object object) {
        boolean bl = this.c1.remove(object);
        boolean bl2 = this.c2.remove(object);
        Assert._assert(bl ^ bl2 ^ true);
        Assert._assert(this.c1.contains(object) ^ true);
        Assert._assert(this.c2.contains(object) ^ true);
        boolean bl3 = false;
        if (this.c1.size() == this.c2.size()) {
            bl3 = true;
        }
        Assert._assert(bl3);
        return bl;
    }

    public boolean containsAll(Collection collection) {
        boolean bl = this.c1.containsAll(collection);
        boolean bl2 = this.c2.containsAll(collection);
        Assert._assert(bl ^ bl2 ^ true);
        return bl;
    }

    public boolean addAll(Collection collection) {
        boolean bl = this.c1.addAll(collection);
        boolean bl2 = this.c2.addAll(collection);
        Assert._assert(bl ^ bl2 ^ true);
        Assert._assert(this.c1.containsAll(collection));
        Assert._assert(this.c2.containsAll(collection));
        boolean bl3 = false;
        if (this.c1.size() == this.c2.size()) {
            bl3 = true;
        }
        Assert._assert(bl3);
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = this.c1.retainAll(collection);
        boolean bl2 = this.c2.retainAll(collection);
        Assert._assert(bl ^ bl2 ^ true);
        Assert._assert(this.c1.containsAll(collection));
        Assert._assert(this.c2.containsAll(collection));
        boolean bl3 = false;
        if (this.c1.size() == this.c2.size()) {
            bl3 = true;
        }
        Assert._assert(bl3);
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = this.c1.removeAll(collection);
        boolean bl2 = this.c2.removeAll(collection);
        Assert._assert(bl ^ bl2 ^ true);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Assert._assert(this.c1.contains(e) ^ true);
            Assert._assert(this.c2.contains(e) ^ true);
        }
        boolean bl3 = false;
        if (this.c1.size() == this.c2.size()) {
            bl3 = true;
        }
        Assert._assert(bl3);
        return bl;
    }

    public void clear() {
        this.c1.clear();
        this.c2.clear();
        boolean bl = false;
        if (this.c1.size() == 0) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (this.c2.size() == 0) {
            bl2 = true;
        }
        Assert._assert(bl2);
    }

    public Comparator comparator() {
        Comparator comparator = ((SortedSet)this.c1).comparator();
        Comparator comparator2 = ((SortedSet)this.c2).comparator();
        boolean bl = false;
        if (comparator == comparator2) {
            bl = true;
        }
        Assert._assert(bl);
        return comparator;
    }

    public SortedSet subSet(Object object, Object object2) {
        SortedSet<Object> sortedSet = ((SortedSet)this.c1).subSet(object, object2);
        SortedSet<Object> sortedSet2 = ((SortedSet)this.c2).subSet(object, object2);
        Assert._assert(sortedSet.equals(sortedSet2));
        return sortedSet;
    }

    public SortedSet headSet(Object object) {
        SortedSet<Object> sortedSet = ((SortedSet)this.c1).headSet(object);
        SortedSet<Object> sortedSet2 = ((SortedSet)this.c2).headSet(object);
        Assert._assert(sortedSet.equals(sortedSet2));
        return sortedSet;
    }

    public SortedSet tailSet(Object object) {
        SortedSet<Object> sortedSet = ((SortedSet)this.c1).tailSet(object);
        SortedSet<Object> sortedSet2 = ((SortedSet)this.c2).tailSet(object);
        Assert._assert(sortedSet.equals(sortedSet2));
        return sortedSet;
    }

    public Object first() {
        Object e = ((SortedSet)this.c1).first();
        Object e2 = ((SortedSet)this.c2).first();
        boolean bl = false;
        if (e == e2) {
            bl = true;
        }
        Assert._assert(bl);
        return e;
    }

    public Object last() {
        Object e = ((SortedSet)this.c1).last();
        Object e2 = ((SortedSet)this.c2).last();
        boolean bl = false;
        if (e == e2) {
            bl = true;
        }
        Assert._assert(bl);
        return e;
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = ((List)this.c1).addAll(n, collection);
        boolean bl2 = ((List)this.c2).addAll(n, collection);
        Assert._assert(bl ^ bl2 ^ true);
        Assert._assert(this.c1.containsAll(collection));
        Assert._assert(this.c2.containsAll(collection));
        boolean bl3 = false;
        if (this.c1.size() == this.c2.size()) {
            bl3 = true;
        }
        Assert._assert(bl3);
        return bl;
    }

    public Object get(int n) {
        Object e = ((List)this.c1).get(n);
        Object e2 = ((List)this.c2).get(n);
        boolean bl = false;
        if (e == e2) {
            bl = true;
        }
        Assert._assert(bl);
        return e;
    }

    public Object set(int n, Object object) {
        Object object2 = ((List)this.c1).set(n, object);
        Object object3 = ((List)this.c2).set(n, object);
        boolean bl = false;
        if (object2 == object3) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (((List)this.c1).get(n) == object) {
            bl2 = true;
        }
        Assert._assert(bl2);
        boolean bl3 = false;
        if (((List)this.c2).get(n) == object) {
            bl3 = true;
        }
        Assert._assert(bl3);
        boolean bl4 = false;
        if (this.c1.size() == this.c2.size()) {
            bl4 = true;
        }
        Assert._assert(bl4);
        return object2;
    }

    public void add(int n, Object object) {
        ((List)this.c1).add(n, object);
        ((List)this.c2).add(n, object);
        boolean bl = false;
        if (((List)this.c1).get(n) == object) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (((List)this.c2).get(n) == object) {
            bl2 = true;
        }
        Assert._assert(bl2);
        boolean bl3 = false;
        if (this.c1.size() == this.c2.size()) {
            bl3 = true;
        }
        Assert._assert(bl3);
    }

    public Object remove(int n) {
        Object e = ((List)this.c1).remove(n);
        Object e2 = ((List)this.c2).remove(n);
        boolean bl = false;
        if (e == e2) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (this.c1.size() == this.c2.size()) {
            bl2 = true;
        }
        Assert._assert(bl2);
        return e;
    }

    public int indexOf(Object object) {
        int n = ((List)this.c1).indexOf(object);
        int n2 = ((List)this.c2).indexOf(object);
        boolean bl = false;
        if (n == n2) {
            bl = true;
        }
        Assert._assert(bl);
        return n;
    }

    public int lastIndexOf(Object object) {
        int n = ((List)this.c1).lastIndexOf(object);
        int n2 = ((List)this.c2).lastIndexOf(object);
        boolean bl = false;
        if (n == n2) {
            bl = true;
        }
        Assert._assert(bl);
        return n;
    }

    public ListIterator listIterator() {
        ListIterator listIterator = ((List)this.c1).listIterator();
        ListIterator listIterator2 = ((List)this.c2).listIterator();
        while (true) {
            if (!listIterator.hasNext()) break;
            Assert._assert(listIterator2.hasNext());
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            boolean bl = false;
            if (e == e2) {
                bl = true;
            }
            Assert._assert(bl);
        }
        Assert._assert(listIterator2.hasNext() ^ true);
        return ((List)this.c1).listIterator();
    }

    public ListIterator listIterator(int n) {
        ListIterator listIterator = ((List)this.c1).listIterator(n);
        ListIterator listIterator2 = ((List)this.c2).listIterator(n);
        while (true) {
            if (!listIterator.hasNext()) break;
            Assert._assert(listIterator2.hasNext());
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            boolean bl = false;
            if (e == e2) {
                bl = true;
            }
            Assert._assert(bl);
        }
        Assert._assert(listIterator2.hasNext() ^ true);
        return ((List)this.c1).listIterator(n);
    }

    public List subList(int n, int n2) {
        List list = ((List)this.c1).subList(n, n2);
        List list2 = ((List)this.c2).subList(n, n2);
        Assert._assert(list.equals(list2));
        return list;
    }

    public CollectionTestWrapper(Collection collection, Collection collection2) {
        this.c1 = collection;
        this.c2 = collection2;
    }

    public static class TestIterator
    implements Iterator {
        private final Collection c1;
        private final Collection c2;
        private final Iterator i1;
        private final Iterator i2;
        private Object lastRet;
        private final boolean stable;
        private boolean removed;

        public boolean hasNext() {
            boolean bl = this.i1.hasNext();
            if (this.stable || !this.removed) {
                boolean bl2 = this.i2.hasNext();
                Assert._assert(bl ^ bl2 ^ true);
            }
            return bl;
        }

        public Object next() {
            Object e = this.i1.next();
            if (this.stable || !this.removed) {
                Object e2 = this.i2.next();
                if (this.stable && e != e2) {
                    Assert.UNREACHABLE("c1=" + this.c1 + " c2=" + this.c2 + ' ' + e + " != " + e2);
                }
            }
            this.lastRet = e;
            return e;
        }

        public void remove() {
            this.i1.remove();
            if (this.stable) {
                this.i2.remove();
            } else {
                this.removed = true;
                boolean bl = this.c2.remove(this.lastRet);
                Assert._assert(bl);
            }
        }

        public TestIterator(Collection collection, Collection collection2, Iterator iterator, Iterator iterator2, boolean bl) {
            this.c1 = collection;
            this.c2 = collection2;
            this.i1 = iterator;
            this.i2 = iterator2;
            this.stable = bl;
            this.removed = false;
        }
    }
}

