/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

import Util.Assert;
import Util.Collections.CollectionFactory;
import Util.Collections.CollectionWrapper;
import Util.Collections.Factories;
import Util.Collections.ListFactory;
import Util.Collections.MapFactory;
import Util.Collections.SetFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Factories {
    public static final MapFactory hashMapFactory = new 1();
    public static final MapFactory treeMapFactory = new 2();
    public static final SetFactory hashSetFactory = new 3();
    public static final SetFactory linearSetFactory = new 4();
    public static final SetFactory treeSetFactory = new 5();
    public static final ListFactory linkedListFactory = new 6();
    public static ListFactory arrayListFactory = new 7();

    public static final MapFactory hashMapFactory() {
        return hashMapFactory;
    }

    public static final SetFactory hashSetFactory() {
        return hashSetFactory;
    }

    public static final ListFactory linkedListFactory() {
        return linkedListFactory;
    }

    public static final CollectionFactory synchronizedCollectionFactory(CollectionFactory collectionFactory) {
        return new SerialCollectionFactory(collectionFactory){
            final /* synthetic */ CollectionFactory val$cf;

            public final Collection makeCollection(Collection collection) {
                return Collections.synchronizedCollection(this.val$cf.makeCollection(collection));
            }
            {
                this.val$cf = collectionFactory;
            }
        };
    }

    public static final SetFactory synchronizedSetFactory(SetFactory setFactory) {
        return new SerialSetFactory(setFactory){
            final /* synthetic */ SetFactory val$sf;

            public final Set makeSet(Collection collection) {
                return Collections.synchronizedSet(this.val$sf.makeSet(collection));
            }
            {
                this.val$sf = setFactory;
            }
        };
    }

    public static final ListFactory synchronizedListFactory(ListFactory listFactory) {
        return new SerialListFactory(listFactory){
            final /* synthetic */ ListFactory val$lf;

            public final List makeList(Collection collection) {
                return Collections.synchronizedList(this.val$lf.makeList(collection));
            }
            {
                this.val$lf = listFactory;
            }
        };
    }

    public static final MapFactory synchronizedMapFactory(MapFactory mapFactory) {
        return new SerialMapFactory(mapFactory){
            final /* synthetic */ MapFactory val$mf;

            public final Map makeMap(Map map) {
                return Collections.synchronizedMap(this.val$mf.makeMap(map));
            }
            {
                this.val$mf = mapFactory;
            }
        };
    }

    public static final CollectionFactory noNullCollectionFactory(CollectionFactory collectionFactory) {
        return new SerialCollectionFactory(collectionFactory){
            final /* synthetic */ CollectionFactory val$cf;

            public final Collection makeCollection(Collection collection) {
                Assert._assert(Factories.access$0(collection));
                Collection collection2 = this.val$cf.makeCollection(collection);
                return new CollectionWrapper(this, collection2){
                    final /* synthetic */ 12 this$0;

                    public final boolean add(Object object) {
                        boolean bl = false;
                        if (object != null) {
                            bl = true;
                        }
                        Assert._assert(bl);
                        return super.add(object);
                    }

                    public final boolean addAll(Collection collection) {
                        Assert._assert(Factories.access$0(collection));
                        return super.addAll(collection);
                    }
                    {
                        super(collection);
                        this.this$0 = var1_1;
                    }
                };
            }
            {
                this.val$cf = collectionFactory;
            }
        };
    }

    private static final boolean noNull(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ boolean access$0(Collection collection) {
        return Factories.noNull(collection);
    }

    private Factories() {
    }

    private static abstract class SerialMapFactory
    extends MapFactory
    implements Serializable {
        private SerialMapFactory() {
        }
    }

    private static abstract class SerialSetFactory
    extends SetFactory
    implements Serializable {
        private SerialSetFactory() {
        }
    }

    private static abstract class SerialListFactory
    extends ListFactory
    implements Serializable {
        private SerialListFactory() {
        }
    }

    private static abstract class SerialCollectionFactory
    extends CollectionFactory
    implements Serializable {
        private SerialCollectionFactory() {
        }
    }
}

