/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

public class FibonacciHeap {
    protected List rootlist = new List();
    protected Node min = null;
    protected int size = 0;

    public boolean empty() {
        return this.rootlist.empty;
    }

    public void meld(FibonacciHeap fibonacciHeap) {
        if (fibonacciHeap == null) {
            return;
        }
        FibonacciHeap fibonacciHeap2 = fibonacciHeap;
        this.rootlist.merge(fibonacciHeap2.rootlist);
        this.size += fibonacciHeap2.size;
        if (this.min == null) {
            this.min = fibonacciHeap2.min;
        } else if (fibonacciHeap2.min != null && fibonacciHeap2.min.key < this.min.key) {
            this.min = fibonacciHeap2.min;
        }
    }

    public Node insert(int n, Object object) {
        Node node = new Node(n, object);
        FibonacciHeap fibonacciHeap = new FibonacciHeap();
        fibonacciHeap.rootlist.insert(node);
        fibonacciHeap.min = node;
        fibonacciHeap.size = 1;
        this.meld(fibonacciHeap);
        return node;
    }

    private final Node link(Node node, Node node2) {
        if (node.key > node2.key) {
            return this.link(node2, node);
        }
        node.childlist.insert(node2);
        node2.parent = node;
        ++node.degree;
        return node;
    }

    private final void tableInsert(Node[] nodeArray, Node node) {
        if (nodeArray[node.degree] == null) {
            nodeArray[node.degree] = node;
            return;
        }
        Node node2 = nodeArray[node.degree];
        nodeArray[node.degree] = null;
        node = this.link(node, node2);
        this.tableInsert(nodeArray, node);
    }

    private final int log(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n2 < n) {
            n2 = 2 * n2;
            ++n3;
        }
        return n3;
    }

    private final void consolidate() {
        int n = 2 * this.log(this.size);
        Node[] nodeArray = new Node[n];
        int n2 = 0;
        while (n2 < n) {
            nodeArray[n2] = null;
            ++n2;
        }
        while (!this.rootlist.empty) {
            Node node = this.rootlist.head;
            this.rootlist.remove(node);
            this.tableInsert(nodeArray, node);
        }
        this.min = null;
        int n3 = 0;
        while (n3 < n) {
            if (nodeArray[n3] != null) {
                nodeArray[n3].mark = false;
                nodeArray[n3].parent = null;
                this.rootlist.insert(nodeArray[n3]);
                if (this.min == null || nodeArray[n3].key < this.min.key) {
                    this.min = nodeArray[n3];
                }
            }
            ++n3;
        }
    }

    public Node deleteMin() {
        if (this.min == null) {
            return new Node(Integer.MIN_VALUE);
        }
        this.rootlist.merge(this.min.childlist);
        this.rootlist.remove(this.min);
        Node node = this.min;
        if (this.rootlist.empty) {
            this.min = null;
        } else {
            this.consolidate();
        }
        --this.size;
        return node;
    }

    private final void cut2(Node node) {
        node.parent.childlist.remove(node);
        --node.parent.degree;
        this.rootlist.insert(node);
        node.parent = null;
        node.mark = false;
    }

    private final void cascadingCut(Node node) {
        if (node.parent != null) {
            if (node.mark) {
                Node node2 = node.parent;
                this.cut2(node);
                this.cascadingCut(node2);
            } else {
                node.mark = true;
            }
        }
    }

    public void decreaseKey2(int n, Node node) {
        Node node2 = node;
        if (n >= node2.key) {
            return;
        }
        node2.key = n;
        if (node2.parent != null && node2.parent.key > node2.key) {
            Node node3 = node2.parent;
            this.cut2(node2);
            this.cascadingCut(node3);
        }
        if (node2.key < this.min.key) {
            this.min = node2;
        }
    }

    private final void cut(Node node) {
        Node node2 = node.parent;
        if (node2 != null) {
            node.parent.childlist.remove(node);
            --node.parent.degree;
            node.parent = null;
            node.mark = false;
            this.rootlist.insert(node);
        }
    }

    public void decreaseKey(int n, Node node) {
        Node node2 = node;
        if (n > node2.key) {
            return;
        }
        node2.key = n;
        if (node2.key < this.min.key) {
            this.min = node2;
        }
        if (node2.parent == null || node2.parent.key < node2.key) {
            return;
        }
        node2.mark = true;
        while (node2.parent != null && node2.mark) {
            Node node3 = node2.parent;
            this.cut(node2);
            node2 = node3;
        }
        if (node2.parent != null) {
            node2.mark = true;
        }
    }

    public void delete(Node node) {
        this.decreaseKey(Integer.MIN_VALUE, node);
        this.deleteMin();
    }

    public Node min() {
        return this.min;
    }

    public void print() {
        this.rootlist.printTree();
    }

    static class Node {
        int key;
        Object entry;
        Node next;
        Node previous;
        boolean mark;
        int degree;
        Node parent;
        List childlist;

        public void print() {
            System.out.print(this.key);
            if (this.mark) {
                System.out.print("*");
            }
            System.out.print(" ");
            if (this.childlist.head != null) {
                this.childlist.print();
            }
        }

        Node(int n, Object object) {
            this.key = n;
            this.entry = object;
            this.childlist = new List();
            this.parent = null;
            this.mark = false;
            this.degree = 0;
        }

        Node(int n) {
            this.key = n;
            this.entry = null;
            this.childlist = new List();
            this.parent = null;
            this.mark = false;
            this.degree = 0;
        }

        Node(Node node) {
            this.key = node.key;
            this.entry = node.entry;
            this.childlist = new List();
            this.parent = null;
            this.mark = false;
            this.degree = 0;
        }
    }

    static class List {
        Node head = null;
        boolean empty = true;

        void insert(Node node) {
            if (this.empty) {
                node.next = node;
                node.previous = node;
                this.head = node;
                this.empty = false;
            } else {
                node.next = this.head;
                node.previous = this.head.previous;
                this.head.previous.next = node;
                this.head.previous = node;
                this.head = node;
            }
        }

        void remove(Node node) {
            if (node != null) {
                node.previous.next = node.next;
                node.next.previous = node.previous;
                if (node == this.head) {
                    this.head = this.head.next;
                }
                if (node == this.head) {
                    this.head = null;
                    this.empty = true;
                }
            }
        }

        void merge(List list) {
            if (list == null || list.head == null) {
                return;
            }
            if (this.head == null) {
                this.head = list.head;
                this.empty = false;
                return;
            }
            Node node = this.head.previous;
            list.head.previous.next = this.head;
            this.head.previous = list.head.previous;
            node.next = list.head;
            list.head.previous = node;
        }

        void printTree() {
            if (!this.empty) {
                Node node = this.head;
                node.print();
                node = node.next;
                int n = 2;
                while (node != this.head) {
                    System.out.print("   ");
                    node.print();
                    node = node.next;
                    ++n;
                }
                System.out.println();
            } else {
                System.out.println("Tree is empty.");
            }
        }

        void print() {
            if (!this.empty) {
                Node node = this.head;
                node.print();
                node = node.next;
                while (node != this.head) {
                    node.print();
                    node = node.next;
                }
            } else {
                System.out.println("List is empty.");
            }
        }

        List() {
        }
    }
}

