/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

import Util.Collections.CollectionFactory;
import Util.Collections.Factories;
import Util.Collections.MapFactory;
import Util.Collections.MultiMap;
import Util.Collections.MultiMapSet;
import Util.Collections.PairMapEntry;
import Util.Collections.UnmodifiableMultiMap;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GenericMultiMap
implements MultiMap {
    private Map internMap;
    private CollectionFactory cf;
    private MapFactory mf;
    private Set keySet;
    private Collection valuesCollection;
    private MultiMapSet entrySet;

    public int size() {
        return GenericMultiMap.size0(this.internMap);
    }

    private static final int size0(Map map) {
        int n = 0;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            n += ((Collection)iterator.next()).size();
        }
        return n;
    }

    public boolean isEmpty() {
        Iterator iterator = this.internMap.values().iterator();
        while (iterator.hasNext()) {
            if (((Collection)iterator.next()).size() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(Object object) {
        Collection collection = (Collection)this.internMap.get(object);
        boolean bl = false;
        if (collection != null && collection.size() != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.internMap.keySet().iterator();
        while (iterator.hasNext()) {
            if (!this.getValues(iterator.next()).contains(object)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object object) {
        Collection collection = (Collection)this.internMap.get(object);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.iterator().next();
    }

    public Object put(Object object, Object object2) {
        Collection collection = this.getValues(object);
        Object var4_4 = collection.size() == 0 ? null : collection.iterator().next();
        collection.clear();
        collection.add(object2);
        return var4_4;
    }

    public Object remove(Object object) {
        Collection collection = (Collection)this.internMap.get(object);
        this.internMap.remove(object);
        return collection == null || collection.size() == 0 ? null : collection.iterator().next();
    }

    public boolean remove(Object object, Object object2) {
        return GenericMultiMap.remove0(object, object2, this.internMap);
    }

    private static final boolean remove0(Object object, Object object2, Map map) {
        boolean bl;
        Collection collection = (Collection)map.get(object);
        boolean bl2 = false;
        if (collection != null) {
            bl2 = bl = collection.remove(object2);
        }
        if (collection != null && collection.size() == 0) {
            map.remove(object);
        }
        return bl;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.internMap.clear();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            Set set = ((Map)object).entrySet();
            return this.entrySet().equals(set);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        Iterator iterator = this.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public boolean add(Object object, Object object2) {
        return GenericMultiMap.add0(object, object2, this.internMap, this.cf);
    }

    public static boolean add0(Object object, Object object2, Map map, CollectionFactory collectionFactory) {
        boolean bl = GenericMultiMap.getValues0(object, map, collectionFactory).add(object2);
        return bl;
    }

    public boolean addAll(Object object, Collection collection) {
        return this.getValues(object).addAll(collection);
    }

    public boolean addAll(MultiMap multiMap) {
        boolean bl = false;
        Iterator iterator = multiMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!this.addAll(k, multiMap.getValues(k))) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Object object, Collection collection) {
        return this.getValues(object).retainAll(collection);
    }

    public boolean removeAll(Object object, Collection collection) {
        return this.getValues(object).removeAll(collection);
    }

    public Collection getValues(Object object) {
        return GenericMultiMap.getValues0(object, this.internMap, this.cf);
    }

    private static final Collection getValues0(Object object, Map map, CollectionFactory collectionFactory) {
        Collection collection = (Collection)map.get(object);
        if (collection == null) {
            collection = collectionFactory.makeCollection();
            map.put(object, collection);
        }
        return collection;
    }

    public boolean contains(Object object, Object object2) {
        return GenericMultiMap.contains0(object, object2, this.internMap);
    }

    private static final boolean contains0(Object object, Object object2, Map map) {
        Collection collection = (Collection)map.get(object);
        if (collection != null) {
            return collection.contains(object2);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Collection collection = this.getValues(e);
            if (collection.size() == 0) continue;
            stringBuffer.append("< " + e + " -> " + collection + " > ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String computeHistogram(String string, String string2) {
        return UnmodifiableMultiMap.computeHistogram(this, 100, string, string2);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new ValuesCollection();
        }
        return this.valuesCollection;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new GenericMultiMapEntrySet(this.internMap);
        }
        return this.entrySet;
    }

    public GenericMultiMap() {
        this(Factories.hashMapFactory(), Factories.hashSetFactory());
    }

    public GenericMultiMap(CollectionFactory collectionFactory) {
        this(Factories.hashMapFactory(), collectionFactory);
    }

    public GenericMultiMap(MapFactory mapFactory, CollectionFactory collectionFactory) {
        this.internMap = mapFactory.makeMap();
        this.cf = collectionFactory;
        this.mf = mapFactory;
    }

    GenericMultiMap(GenericMultiMap genericMultiMap) {
        this.mf = genericMultiMap.mf;
        this.cf = genericMultiMap.cf;
        this.internMap = this.mf.makeMap(genericMultiMap.internMap);
    }

    GenericMultiMap(Map map) {
        this();
        this.putAll(map);
    }

    class KeySet
    extends AbstractSet {
        public int size() {
            return GenericMultiMap.this.internMap.keySet().size();
        }

        public Iterator iterator() {
            return new Iterator(this){
                Iterator it;
                Object lastKey;
                final /* synthetic */ KeySet this$0;

                public final boolean hasNext() {
                    return this.it.hasNext();
                }

                public final Object next() {
                    this.lastKey = this.it.next();
                    return this.lastKey;
                }

                public final void remove() {
                    GenericMultiMap.access$0(this.this$0.GenericMultiMap.this).get(this.lastKey);
                    this.it.remove();
                }

                private final /* synthetic */ void this() {
                    this.it = GenericMultiMap.access$0(this.this$0.GenericMultiMap.this).keySet().iterator();
                }
                {
                    this.this$0 = keySet;
                    this.this();
                }
            };
        }

        public boolean remove(Object object) {
            boolean bl = this.contains(object);
            GenericMultiMap.this.remove(object);
            return bl;
        }

        public boolean contains(Object object) {
            return GenericMultiMap.this.internMap.containsKey(object);
        }

        public void clear() {
            GenericMultiMap.this.clear();
        }

        KeySet() {
        }
    }

    class ValuesCollection
    extends AbstractCollection {
        public int size() {
            return GenericMultiMap.this.size();
        }

        public Iterator iterator() {
            return new Iterator(this){
                final Iterator it;
                final /* synthetic */ ValuesCollection this$0;

                public final boolean hasNext() {
                    return this.it.hasNext();
                }

                public final Object next() {
                    return ((Map.Entry)this.it.next()).getValue();
                }

                public final void remove() {
                    this.it.remove();
                }

                private final /* synthetic */ void this() {
                    this.it = this.this$0.GenericMultiMap.this.entrySet().iterator();
                }
                {
                    this.this$0 = valuesCollection;
                    this.this();
                }
            };
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            return GenericMultiMap.this.containsValue(object);
        }

        public void clear() {
            GenericMultiMap.this.clear();
        }

        ValuesCollection() {
        }
    }

    public static class GenericMultiMapEntrySet
    extends AbstractCollection
    implements MultiMapSet {
        final Map internMap;
        final CollectionFactory cf;

        public Map asMap() {
            return this.asMultiMap();
        }

        public MultiMap asMultiMap() {
            return new GenericMultiMap(this.internMap);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Set && ((Set)object).size() == this.size()) {
                return this.containsAll((Collection)object);
            }
            return false;
        }

        public int hashCode() {
            Iterator iterator = this.iterator();
            int n = this.size();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Object e = iterator.next();
                if (e != null) {
                    n2 += e.hashCode();
                }
                ++n3;
            }
            return n2;
        }

        public int size() {
            return GenericMultiMap.size0(this.internMap);
        }

        public Iterator iterator() {
            return new GenericMultiMapIterator(this.internMap);
        }

        public boolean add(Map.Entry entry) {
            return GenericMultiMap.add0(entry.getKey(), entry.getValue(), this.internMap, this.cf);
        }

        public boolean add(Object object) {
            return this.add((Map.Entry)object);
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return GenericMultiMap.remove0(entry.getKey(), entry.getValue(), this.internMap);
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return GenericMultiMap.contains0(entry.getKey(), entry.getValue(), this.internMap);
        }

        public void clear() {
            this.internMap.clear();
        }

        public GenericMultiMapEntrySet(Map map, CollectionFactory collectionFactory) {
            this.internMap = map;
            this.cf = collectionFactory;
        }

        public GenericMultiMapEntrySet(Map map) {
            this(map, null);
        }
    }

    public static class GenericMultiMapIterator
    implements Iterator {
        final MultiMap backing_map;
        final Iterator mapit;
        Iterator setit;
        Iterator lastit;
        Object key;

        public boolean hasNext() {
            return this.setit.hasNext();
        }

        public Object next() {
            Object e = this.setit.next();
            Object object = this.key;
            this.advance();
            return new PairMapEntry(this, object, e){
                final /* synthetic */ GenericMultiMapIterator this$0;

                public final Object setValue(Object object) {
                    if (this.this$0.backing_map == null) {
                        throw new UnsupportedOperationException();
                    }
                    Object object2 = this.getValue();
                    this.this$0.backing_map.remove(this.getKey(), object2);
                    this.this$0.backing_map.add(this.getKey(), object);
                    super.setValue(object);
                    return object2;
                }
                {
                    this.this$0 = genericMultiMapIterator;
                }
            };
        }

        void advance() {
            this.lastit = this.setit;
            while (!this.setit.hasNext() && this.mapit.hasNext()) {
                Map.Entry entry = (Map.Entry)this.mapit.next();
                this.key = entry.getKey();
                Collection collection = (Collection)entry.getValue();
                this.setit = collection.iterator();
            }
        }

        public void remove() {
            this.lastit.remove();
        }

        public GenericMultiMapIterator(Map map, MultiMap multiMap) {
            this.mapit = map.entrySet().iterator();
            this.setit = Collections.EMPTY_SET.iterator();
            this.backing_map = multiMap;
            this.advance();
        }

        public GenericMultiMapIterator(Map map) {
            this(map, null);
        }
    }
}

