/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

import Util.Assert;
import Util.Collections.Factories;
import Util.Collections.ListFactory;
import Util.Collections.SetFactory;
import Util.Collections.Worklist;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;

public class HashWorklist
extends AbstractList
implements Worklist,
Set {
    private final Set set;
    private final List list;
    private final boolean once;

    public void push(Object object) {
        this.add(object);
    }

    public Object pull() {
        Object e = this.list.remove(0);
        if (!this.once) {
            this.set.remove(e);
        }
        return e;
    }

    public Object get(int n) {
        return this.list.get(n);
    }

    public int size() {
        return this.list.size();
    }

    public boolean add(Object object) {
        if (this.set.add(object)) {
            return this.list.add(object);
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    public Set getVisitedSet() {
        Assert._assert(this.once);
        return this.set;
    }

    public HashWorklist(boolean bl, SetFactory setFactory, ListFactory listFactory) {
        this.set = setFactory.makeSet();
        this.list = listFactory.makeList();
        this.once = bl;
    }

    public HashWorklist(boolean bl, ListFactory listFactory) {
        this(bl, Factories.hashSetFactory(), listFactory);
    }

    public HashWorklist(boolean bl, SetFactory setFactory) {
        this(bl, setFactory, Factories.linkedListFactory());
    }

    public HashWorklist(boolean bl) {
        this(bl, Factories.hashSetFactory());
    }

    public HashWorklist() {
        this(false);
    }
}

