/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

import Util.Assert;
import Util.Collections.IndexedMap;
import Util.IO.Textualizable;
import Util.IO.Textualizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class IndexMap
implements IndexedMap {
    private final String name;
    private final HashMap hash;
    private final ArrayList list;
    private final boolean trace;

    public int get(Object object) {
        Integer n = (Integer)this.hash.get(object);
        if (n == null) {
            n = new Integer(this.list.size());
            this.hash.put(object, n);
            this.list.add(object);
            if (this.trace) {
                System.out.println(this + '[' + n + "] = " + object);
            }
        }
        return n;
    }

    public Object get(int n) {
        return this.list.get(n);
    }

    public boolean contains(Object object) {
        return this.hash.containsKey(object);
    }

    public int size() {
        return this.list.size();
    }

    public String toString() {
        return this.name;
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public boolean addAll(Collection collection) {
        int n = this.size();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.get(iterator.next());
        }
        boolean bl = false;
        if (n != this.size()) {
            bl = true;
        }
        return bl;
    }

    public void dump(DataOutput dataOutput) throws IOException {
        Textualizer.Map map = new Textualizer.Map(dataOutput, (IndexedMap)this);
        map.writeBytes("" + this.size() + '\n');
        int n = 0;
        while (n < this.size()) {
            Textualizable textualizable = (Textualizable)this.get(n);
            map.writeTypeOf(textualizable);
            map.writeObject(textualizable);
            map.writeBytes("\n");
            ++n;
        }
    }

    public static IndexMap load(String string, DataInput dataInput) throws IOException {
        String string2 = dataInput.readLine();
        int n = Integer.parseInt(string2);
        IndexMap indexMap = new IndexMap(string, n);
        Textualizer.Map map = new Textualizer.Map(dataInput, (IndexedMap)indexMap);
        int n2 = 0;
        while (n2 < n) {
            map.nextLine();
            Textualizable textualizable = map.readObject();
            int n3 = indexMap.get(textualizable);
            boolean bl = false;
            if (n2 == n3) {
                bl = true;
            }
            Assert._assert(bl);
            ++n2;
        }
        return indexMap;
    }

    public IndexMap(String string) {
        this.name = string;
        this.hash = new HashMap();
        this.list = new ArrayList();
        this.trace = false;
    }

    public IndexMap(String string, int n) {
        this.name = string;
        this.hash = new HashMap(n);
        this.list = new ArrayList(n);
        this.trace = false;
    }

    public IndexMap(String string, int n, boolean bl) {
        this.name = string;
        this.hash = new HashMap(n);
        this.list = new ArrayList(n);
        this.trace = bl;
    }
}

