/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

import Util.Assert;
import Util.Strings;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InstrumentedSetWrapper
implements Set {
    private final Set wrappedSet;
    private final InstrumentationResults results;

    public Set getWrappedSet() {
        return this.wrappedSet;
    }

    public String toString() {
        this.results._toString(this.wrappedSet);
        return this.wrappedSet.toString();
    }

    public int hashCode() {
        this.results._hashCode(this.wrappedSet);
        return this.wrappedSet.hashCode();
    }

    public boolean equals(Object object) {
        this.results._equals(this.wrappedSet, object);
        return this.wrappedSet.equals(object);
    }

    public int size() {
        this.results._size(this.wrappedSet);
        return this.wrappedSet.size();
    }

    public boolean isEmpty() {
        this.results._isEmpty(this.wrappedSet);
        return this.wrappedSet.isEmpty();
    }

    public boolean contains(Object object) {
        this.results._contains(this.wrappedSet, object);
        return this.wrappedSet.contains(object);
    }

    public Iterator iterator() {
        this.results._iterator(this.wrappedSet);
        return this.wrappedSet.iterator();
    }

    public Object[] toArray() {
        this.results._toArray(this.wrappedSet);
        return this.wrappedSet.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        this.results._toArray(this.wrappedSet, objectArray);
        return this.wrappedSet.toArray(objectArray);
    }

    public boolean add(Object object) {
        this.results._add(this.wrappedSet, object);
        return this.wrappedSet.add(object);
    }

    public boolean remove(Object object) {
        this.results._remove(this.wrappedSet, object);
        return this.wrappedSet.remove(object);
    }

    public boolean containsAll(Collection collection) {
        this.results._containsAll(this.wrappedSet, collection);
        return this.wrappedSet.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        this.results._addAll(this.wrappedSet, collection);
        return this.wrappedSet.addAll(collection);
    }

    public boolean retainAll(Collection collection) {
        this.results._retainAll(this.wrappedSet, collection);
        return this.wrappedSet.retainAll(collection);
    }

    public boolean removeAll(Collection collection) {
        this.results._removeAll(this.wrappedSet, collection);
        return this.wrappedSet.removeAll(collection);
    }

    public void clear() {
        this.results._clear();
        this.wrappedSet.clear();
    }

    public InstrumentedSetWrapper(Set set) {
        this.wrappedSet = set;
        List<Object> list = Arrays.asList(new Throwable().getStackTrace()).subList(1, 4);
        this.results = new InstrumentationResults(list);
        GlobalStats.register(this);
    }

    private static abstract class GlobalStats {
        private static final Map m = new HashMap();
        private static final ReferenceQueue q = new ReferenceQueue();
        private static final Map results = new HashMap();
        private static volatile Thread cleanupThread;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void register(InstrumentedSetWrapper instrumentedSetWrapper) {
            Map map = m;
            synchronized (map) {
                InstrumentationResults instrumentationResults = m.put(new WeakReference<InstrumentedSetWrapper>(instrumentedSetWrapper, q), instrumentedSetWrapper.results);
                boolean bl = false;
                if (instrumentationResults == null) {
                    bl = true;
                }
                Assert._assert(bl);
                return;
            }
        }

        private static final void finish(InstrumentationResults instrumentationResults) {
            InstrumentationResults instrumentationResults2 = (InstrumentationResults)results.get(instrumentationResults.identifier);
            if (instrumentationResults2 == null) {
                instrumentationResults2 = instrumentationResults;
                results.put(instrumentationResults.identifier, instrumentationResults2);
            } else {
                instrumentationResults2.mergeResults(instrumentationResults);
            }
        }

        static /* synthetic */ Thread access$0() {
            return cleanupThread;
        }

        static /* synthetic */ ReferenceQueue access$1() {
            return q;
        }

        static /* synthetic */ Map access$2() {
            return m;
        }

        static /* synthetic */ void access$3(InstrumentationResults instrumentationResults) {
            GlobalStats.finish(instrumentationResults);
        }

        static /* synthetic */ void access$4(Thread thread) {
            cleanupThread = thread;
        }

        static /* synthetic */ Map access$5() {
            return results;
        }

        private GlobalStats() {
        }

        static {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void run() {
                    Thread thread = Thread.currentThread();
                    while (thread == GlobalStats.access$0()) {
                        try {
                            WeakReference weakReference = (WeakReference)GlobalStats.access$1().remove();
                            Map map = GlobalStats.access$2();
                            synchronized (map) {
                                InstrumentationResults instrumentationResults = (InstrumentationResults)GlobalStats.access$2().get(weakReference);
                                if (instrumentationResults != null) {
                                    GlobalStats.access$2().remove(weakReference);
                                    GlobalStats.access$3(instrumentationResults);
                                }
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                                weakReference = null;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            cleanupThread = new Thread(runnable);
            cleanupThread.setDaemon(true);
            cleanupThread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void run() {
                    Object object3;
                    Object object2;
                    Thread thread = GlobalStats.access$0();
                    GlobalStats.access$4(null);
                    thread.interrupt();
                    Map map = GlobalStats.access$2();
                    synchronized (map) {
                        object2 = GlobalStats.access$2().values().iterator();
                        while (object2.hasNext()) {
                            object3 = (InstrumentationResults)object2.next();
                            object2.remove();
                            GlobalStats.access$3((InstrumentationResults)object3);
                        }
                    }
                    object2 = null;
                    try {
                        try {
                            object2 = new FileWriter("set_profile_data");
                            Iterator<V> iterator = GlobalStats.access$5().values().iterator();
                            while (iterator.hasNext()) {
                                InstrumentationResults instrumentationResults = (InstrumentationResults)iterator.next();
                                ((Writer)object2).write(instrumentationResults.dump());
                                ((Writer)object2).write(Strings.lineSep);
                            }
                        }
                        catch (IOException iOException) {}
                        Object var3_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_9 = null;
                        try {
                            if (object2 == null) throw throwable;
                            ((OutputStreamWriter)object2).close();
                            throw throwable;
                        }
                        catch (IOException object3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException object3) {
                        return;
                    }
                    if (object2 == null) return;
                    ((OutputStreamWriter)object2).close();
                }
            });
        }
    }

    public static class InstrumentationResults {
        public final Object identifier;
        private int clear_count;
        private int removeAll_count;
        private int retainAll_count;
        private int addAll_count;
        private int containsAll_count;
        private int remove_count;
        private int add_count;
        private int toArray2_count;
        private int toArray_count;
        private int iterator_count;
        private int contains_count;
        private int isEmpty_count;
        private int size_count;
        private int equals_count;
        private int hashCode_count;
        private int toString_count;

        public void mergeResults(InstrumentationResults instrumentationResults) {
            Field[] fieldArray = this.getClass().getDeclaredFields();
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                if (field.getType() == Integer.TYPE) {
                    try {
                        field.setInt(this, field.getInt(this) + field.getInt(instrumentationResults));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }

        public boolean equals(Object object) {
            return this.equals((InstrumentationResults)object);
        }

        public boolean equals(InstrumentationResults instrumentationResults) {
            if (this.identifier == instrumentationResults.identifier) {
                return true;
            }
            if (this.identifier == null) {
                return false;
            }
            return this.identifier.equals(instrumentationResults.identifier);
        }

        public int hashCode() {
            int n = 0;
            if (this.identifier != null) {
                n = this.identifier.hashCode();
            }
            return n;
        }

        public String dump() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Results");
            if (this.identifier != null) {
                stringBuffer.append(" for ");
                stringBuffer.append(this.identifier.toString());
            }
            stringBuffer.append(':');
            stringBuffer.append(Strings.lineSep);
            Field[] fieldArray = this.getClass().getDeclaredFields();
            int n = 0;
            while (n < fieldArray.length) {
                Field field = fieldArray[n];
                if (field.getType() == Integer.TYPE) {
                    try {
                        int n2 = field.getInt(this);
                        if (n2 > 0) {
                            stringBuffer.append(field.getName());
                            stringBuffer.append('=');
                            stringBuffer.append(n2);
                            stringBuffer.append(Strings.lineSep);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        public void _clear() {
            ++this.clear_count;
        }

        public void _removeAll(Set set, Collection collection) {
            ++this.removeAll_count;
        }

        public void _retainAll(Set set, Collection collection) {
            ++this.retainAll_count;
        }

        public void _addAll(Set set, Collection collection) {
            ++this.addAll_count;
        }

        public void _containsAll(Set set, Collection collection) {
            ++this.containsAll_count;
        }

        public void _remove(Set set, Object object) {
            ++this.remove_count;
        }

        public void _add(Set set, Object object) {
            ++this.add_count;
        }

        public void _toArray(Set set) {
            ++this.toArray_count;
        }

        public void _toArray(Set set, Object[] objectArray) {
            ++this.toArray2_count;
        }

        public void _iterator(Set set) {
            ++this.iterator_count;
        }

        public void _contains(Set set, Object object) {
            ++this.contains_count;
        }

        public void _isEmpty(Set set) {
            ++this.isEmpty_count;
        }

        public void _size(Set set) {
            ++this.size_count;
        }

        public void _equals(Set set, Object object) {
            ++this.equals_count;
        }

        public void _hashCode(Set set) {
            ++this.hashCode_count;
        }

        public void _toString(Set set) {
            ++this.toString_count;
        }

        public InstrumentationResults(Object object) {
            this.identifier = object;
        }
    }
}

