/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

import Util.Collections.SetFactory;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;

public class SortedArraySet
extends AbstractList
implements SortedSet,
List,
Cloneable,
Serializable,
RandomAccess {
    public static final boolean DISALLOW_DIRECT_MODIFICATIONS = false;
    public static final boolean REDUCE_ALLOCATIONS = false;
    public static final SortedArraySetFactory FACTORY = new SortedArraySetFactory();
    private transient Object[] elementData;
    private int size;
    private final Comparator comparator;

    public Object get(int n) {
        this.checkAgainstSize(n);
        return this.elementData[n];
    }

    private final void checkAgainstSize(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(n + " >= " + this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public SortedSet subSet(Object object, Object object2) {
        return new SubSet(object, object2);
    }

    public SortedSet headSet(Object object) {
        return new SubSet(object, true);
    }

    public SortedSet tailSet(Object object) {
        return new SubSet(object, false);
    }

    public Object first() {
        int n = this.size;
        if (n == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[n];
    }

    public Object last() {
        try {
            return this.elementData[this.size - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    private final int compare(Object object, Object object2) {
        return this.comparator == null ? ((Comparable)object).compareTo(object2) : this.comparator.compare(object, object2);
    }

    private final int whereDoesItGo(Object object) {
        int n = 0;
        int n2 = this.size - 1;
        if (n2 < 0) {
            return 0;
        }
        int n3 = n2 >> 1;
        while (true) {
            Object object2;
            int n4;
            if ((n4 = this.compare(object, object2 = this.elementData[n3])) < 0) {
                n2 = n3 - 1;
                if (n > n2) {
                    return n3;
                }
            } else if (n4 > 0) {
                n = n3 + 1;
                if (n > n2) {
                    return n;
                }
            } else {
                return n3;
            }
            n3 = (n2 - n >> 1) + n;
        }
    }

    public boolean add(Object object) {
        int n;
        int n2 = this.whereDoesItGo(object);
        if (n2 != (n = this.size) && this.elementData[n2].equals(object)) {
            return false;
        }
        this.ensureCapacity(n + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, n - n2);
        this.elementData[n2] = object;
        ++this.size;
        return true;
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (n > n2) {
            Object[] objectArray = this.elementData;
            int n3 = (n2 * 3 >> 1) + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Object[n3];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    public void add(int n, Object object) {
        int n2;
        if (n > (n2 = this.size++)) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        this.ensureCapacity(n2 + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, n2 - n);
        this.elementData[n] = object;
    }

    public Object remove(int n) {
        this.checkAgainstSize(n);
        Object object = this.elementData[n];
        ++this.modCount;
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return object;
    }

    public Object set(int n, Object object) {
        this.checkAgainstSize(n);
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    public boolean addAll(Collection collection) {
        if (collection instanceof SortedSet) {
            return this.addAll((SortedSet)collection);
        }
        return super.addAll(collection);
    }

    public boolean addAll(SortedSet sortedSet) {
        if (this == sortedSet) {
            return false;
        }
        Comparator comparator = this.comparator;
        Comparator comparator2 = sortedSet.comparator();
        if (!(comparator == comparator2 || comparator != null && comparator.equals(comparator2))) {
            return super.addAll(sortedSet);
        }
        int n = this.size;
        int n2 = sortedSet.size();
        Object[] objectArray = this.elementData;
        int n3 = Math.max(objectArray.length, n + n2);
        int n4 = 0;
        Object[] objectArray2 = new Object[n3];
        this.elementData = objectArray2;
        int n5 = 0;
        Iterator iterator = sortedSet.iterator();
        boolean bl = false;
        while (true) {
            Object e;
            block7: {
                int n6;
                if (!iterator.hasNext()) {
                    System.arraycopy(objectArray, n5, objectArray2, n4, n - n5);
                    this.size = n4 + n - n5;
                    return bl;
                }
                e = iterator.next();
                do {
                    if (n5 == n) {
                        objectArray2[n4++] = e;
                        while (iterator.hasNext()) {
                            objectArray2[n4++] = iterator.next();
                        }
                        this.size = n4;
                        return true;
                    }
                    Object object = objectArray[n5];
                    n6 = this.compare(object, e);
                    if (n6 > 0) break block7;
                    objectArray2[n4++] = object;
                    ++n5;
                } while (n6 != 0);
                continue;
            }
            objectArray2[n4++] = e;
            bl = true;
        }
    }

    public int indexOf(Object object) {
        int n = this.whereDoesItGo(object);
        if (n == this.size || !object.equals(this.elementData[n])) {
            return -1;
        }
        return n;
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public boolean equals(Object object) {
        if (object instanceof SortedSet) {
            return this.equals((SortedSet)object);
        }
        if (object instanceof Collection) {
            return this.equals((Collection)object);
        }
        return false;
    }

    public boolean equals(SortedSet sortedSet) {
        if (this.size != sortedSet.size()) {
            return false;
        }
        Object[] objectArray = this.elementData;
        int n = 0;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            if (objectArray[n++].equals(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Collection collection) {
        if (this.size != collection.size()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            n += this.elementData[n2].hashCode();
            ++n2;
        }
        return n;
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        Object[] objectArray = this.elementData;
        int n3 = this.size;
        System.arraycopy(objectArray, n2, objectArray, n, n3 - n2);
        int n4 = this.size = n3 - n2 + n;
        while (n4 < n3) {
            objectArray[n4] = null;
            ++n4;
        }
    }

    public List subList(int n, int n2) {
        if (n >= this.size || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object[] objectArray = this.elementData;
        if (n2 == this.size) {
            return (List)((Object)this.tailSet(objectArray[n]));
        }
        return (List)((Object)this.subSet(objectArray[n], objectArray[n2]));
    }

    public boolean contains(Object object) {
        boolean bl = false;
        if (this.indexOf(object) != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public Object clone() {
        try {
            SortedArraySet sortedArraySet = (SortedArraySet)super.clone();
            int n = this.elementData.length;
            sortedArraySet.elementData = new Object[n];
            sortedArraySet.size = this.size;
            System.arraycopy(this.elementData, 0, sortedArraySet.elementData, 0, this.size);
            return sortedArraySet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private SortedArraySet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
        this.size = 0;
        this.comparator = null;
    }

    private SortedArraySet() {
        this(10);
    }

    private SortedArraySet(Collection collection) {
        this((int)Math.min((long)collection.size() * 110L / 100L, Integer.MAX_VALUE));
        this.addAll(collection);
    }

    private SortedArraySet(Comparator comparator) {
        this(10, comparator);
    }

    private SortedArraySet(int n, Comparator comparator) {
        this.elementData = new Object[n];
        this.size = 0;
        this.comparator = comparator;
    }

    private class SubSet
    extends AbstractList
    implements SortedSet,
    List,
    Serializable,
    RandomAccess {
        private final Object from;
        private final Object to;
        private int startIndex;
        private int endIndex;
        private int parentModCount;
        private final boolean fromStart;
        private final boolean toEnd;

        private final void checkModCount() {
            int n = SortedArraySet.this.modCount;
            if (this.parentModCount != n) {
                this.parentModCount = n;
                this.updateIndices();
            }
        }

        private final void updateIndices() {
            if (!this.fromStart) {
                this.startIndex = SortedArraySet.this.whereDoesItGo(this.from);
            }
            this.endIndex = !this.toEnd ? SortedArraySet.this.whereDoesItGo(this.to) : SortedArraySet.this.size;
        }

        private final void checkBounds(Object object) {
            if (!this.fromStart && SortedArraySet.this.compare(this.from, object) > 0) {
                throw new IllegalArgumentException(object + " < " + this.from);
            }
            if (!this.toEnd && SortedArraySet.this.compare(this.to, object) <= 0) {
                throw new IllegalArgumentException(object + " >= " + this.to);
            }
        }

        private final int checkWithinRange2(Object object) {
            int n = SortedArraySet.this.whereDoesItGo(object);
            if (!this.fromStart && (n < this.startIndex || n == this.startIndex && SortedArraySet.this.compare(this.from, object) > 0)) {
                throw new IllegalArgumentException(object + " < " + this.from);
            }
            if (!this.toEnd && (n > this.endIndex || n == this.endIndex && SortedArraySet.this.compare(object, this.to) > 0)) {
                throw new IllegalArgumentException(object + " > " + this.to);
            }
            return n;
        }

        public boolean add(Object object) {
            this.checkBounds(object);
            return SortedArraySet.this.add(object);
        }

        public boolean remove(Object object) {
            this.checkBounds(object);
            return SortedArraySet.this.remove(object);
        }

        public int size() {
            this.checkModCount();
            return this.endIndex - this.startIndex;
        }

        public Comparator comparator() {
            return SortedArraySet.this.comparator;
        }

        public SortedSet subSet(Object object, Object object2) {
            this.checkModCount();
            int n = SortedArraySet.this.whereDoesItGo(object);
            if (!this.fromStart && (n < this.startIndex || n == this.startIndex && SortedArraySet.this.compare(this.from, object) > 0)) {
                throw new IllegalArgumentException(object + " < " + this.from);
            }
            int n2 = SortedArraySet.this.whereDoesItGo(object2);
            if (!this.toEnd && (n2 > this.endIndex || n2 == this.endIndex && SortedArraySet.this.compare(object2, this.to) > 0)) {
                throw new IllegalArgumentException(object2 + " > " + this.to);
            }
            if (n > n2 || n == n2 && SortedArraySet.this.compare(object2, object2) > 0) {
                throw new IllegalArgumentException(object + " > " + object2);
            }
            return new SubSet(object, object2, n, n2, false, false);
        }

        public SortedSet headSet(Object object) {
            this.checkModCount();
            int n = this.checkWithinRange2(object);
            return new SubSet(this.from, object, this.startIndex, n, this.fromStart, false);
        }

        public SortedSet tailSet(Object object) {
            this.checkModCount();
            int n = this.checkWithinRange2(object);
            return new SubSet(object, this.to, n, this.endIndex, false, this.toEnd);
        }

        public Object first() {
            this.checkModCount();
            int n = this.startIndex;
            if (this.endIndex <= n) {
                throw new NoSuchElementException();
            }
            return SortedArraySet.this.elementData[n];
        }

        public Object last() {
            this.checkModCount();
            int n = this.endIndex;
            if (n <= this.startIndex) {
                throw new NoSuchElementException();
            }
            return SortedArraySet.this.elementData[n - 1];
        }

        protected void removeRange(int n, int n2) {
            this.checkModCount();
            int n3 = this.startIndex;
            SortedArraySet.this.removeRange(n3 + n, n3 + n2);
        }

        private final int checkIndex(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException(n + " < 0");
            }
            this.checkModCount();
            int n2 = this.startIndex;
            int n3 = n2 + n;
            int n4 = this.endIndex;
            if (n3 >= n4) {
                throw new IndexOutOfBoundsException(n + " >= " + (n4 - n2));
            }
            return n3;
        }

        public Object get(int n) {
            int n2 = this.checkIndex(n);
            return SortedArraySet.this.elementData[n2];
        }

        public void add(int n, Object object) {
            if (n < 0) {
                throw new IndexOutOfBoundsException(n + " < 0");
            }
            this.checkModCount();
            int n2 = this.startIndex;
            int n3 = n2 + n;
            int n4 = this.endIndex;
            if (n3 > n4) {
                throw new IndexOutOfBoundsException(n + " > " + (n4 - n2));
            }
            SortedArraySet.this.add(n3, object);
        }

        public Object remove(int n) {
            int n2 = this.checkIndex(n);
            return SortedArraySet.this.remove(n2);
        }

        public Object set(int n, Object object) {
            int n2 = this.checkIndex(n);
            return SortedArraySet.this.set(n2, object);
        }

        public int indexOf(Object object) {
            int n = SortedArraySet.this.indexOf(object);
            this.checkModCount();
            int n2 = this.startIndex;
            if (n < n2) {
                return -1;
            }
            if (n >= this.endIndex) {
                return -1;
            }
            return n - n2;
        }

        public int lastIndexOf(Object object) {
            return this.lastIndexOf(object);
        }

        public List subList(int n, int n2) {
            Object object = this.get(n);
            if (n2 == this.size()) {
                return (List)((Object)this.tailSet(object));
            }
            Object object2 = this.get(n2);
            return (List)((Object)this.subSet(object, object2));
        }

        public boolean contains(Object object) {
            boolean bl = false;
            if (this.indexOf(object) != -1) {
                bl = true;
            }
            return bl;
        }

        SubSet(Object object, Object object2, int n, int n2, boolean bl, boolean bl2) {
            this.from = object;
            this.to = object2;
            this.startIndex = n;
            this.endIndex = n2;
            this.fromStart = bl;
            this.toEnd = bl2;
            this.parentModCount = SortedArraySet.this.modCount;
        }

        SubSet(Object object, Object object2) {
            if (SortedArraySet.this.compare(object, object2) > 0) {
                throw new IllegalArgumentException(object + " > " + object2);
            }
            this.from = object;
            this.to = object2;
            this.fromStart = false;
            this.toEnd = false;
            this.parentModCount = SortedArraySet.this.modCount;
            this.updateIndices();
        }

        SubSet(Object object, boolean bl) {
            if (bl) {
                this.fromStart = true;
                this.toEnd = false;
                this.from = null;
                this.to = object;
            } else {
                this.fromStart = false;
                this.toEnd = true;
                this.from = object;
                this.to = null;
            }
            this.parentModCount = SortedArraySet.this.modCount;
            this.updateIndices();
        }
    }

    public static class SortedArraySetFactory
    extends SetFactory {
        public static final boolean TEST = false;
        public static final boolean PROFILE = false;

        public Set makeSet(Comparator comparator) {
            return new SortedArraySet(comparator);
        }

        public Set makeSet(int n) {
            return new SortedArraySet(n);
        }

        public Set makeSet(Collection collection) {
            return new SortedArraySet(collection);
        }

        private SortedArraySetFactory() {
        }
    }
}

