/*
 * Decompiled with CFR 0.152.
 */
package Util.Graphs;

import Util.Collections.FilterIterator;
import Util.Collections.Pair;
import Util.Collections.WrappedCollection;
import Util.Graphs.Navigator;
import java.util.Collection;
import java.util.Collections;

public class EdgeNavigator
implements Navigator {
    protected final Navigator navigator;

    public Collection next(Object object) {
        if (object instanceof Pair) {
            Pair pair = (Pair)object;
            return Collections.singleton(pair.right);
        }
        return new WrappedCollection(this.navigator.next(object), null, new AddLeftFilter(object));
    }

    public Collection prev(Object object) {
        if (object instanceof Pair) {
            Pair pair = (Pair)object;
            return Collections.singleton(pair.left);
        }
        return new WrappedCollection(this.navigator.prev(object), null, new AddRightFilter(object));
    }

    public EdgeNavigator(Navigator navigator) {
        this.navigator = navigator;
    }

    public static class AddLeftFilter
    extends FilterIterator.Filter {
        Object left;

        public Object map(Object object) {
            return new Pair(this.left, object);
        }

        public AddLeftFilter(Object object) {
            this.left = object;
        }
    }

    public static class AddRightFilter
    extends FilterIterator.Filter {
        Object right;

        public Object map(Object object) {
            return new Pair(object, this.right);
        }

        public AddRightFilter(Object object) {
            this.right = object;
        }
    }
}

