/*
 * Decompiled with CFR 0.152.
 */
package Util.Graphs;

import Util.Collections.IndexMap;
import Util.Collections.Pair;
import Util.Graphs.Graph;
import Util.Graphs.Navigator;
import Util.IO.Textualizable;
import Util.IO.Textualizer;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class PathNumbering {
    public abstract BigInteger countPaths(Collection var1, Navigator var2, Map var3);

    public abstract Range getRange(Object var1);

    public abstract Range getEdge(Object var1, Object var2);

    public BigInteger countPaths(Graph graph) {
        return this.countPaths(graph.getRoots(), graph.getNavigator(), null);
    }

    public Range getEdge(Pair pair) {
        return this.getEdge(pair.left, pair.right);
    }

    public void dotGraph(DataOutput dataOutput, Collection collection, Navigator navigator) throws IOException {
        dataOutput.writeBytes("digraph \"PathNumbering\" {\n");
        dataOutput.writeBytes("  concentrate=true; node[fontsize=7];\n");
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(collection);
        IndexMap indexMap = new IndexMap("NodeMap");
        while (!linkedList.isEmpty()) {
            Object e = linkedList.removeFirst();
            int n = indexMap.get(e);
            dataOutput.writeBytes("  n" + n + " [label=\"" + e + "\"];\n");
            Iterator iterator = navigator.next(e).iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!indexMap.contains(e2)) {
                    linkedList.add(e2);
                }
                int n2 = indexMap.get(e2);
                Range range = this.getEdge(e, e2);
                dataOutput.writeBytes("  n" + n + " -> n" + n2 + " [label=\"" + range + "\"];\n");
            }
        }
        dataOutput.writeBytes("}\n");
    }

    public static BigInteger toBigInt(Number number) {
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    public static Number fromBigInt(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        if (n < 32) {
            return new Integer(bigInteger.intValue());
        }
        if (n < 64) {
            return new Long(bigInteger.longValue());
        }
        return bigInteger;
    }

    public static class Range
    implements Textualizable {
        public Number low;
        public Number high;

        public String toString() {
            return "<" + this.low + ',' + this.high + '>';
        }

        public boolean equals(Range range) {
            boolean bl = false;
            if (this.low.equals(range.low) && this.high.equals(range.high)) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            try {
                return this.equals((Range)object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.low.hashCode() ^ this.high.hashCode();
        }

        public void write(Textualizer textualizer) throws IOException {
            textualizer.writeBytes("" + this.low + ' ' + this.high);
        }

        public void writeEdges(Textualizer textualizer) throws IOException {
        }

        public void addEdge(String string, Textualizable textualizable) {
        }

        public static Range read(StringTokenizer stringTokenizer) {
            long l = Long.parseLong(stringTokenizer.nextToken());
            long l2 = Long.parseLong(stringTokenizer.nextToken());
            return new Range((Number)new Long(l), (Number)new Long(l2));
        }

        public Range(int n, int n2) {
            this.low = new Integer(n);
            this.high = new Integer(n2);
        }

        public Range(Number number, Number number2) {
            this.low = number;
            this.high = number2;
        }

        public Range(Number number, BigInteger bigInteger) {
            this.low = number;
            this.high = PathNumbering.fromBigInt(bigInteger);
        }

        public Range(BigInteger bigInteger, Number number) {
            this.low = PathNumbering.fromBigInt(bigInteger);
            this.high = number;
        }

        public Range(BigInteger bigInteger, BigInteger bigInteger2) {
            this.low = PathNumbering.fromBigInt(bigInteger);
            this.high = PathNumbering.fromBigInt(bigInteger2);
        }
    }
}

