/*
 * Decompiled with CFR 0.152.
 */
package Util.Graphs;

import Util.Assert;
import Util.Collections.IndexMap;
import Util.Collections.IndexedMap;
import Util.Collections.Pair;
import Util.Collections.UnmodifiableIterator;
import Util.Graphs.Graph;
import Util.Graphs.Navigator;
import Util.Graphs.PathNumbering;
import Util.Graphs.SCCTopSortedGraph;
import Util.Graphs.SCComponent;
import Util.IO.Textualizable;
import Util.IO.Textualizer;
import Util.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SCCPathNumbering
extends PathNumbering {
    public static final boolean PRINT_BIGGEST = false;
    public static final boolean TRACE_NUMBERING = false;
    public static final boolean TRACE_PATH = false;
    public static final boolean VERIFY_ASSERTIONS = false;
    Navigator navigator;
    SCCTopSortedGraph graph;
    Map nodeToScc;
    Map sccNumbering;
    Map sccEdges;
    Map edgeNumbering;
    Selector selector;
    Set unimportant;

    public BigInteger countPaths(Collection collection, Navigator navigator, Map map) {
        Object object;
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        int n2 = 0;
        Set set = SCComponent.buildSCC(collection, navigator);
        this.navigator = navigator;
        this.graph = SCCTopSortedGraph.topSort(set);
        SCComponent sCComponent = this.graph.getFirst();
        while (sCComponent != null) {
            this.initializeSccMap(sCComponent);
            n = Math.max(sCComponent.getId(), n);
            sCComponent = sCComponent.nextTopSort();
            ++n2;
        }
        sCComponent = this.graph.getFirst();
        while (sCComponent != null) {
            object = BigInteger.ZERO;
            if (map != null && !sCComponent.isLoop()) {
                object = SCCPathNumbering.toBigInt((Number)map.get(sCComponent.nodes()[0]));
            }
            this.recordEdgesFromSCC(sCComponent);
            Object object2 = Arrays.asList(sCComponent.prev()).iterator();
            while (object2.hasNext()) {
                SCComponent sCComponent2 = object2.next();
                Pair pair = new Pair(sCComponent2, sCComponent);
                int n3 = ((Collection)this.sccEdges.get(pair)).size();
                PathNumbering.Range range = (PathNumbering.Range)this.sccNumbering.get(sCComponent2);
                BigInteger bigInteger2 = SCCPathNumbering.toBigInt(range.high).add(BigInteger.ONE);
                BigInteger bigInteger3 = ((BigInteger)object).add(bigInteger2.multiply(BigInteger.valueOf(n3)));
                if (this.isImportant(sCComponent2, sCComponent, bigInteger3)) {
                    object = bigInteger3;
                    continue;
                }
                this.unimportant.add(pair);
                if (((BigInteger)object).compareTo(bigInteger2) >= 0) continue;
                object = bigInteger2;
            }
            if (sCComponent.prevLength() == 0) {
                object = ((BigInteger)object).add(BigInteger.ONE);
            }
            object2 = new PathNumbering.Range(SCCPathNumbering.fromBigInt((BigInteger)object), SCCPathNumbering.fromBigInt(((BigInteger)object).subtract(BigInteger.ONE)));
            this.sccNumbering.put(sCComponent, object2);
            bigInteger = bigInteger.max((BigInteger)object);
            sCComponent = sCComponent.nextTopSort();
        }
        sCComponent = this.graph.getFirst();
        while (sCComponent != null) {
            this.addEdges(sCComponent);
            sCComponent = sCComponent.nextTopSort();
        }
        sCComponent = this.graph.getFirst();
        while (sCComponent != null) {
            object = (PathNumbering.Range)this.sccNumbering.get(sCComponent);
            if (((PathNumbering.Range)object).low.longValue() != 0L) {
                ((PathNumbering.Range)object).low = new Integer(0);
            }
            sCComponent = sCComponent.nextTopSort();
        }
        return bigInteger;
    }

    protected void initializeSccMap(SCComponent sCComponent) {
        Object[] objectArray = sCComponent.nodes();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.nodeToScc.put(object, sCComponent);
            ++n;
        }
    }

    private final void recordEdgesFromSCC(SCComponent sCComponent) {
        Object[] objectArray = sCComponent.nodes();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            Collection collection = this.navigator.next(object);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                SCComponent sCComponent2 = (SCComponent)this.nodeToScc.get(e);
                Pair pair = new Pair(sCComponent, sCComponent2);
                LinkedList<Pair> linkedList = (LinkedList<Pair>)this.sccEdges.get(pair);
                if (linkedList == null) {
                    linkedList = new LinkedList<Pair>();
                    this.sccEdges.put(pair, linkedList);
                }
                linkedList.add(new Pair(object, e));
            }
            ++n;
        }
    }

    private final void addEdges(SCComponent sCComponent) {
        Pair pair;
        Object object;
        Object object2;
        PathNumbering.Range range = (PathNumbering.Range)this.sccNumbering.get(sCComponent);
        if (sCComponent.prevLength() == 0) {
            range.low = new Integer(0);
        }
        if (sCComponent.isLoop()) {
            object2 = (Collection)this.sccEdges.get(new Pair(sCComponent, sCComponent));
            object = object2.iterator();
            while (object.hasNext()) {
                pair = (Pair)object.next();
                this.edgeNumbering.put(pair, range);
            }
        }
        object2 = Arrays.asList(sCComponent.next()).iterator();
        while (object2.hasNext()) {
            object = (SCComponent)object2.next();
            pair = new Pair(sCComponent, object);
            boolean bl = this.unimportant.contains(pair) ^ true;
            PathNumbering.Range range2 = (PathNumbering.Range)this.sccNumbering.get(object);
            Collection collection = (Collection)this.sccEdges.get(pair);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                PathNumbering.Range range3;
                BigInteger bigInteger;
                Pair pair2 = (Pair)iterator.next();
                if (bl) {
                    bigInteger = SCCPathNumbering.toBigInt(range2.low).subtract(SCCPathNumbering.toBigInt(range.high).add(BigInteger.ONE));
                    boolean bl2 = false;
                    if (bigInteger.signum() != -1) {
                        bl2 = true;
                    }
                    Assert._assert(bl2);
                    range2.low = SCCPathNumbering.fromBigInt(bigInteger);
                    range3 = new PathNumbering.Range(bigInteger, bigInteger.add(SCCPathNumbering.toBigInt(range.high)));
                } else {
                    bigInteger = BigInteger.ZERO;
                    range3 = new PathNumbering.Range(bigInteger, bigInteger.add(SCCPathNumbering.toBigInt(range.high)));
                }
                this.edgeNumbering.put(pair2, range3);
            }
        }
    }

    public boolean isImportant(SCComponent sCComponent, SCComponent sCComponent2, BigInteger bigInteger) {
        if (this.selector == null) {
            return true;
        }
        return this.selector.isImportant(sCComponent, sCComponent2, bigInteger);
    }

    public PathNumbering.Range getRange(Object object) {
        SCComponent sCComponent = (SCComponent)this.nodeToScc.get(object);
        return this.getSCCRange(sCComponent);
    }

    public PathNumbering.Range getSCCRange(SCComponent sCComponent) {
        PathNumbering.Range range = (PathNumbering.Range)this.sccNumbering.get(sCComponent);
        return range;
    }

    public Number numberOfPathsTo(Object object) {
        SCComponent sCComponent = (SCComponent)this.nodeToScc.get(object);
        return this.numberOfPathsToSCC(sCComponent);
    }

    public Number numberOfPathsToSCC(SCComponent sCComponent) {
        PathNumbering.Range range = (PathNumbering.Range)this.sccNumbering.get(sCComponent);
        if (range == null) {
            return null;
        }
        Number number = SCCPathNumbering.fromBigInt(SCCPathNumbering.toBigInt(range.high).add(BigInteger.ONE));
        return number;
    }

    public PathNumbering.Range getEdge(Object object, Object object2) {
        return this.getEdge(new Pair(object, object2));
    }

    public PathNumbering.Range getEdge(Pair pair) {
        PathNumbering.Range range = (PathNumbering.Range)this.edgeNumbering.get(pair);
        return range;
    }

    public Collection getSCCEdges(SCComponent sCComponent, SCComponent sCComponent2) {
        return this.getSCCEdges(new Pair(sCComponent, sCComponent2));
    }

    public Collection getSCCEdges(Pair pair) {
        Collection collection = (Collection)this.sccEdges.get(pair);
        return collection;
    }

    public SCComponent getSCC(Object object) {
        return (SCComponent)this.nodeToScc.get(object);
    }

    public Path getPath(Object object, Number number) {
        BigInteger bigInteger = SCCPathNumbering.toBigInt(number);
        PathNumbering.Range range = (PathNumbering.Range)this.sccNumbering.get(this.nodeToScc.get(object));
        if (bigInteger.compareTo(SCCPathNumbering.toBigInt(range.high)) > 0) {
            return null;
        }
        Path path = new Path(object);
        PostOrderComparator postOrderComparator = new PostOrderComparator(this.nodeToScc, this.graph);
        TreeSet<Object> treeSet = new TreeSet<Object>(postOrderComparator);
        HashMap<Object, BigInteger> hashMap = new HashMap<Object, BigInteger>();
        HashMap<Object, Path> hashMap2 = new HashMap<Object, Path>();
        treeSet.add(object);
        hashMap.put(object, bigInteger);
        hashMap2.put(object, path);
        while (!treeSet.isEmpty()) {
            object = treeSet.last();
            treeSet.remove(object);
            bigInteger = (BigInteger)hashMap.get(object);
            path = (Path)hashMap2.get(object);
            Iterator iterator = this.navigator.prev(object).iterator();
            while (iterator.hasNext()) {
                BigInteger bigInteger2;
                Object e = iterator.next();
                PathNumbering.Range range2 = this.getEdge(e, object);
                if (bigInteger.compareTo(SCCPathNumbering.toBigInt(range2.high)) > 0 || (bigInteger2 = bigInteger.subtract(SCCPathNumbering.toBigInt(range2.low))).signum() < 0 || hashMap.containsKey(e)) continue;
                treeSet.add(e);
                hashMap.put(e, bigInteger2);
                hashMap2.put(e, new Path(e, path));
            }
        }
        return path;
    }

    public SCCTopSortedGraph getSCCGraph() {
        return this.graph;
    }

    public static SCCPathNumbering read(DataInput dataInput) throws IOException {
        Object object;
        Textualizable textualizable;
        Textualizable textualizable2;
        Object object2;
        Integer n;
        int n2;
        StringTokenizer stringTokenizer;
        HashMap<Integer, SCComponent> hashMap = new HashMap<Integer, SCComponent>();
        SCCPathNumbering sCCPathNumbering = new SCCPathNumbering();
        String string = dataInput.readLine();
        Textualizer.Map map = new Textualizer.Map(dataInput);
        int n3 = Integer.parseInt(string);
        int n4 = 0;
        while (n4 < n3) {
            string = dataInput.readLine();
            stringTokenizer = new StringTokenizer(string);
            Textualizable textualizable3 = map.readObject();
            string = stringTokenizer.nextToken();
            Assert._assert(string.equals("->"));
            string = stringTokenizer.nextToken();
            Assert._assert(string.startsWith("SCC"));
            n2 = Integer.parseInt(string.substring(3));
            n = new Integer(n2);
            object2 = (SCComponent)hashMap.get(n);
            if (object2 == null) {
                object2 = new SCComponent();
                hashMap.put(n, (SCComponent)object2);
            }
            textualizable2 = sCCPathNumbering.nodeToScc.put(textualizable3, object2);
            boolean bl = false;
            if (textualizable2 == null) {
                bl = true;
            }
            Assert._assert(bl);
            ++n4;
        }
        string = dataInput.readLine();
        n4 = Integer.parseInt(string);
        int n5 = 0;
        while (n5 < n4) {
            string = dataInput.readLine();
            stringTokenizer = new StringTokenizer(string);
            string = stringTokenizer.nextToken();
            Assert._assert(string.startsWith("SCC"));
            n2 = Integer.parseInt(string.substring(3));
            n = new Integer(n2);
            object2 = (SCComponent)hashMap.get(n);
            boolean bl = false;
            if (object2 != null) {
                bl = true;
            }
            Assert._assert(bl);
            string = stringTokenizer.nextToken();
            Assert._assert(string.equals("Range"));
            textualizable2 = PathNumbering.Range.read(stringTokenizer);
            textualizable = sCCPathNumbering.sccNumbering.put(object2, textualizable2);
            boolean bl2 = false;
            if (textualizable == null) {
                bl2 = true;
            }
            Assert._assert(bl2);
            ++n5;
        }
        string = dataInput.readLine();
        n5 = Integer.parseInt(string);
        n2 = 0;
        while (n2 < n5) {
            string = dataInput.readLine();
            stringTokenizer = new StringTokenizer(string);
            string = stringTokenizer.nextToken();
            Assert._assert(string.startsWith("SCC"));
            int n6 = Integer.parseInt(string.substring(3));
            object2 = new Integer(n6);
            textualizable2 = (SCComponent)hashMap.get(object2);
            boolean bl = false;
            if (textualizable2 != null) {
                bl = true;
            }
            Assert._assert(bl);
            string = stringTokenizer.nextToken();
            Assert._assert(string.startsWith("SCC"));
            int n7 = Integer.parseInt(string.substring(3));
            object = new Integer(n7);
            SCComponent sCComponent = (SCComponent)hashMap.get(object);
            boolean bl3 = false;
            if (sCComponent != null) {
                bl3 = true;
            }
            Assert._assert(bl3);
            Pair pair = new Pair(textualizable2, sCComponent);
            string = stringTokenizer.nextToken();
            int n8 = Integer.parseInt(string);
            HashSet<Pair> hashSet = new HashSet<Pair>();
            int n9 = 0;
            while (n9 < n8) {
                Textualizable textualizable4 = map.readObject();
                Textualizable textualizable5 = map.readObject();
                Pair pair2 = new Pair(textualizable4, textualizable5);
                hashSet.add(pair2);
                ++n9;
            }
            sCCPathNumbering.sccEdges.put(pair, hashSet);
            ++n2;
        }
        string = dataInput.readLine();
        n2 = Integer.parseInt(string);
        int n10 = 0;
        while (n10 < n2) {
            string = dataInput.readLine();
            stringTokenizer = new StringTokenizer(string);
            object2 = map.readObject();
            textualizable2 = map.readObject();
            textualizable = new Pair(object2, textualizable2);
            object = PathNumbering.Range.read(stringTokenizer);
            sCCPathNumbering.edgeNumbering.put(textualizable, object);
            ++n10;
        }
        return sCCPathNumbering;
    }

    public void dump(DataOutput dataOutput) throws IOException {
        Object object;
        Textualizable textualizable;
        Textualizable textualizable2;
        Textualizable textualizable3;
        Map.Entry entry;
        IndexMap indexMap = new IndexMap("SCCs");
        indexMap.addAll(this.nodeToScc.values());
        Textualizer.Map map = new Textualizer.Map(dataOutput, (IndexedMap)indexMap);
        map.writeBytes("" + this.nodeToScc.size() + '\n');
        Iterator iterator = this.nodeToScc.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            textualizable3 = (Textualizable)entry.getKey();
            textualizable3.write(map);
            textualizable2 = (SCComponent)entry.getValue();
            map.writeBytes(" -> SCC" + ((SCComponent)textualizable2).getId() + '\n');
        }
        map.writeBytes("" + this.sccNumbering.size() + '\n');
        iterator = this.sccNumbering.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            textualizable3 = (SCComponent)entry.getKey();
            textualizable2 = (PathNumbering.Range)entry.getValue();
            map.writeBytes("SCC" + ((SCComponent)textualizable3).getId() + " Range ");
            ((PathNumbering.Range)textualizable2).write(map);
            map.writeBytes("\n");
        }
        map.writeBytes("" + this.sccEdges.size() + '\n');
        iterator = this.sccEdges.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            textualizable3 = (Pair)entry.getKey();
            textualizable2 = (SCComponent)((Pair)textualizable3).left;
            textualizable = (SCComponent)((Pair)textualizable3).right;
            object = (Collection)entry.getValue();
            map.writeBytes("SCC" + ((SCComponent)textualizable2).getId() + " SCC" + ((SCComponent)textualizable).getId() + ' ' + object.size());
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                map.writeBytes(" ");
                Textualizable textualizable4 = (Textualizable)pair.left;
                textualizable4.write(map);
                map.writeBytes(" ");
                Textualizable textualizable5 = (Textualizable)pair.right;
                textualizable5.write(map);
            }
            map.writeBytes("\n");
        }
        map.writeBytes("" + this.edgeNumbering.size() + '\n');
        iterator = this.sccEdges.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            textualizable3 = (Pair)entry.getKey();
            textualizable2 = (Textualizable)((Pair)textualizable3).left;
            textualizable2.write(map);
            map.writeBytes(" ");
            textualizable = (Textualizable)((Pair)textualizable3).right;
            textualizable.write(map);
            map.writeBytes(" ");
            object = (PathNumbering.Range)entry.getValue();
            ((PathNumbering.Range)object).write(map);
            map.writeBytes("\n");
        }
    }

    private final /* synthetic */ void this() {
        this.nodeToScc = new HashMap();
        this.sccNumbering = new HashMap();
        this.sccEdges = new HashMap();
        this.edgeNumbering = new HashMap();
        this.unimportant = new HashSet();
    }

    public SCCPathNumbering() {
        this.this();
    }

    public SCCPathNumbering(Selector selector) {
        this.this();
        this.selector = selector;
    }

    public SCCPathNumbering(Graph graph) {
        this.this();
        this.countPaths(graph);
    }

    static class PostOrderComparator
    implements Comparator {
        private final Map nodeToScc;
        private final IndexMap postOrderNumberingOfSccs;

        public int compare(Object object, Object object2) {
            int n;
            if (object.equals(object2)) {
                return 0;
            }
            SCComponent sCComponent = (SCComponent)this.nodeToScc.get(object);
            SCComponent sCComponent2 = (SCComponent)this.nodeToScc.get(object2);
            int n2 = this.postOrderNumberingOfSccs.get(sCComponent);
            if (n2 < (n = this.postOrderNumberingOfSccs.get(sCComponent2))) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            n2 = Arrays.asList(sCComponent.nodes()).indexOf(object);
            if (n2 < (n = Arrays.asList(sCComponent2.nodes()).indexOf(object2))) {
                return -1;
            }
            return 1;
        }

        public PostOrderComparator(Map map, SCCTopSortedGraph sCCTopSortedGraph) {
            this.nodeToScc = map;
            List list = sCCTopSortedGraph.list();
            this.postOrderNumberingOfSccs = new IndexMap("PostOrderNumbering", list.size());
            this.postOrderNumberingOfSccs.addAll(list);
        }
    }

    public static class Path
    extends AbstractList {
        private final Object o;
        private final int length;
        private final Path next;

        public int size() {
            return this.length;
        }

        public Object get(int n) {
            Path path = this;
            while (n != 0) {
                path = path.next;
                --n;
            }
            return path.o;
        }

        public Iterator iterator() {
            return new UnmodifiableIterator(this){
                Path p;
                final /* synthetic */ Path this$0;

                public final boolean hasNext() {
                    boolean bl = false;
                    if (this.p != null) {
                        bl = true;
                    }
                    return bl;
                }

                public final Object next() {
                    Object object = Path.access$0(this.p);
                    this.p = Path.access$1(this.p);
                    return object;
                }

                private final /* synthetic */ void this() {
                    this.p = this.this$0;
                }
                {
                    this.this$0 = path;
                    this.this();
                }
            };
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\t<");
            stringBuffer.append(this.o);
            Path path = this.next;
            while (path != null) {
                stringBuffer.append(',');
                stringBuffer.append(Strings.lineSep);
                stringBuffer.append('\t');
                stringBuffer.append(path.o);
                path = path.next;
            }
            stringBuffer.append('>');
            return stringBuffer.toString();
        }

        static /* synthetic */ Object access$0(Path path) {
            return path.o;
        }

        static /* synthetic */ Path access$1(Path path) {
            return path.next;
        }

        public Path(Object object) {
            this.o = object;
            this.length = 1;
            this.next = null;
        }

        public Path(Object object, Path path) {
            this.o = object;
            this.length = path.length + 1;
            this.next = path;
        }
    }

    public static interface Selector {
        public boolean isImportant(SCComponent var1, SCComponent var2, BigInteger var3);
    }
}

