/*
 * Decompiled with CFR 0.152.
 */
package Util.Graphs;

import Util.Assert;
import Util.Collections.Pair;
import Util.Graphs.Navigator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Traversals {
    private static final byte PREORDER = 1;
    private static final byte REVERSE_PREORDER = 2;
    private static final byte INORDER = 3;
    private static final byte REVERSE_INORDER = 4;
    private static final byte POSTORDER = 5;
    private static final byte REVERSE_POSTORDER = 6;

    public static void test(Navigator navigator, Collection collection) {
        Object e;
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            Traversals.test_helper1(navigator, e, hashSet);
        }
        hashSet.clear();
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            Traversals.test_helper2(navigator, e, hashSet);
        }
    }

    public static void test_helper1(Navigator navigator, Object object, Set set) {
        Iterator iterator = navigator.next(object).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!navigator.prev(e).contains(object)) {
                Assert.UNREACHABLE(object + "->" + e);
            }
            if (!set.add(e)) continue;
            Traversals.test_helper1(navigator, object, set);
        }
    }

    public static void test_helper2(Navigator navigator, Object object, Set set) {
        Iterator iterator = navigator.prev(object).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!navigator.next(e).contains(object)) {
                Assert.UNREACHABLE(e + "<-" + object);
            }
            if (!set.add(e)) continue;
            Traversals.test_helper2(navigator, object, set);
        }
    }

    public static Set getAllEdges(Navigator navigator, Collection collection) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Traversals.getAllEdges_helper(navigator, e, hashSet, hashSet2);
        }
        return hashSet2;
    }

    private static final void getAllEdges_helper(Navigator navigator, Object object, HashSet hashSet, HashSet hashSet2) {
        if (hashSet.contains(object)) {
            return;
        }
        hashSet.add(object);
        Iterator iterator = navigator.next(object).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashSet2.add(new Pair(object, e));
            Traversals.getAllEdges_helper(navigator, e, hashSet, hashSet2);
        }
    }

    public static Map buildPredecessorMap(Navigator navigator, Collection collection) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (hashMap.containsKey(e)) continue;
            hashMap.put(e, new HashSet());
            Traversals.buildPredecessorMap_helper(navigator, e, hashMap);
        }
        return hashMap;
    }

    public static void buildPredecessorMap_helper(Navigator navigator, Object object, Map map) {
        Iterator iterator = navigator.next(object).iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object e = iterator.next();
            HashSet<Object> hashSet = (HashSet<Object>)map.get(e);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                map.put(e, hashSet);
                bl = false;
            } else {
                bl = true;
            }
            hashSet.add(object);
            if (bl) continue;
            Traversals.buildPredecessorMap_helper(navigator, e, map);
        }
    }

    public static Map buildSuccessorMap(Navigator navigator, Collection collection) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (hashMap.containsKey(e)) continue;
            HashSet hashSet = new HashSet();
            hashMap.put(e, hashSet);
            Traversals.buildSuccessorMap_helper(navigator, e, hashSet, hashMap);
        }
        return hashMap;
    }

    public static void buildSuccessorMap_helper(Navigator navigator, Object object, HashSet hashSet, Map map) {
        Iterator iterator = navigator.next(object).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashSet.add(e);
            HashSet hashSet2 = (HashSet)map.get(e);
            if (hashSet2 != null) continue;
            hashSet2 = new HashSet();
            map.put(e, hashSet2);
            Traversals.buildSuccessorMap_helper(navigator, e, hashSet2, map);
        }
    }

    public static List preOrder(Navigator navigator, Object object) {
        return Traversals.traversal_helper(navigator, Collections.singleton(object), (byte)1);
    }

    public static List preOrder(Navigator navigator, Collection collection) {
        return Traversals.traversal_helper(navigator, collection, (byte)1);
    }

    public static List reversePreOrder(Navigator navigator, Object object) {
        return Traversals.traversal_helper(navigator, Collections.singleton(object), (byte)2);
    }

    public static List reversePreOrder(Navigator navigator, Collection collection) {
        return Traversals.traversal_helper(navigator, collection, (byte)2);
    }

    public static List inOrder(Navigator navigator, Object object) {
        return Traversals.traversal_helper(navigator, Collections.singleton(object), (byte)3);
    }

    public static List inOrder(Navigator navigator, Collection collection) {
        return Traversals.traversal_helper(navigator, collection, (byte)3);
    }

    public static List reverseInOrder(Navigator navigator, Object object) {
        return Traversals.traversal_helper(navigator, Collections.singleton(object), (byte)4);
    }

    public static List reverseInOrder(Navigator navigator, Collection collection) {
        return Traversals.traversal_helper(navigator, collection, (byte)4);
    }

    public static List postOrder(Navigator navigator, Object object) {
        return Traversals.traversal_helper(navigator, Collections.singleton(object), (byte)5);
    }

    public static List postOrder(Navigator navigator, Collection collection) {
        return Traversals.traversal_helper(navigator, collection, (byte)5);
    }

    public static List reversePostOrder(Navigator navigator, Object object) {
        return Traversals.traversal_helper(navigator, Collections.singleton(object), (byte)6);
    }

    public static List reversePostOrder(Navigator navigator, Collection collection) {
        return Traversals.traversal_helper(navigator, collection, (byte)6);
    }

    private static final List traversal_helper(Navigator navigator, Collection collection, byte by) {
        HashSet hashSet = new HashSet();
        LinkedList linkedList = new LinkedList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Traversals.traversal_helper(navigator, e, hashSet, linkedList, by);
        }
        return linkedList;
    }

    private static final void traversal_helper(Navigator navigator, Object object, HashSet hashSet, LinkedList linkedList, byte by) {
        if (hashSet.contains(object)) {
            return;
        }
        hashSet.add(object);
        if (by == 1) {
            linkedList.add(object);
        } else if (by == 2) {
            linkedList.addFirst(object);
        }
        Collection collection = navigator.next(object);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Traversals.traversal_helper(navigator, e, hashSet, linkedList, by);
            if (by == 3) {
                linkedList.add(object);
                by = 0;
                continue;
            }
            if (by != 4) continue;
            linkedList.addFirst(object);
            by = 0;
        }
        if (by == 5) {
            linkedList.add(object);
        } else if (by == 6) {
            linkedList.addFirst(object);
        }
    }
}

