/*
 * Decompiled with CFR 0.152.
 */
package Util.IO;

import UTF.UTFDataFormatError;
import UTF.Utf8;
import Util.Assert;
import Util.IO.ExtendedDataOutput;
import Util.IO.MyFileChannelImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class DirectBufferedFileOutputStream
extends OutputStream
implements ExtendedDataOutput {
    public static final int DEFAULT_INITIAL_SIZE = 65536;
    private ByteBuffer directByteBuffer;
    private final FileChannel fileChannel;
    private final FileOutputStream out;
    int totalBytesWritten;

    public final ByteOrder order() {
        return this.directByteBuffer.order();
    }

    public final void order(ByteOrder byteOrder) {
        this.directByteBuffer = this.directByteBuffer.order(byteOrder);
    }

    static String dumpBufferInfo(ByteBuffer byteBuffer) {
        return "pos=" + byteBuffer.position() + ",limit=" + byteBuffer.limit() + ",cap=" + byteBuffer.capacity();
    }

    private final void dumpBuffer() throws IOException {
        this.directByteBuffer.flip();
        while (this.directByteBuffer.hasRemaining()) {
            int n = this.fileChannel.write(this.directByteBuffer);
            this.totalBytesWritten += n;
        }
        this.directByteBuffer.clear();
    }

    public void write(byte[] byArray) throws IOException {
        try {
            this.directByteBuffer.put(byArray);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            this.dumpBuffer();
            this.out.write(byArray);
            this.totalBytesWritten += byArray.length;
            return;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.directByteBuffer.put(byArray, n, n2);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            this.dumpBuffer();
            this.out.write(byArray, n, n2);
            this.totalBytesWritten += n2;
            return;
        }
    }

    public void write(int n) throws IOException {
        this.writeByte(n);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.writeByte(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        while (true) {
            try {
                this.directByteBuffer.put((byte)n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.dumpBuffer();
                continue;
            }
            break;
        }
    }

    public void writeShort(int n) throws IOException {
        while (true) {
            try {
                this.directByteBuffer.putShort((short)n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.dumpBuffer();
                continue;
            }
            break;
        }
    }

    public void writeChar(int n) throws IOException {
        while (true) {
            try {
                this.directByteBuffer.putChar((char)n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.dumpBuffer();
                continue;
            }
            break;
        }
    }

    public void writeInt(int n) throws IOException {
        while (true) {
            try {
                this.directByteBuffer.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.dumpBuffer();
                continue;
            }
            break;
        }
    }

    public void writeLong(long l) throws IOException {
        while (true) {
            try {
                this.directByteBuffer.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.dumpBuffer();
                continue;
            }
            break;
        }
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToRawIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(d));
    }

    public void writeBytes(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            this.writeByte(string.charAt(n));
            ++n;
        }
    }

    public void writeChars(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            this.writeChar(string.charAt(n));
            ++n;
        }
    }

    public void writeUTF(String string) throws IOException {
        try {
            byte[] byArray = Utf8.toUtf8(string);
            if (byArray.length > (char)-1) {
                throw new UTFDataFormatException(byArray.length + " > 65535");
            }
            this.writeShort(byArray.length);
            this.write(byArray);
        }
        catch (UTFDataFormatError uTFDataFormatError) {
            throw new UTFDataFormatException(uTFDataFormatError.getMessage());
        }
    }

    public void flush() throws IOException {
        this.dumpBuffer();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void writeUByte(int n) throws IOException {
        this.writeByte(n);
    }

    public void writeUShort(int n) throws IOException {
        this.writeChar(n);
    }

    public void writeUInt(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeULong(long l) throws IOException {
        this.writeLong(l);
    }

    public int size() {
        return this.totalBytesWritten;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalize() throws Throwable {
        try {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.finalize();
    }

    public DirectBufferedFileOutputStream(FileOutputStream fileOutputStream, int n) {
        this.directByteBuffer = ByteBuffer.allocateDirect(n);
        FileChannel fileChannel = null;
        try {
            fileChannel = MyFileChannelImpl.getFileChannel(fileOutputStream);
        }
        catch (IOException iOException) {
            Assert.UNREACHABLE(iOException.toString());
        }
        this.fileChannel = fileChannel;
        this.out = fileOutputStream;
    }

    public DirectBufferedFileOutputStream(FileOutputStream fileOutputStream) {
        this(fileOutputStream, 65536);
    }
}

