/*
 * Decompiled with CFR 0.152.
 */
package Util.IO;

import Util.Assert;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.MyHeapByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class MyFileChannelImpl
extends FileChannel
implements ReadableByteChannel,
WritableByteChannel {
    FileInputStream fis;
    FileOutputStream fos;
    RandomAccessFile raf;
    long currentPosition;

    public static FileChannel getFileChannel(Object object) throws IOException {
        block7: {
            Class<?> clazz = object.getClass();
            try {
                Method method = clazz.getMethod("getChannel", null);
                return (FileChannel)method.invoke(object, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!(invocationTargetException.getTargetException() instanceof IOException)) break block7;
                throw (IOException)invocationTargetException.getTargetException();
            }
        }
        if (object instanceof FileInputStream) {
            return new MyFileChannelImpl((FileInputStream)object);
        }
        if (object instanceof FileOutputStream) {
            return new MyFileChannelImpl((FileOutputStream)object);
        }
        if (object instanceof RandomAccessFile) {
            return new MyFileChannelImpl((RandomAccessFile)object);
        }
        Assert.UNREACHABLE(object.getClass().toString());
        return null;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.fis != null) {
            if (byteBuffer instanceof MyHeapByteBuffer) {
                if (!byteBuffer.hasRemaining()) {
                    return 0;
                }
                byte[] byArray = ((MyHeapByteBuffer)byteBuffer).getBackingArray();
                int n = ((MyHeapByteBuffer)byteBuffer).getOffset();
                int n2 = byteBuffer.position();
                int n3 = byteBuffer.limit();
                boolean bl = false;
                if (n2 < n3) {
                    bl = true;
                }
                Assert._assert(bl);
                int n4 = this.fis.read(byArray, n + n2, n3 - n2);
                if (n4 == -1) {
                    return -1;
                }
                byteBuffer.position(n2 + n4);
                this.currentPosition += (long)n4;
                return n4;
            }
            int n = 0;
            while (true) {
                if (!byteBuffer.hasRemaining()) {
                    return n;
                }
                int n5 = this.fis.read();
                if (n5 == -1) {
                    if (n != 0) {
                        return n;
                    }
                    return -1;
                }
                byteBuffer.put((byte)n5);
                ++n;
                ++this.currentPosition;
            }
        }
        throw new NonReadableChannelException();
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.read(byteBufferArray[n + n4]);
            if (n5 == -1) {
                if (n3 != 0) {
                    return n3;
                }
                return -1;
            }
            n3 += n5;
            ++n4;
        }
        return n3;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.fos != null) {
            if (byteBuffer instanceof MyHeapByteBuffer) {
                if (!byteBuffer.hasRemaining()) {
                    return 0;
                }
                byte[] byArray = ((MyHeapByteBuffer)byteBuffer).getBackingArray();
                int n = ((MyHeapByteBuffer)byteBuffer).getOffset();
                int n2 = byteBuffer.position();
                int n3 = byteBuffer.limit();
                int n4 = n3 - n2;
                boolean bl = false;
                if (n4 > 0) {
                    bl = true;
                }
                Assert._assert(bl);
                this.fos.write(byArray, n + n2, n4);
                byteBuffer.position(n3);
                this.currentPosition += (long)n4;
                return n4;
            }
            int n = 0;
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                this.fos.write(by);
                ++n;
                ++this.currentPosition;
            }
            return n;
        }
        throw new NonWritableChannelException();
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += this.write(byteBufferArray[n + n4]);
            ++n4;
        }
        return n3;
    }

    public long position() throws IOException {
        return this.currentPosition;
    }

    public FileChannel position(long l) throws IOException {
        if (this.raf == null) {
            throw new IOException();
        }
        this.raf.seek(l);
        return this;
    }

    public long size() throws IOException {
        if (this.raf == null) {
            throw new IOException();
        }
        return this.raf.length();
    }

    public FileChannel truncate(long l) throws IOException {
        if (this.raf == null) {
            throw new IOException();
        }
        this.raf.setLength(l);
        return this;
    }

    public void force(boolean bl) throws IOException {
        if (this.fos != null) {
            this.fos.flush();
        }
    }

    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        throw new IOException("not yet implemented");
    }

    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        throw new IOException("not yet implemented");
    }

    protected void implCloseChannel() throws IOException {
    }

    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        throw new IOException("not yet implemented");
    }

    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        throw new IOException("not yet implemented");
    }

    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        return null;
    }

    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        return null;
    }

    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return null;
    }

    MyFileChannelImpl(RandomAccessFile randomAccessFile) throws IOException {
        this.raf = randomAccessFile;
        this.fis = new FileInputStream(randomAccessFile.getFD());
        this.fos = new FileOutputStream(randomAccessFile.getFD());
    }

    MyFileChannelImpl(FileInputStream fileInputStream) {
        this.fis = fileInputStream;
    }

    MyFileChannelImpl(FileOutputStream fileOutputStream) {
        this.fos = fileOutputStream;
    }
}

