/*
 * Decompiled with CFR 0.152.
 */
package Util.IO;

import Util.Assert;
import Util.Collections.IndexMap;
import Util.Collections.IndexedMap;
import Util.Collections.Pair;
import Util.IO.Textualizable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public interface Textualizer {
    public Textualizable readObject() throws IOException;

    public Textualizable readReference() throws IOException;

    public void writeTypeOf(Textualizable var1) throws IOException;

    public void writeObject(Textualizable var1) throws IOException;

    public void writeEdge(String var1, Textualizable var2) throws IOException;

    public void writeReference(Textualizable var1) throws IOException;

    public void writeBytes(String var1) throws IOException;

    public StringTokenizer nextLine() throws IOException;

    public int getIndex(Textualizable var1);

    public boolean contains(Textualizable var1);

    public static class Simple
    implements Textualizer {
        protected DataInput in;
        protected DataOutput out;
        protected StringTokenizer st;
        static /* synthetic */ Class class$java$util$StringTokenizer;

        public StringTokenizer nextLine() throws IOException {
            this.st = new StringTokenizer(this.in.readLine());
            return this.st;
        }

        protected void updateTokenizer() throws IOException {
            if (this.st == null || !this.st.hasMoreElements()) {
                this.st = new StringTokenizer(this.in.readLine());
            }
        }

        public Textualizable readObject() throws IOException {
            this.updateTokenizer();
            String string = this.st.nextToken();
            if (string.equals("null")) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[1];
                Class clazz2 = class$java$util$StringTokenizer;
                if (clazz2 == null) {
                    clazz2 = class$java$util$StringTokenizer = Simple.class$("[Ljava.util.StringTokenizer;", false);
                }
                classArray[0] = clazz2;
                Method method = clazz.getMethod("read", classArray);
                return (Textualizable)method.invoke(null, this.st);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            return null;
        }

        public Textualizable readReference() throws IOException {
            return this.readObject();
        }

        public void writeTypeOf(Textualizable textualizable) throws IOException {
            if (textualizable != null) {
                this.out.writeBytes(textualizable.getClass().getName());
                this.out.write(32);
            }
        }

        public void writeObject(Textualizable textualizable) throws IOException {
            if (textualizable != null) {
                textualizable.write(this);
            } else {
                this.out.writeBytes("null");
            }
        }

        public void writeReference(Textualizable textualizable) throws IOException {
            this.writeObject(textualizable);
        }

        public void writeEdge(String string, Textualizable textualizable) throws IOException {
            throw new InternalError();
        }

        public void writeBytes(String string) throws IOException {
            this.out.writeBytes(string);
        }

        public int getIndex(Textualizable textualizable) {
            throw new InternalError();
        }

        public boolean contains(Textualizable textualizable) {
            throw new InternalError();
        }

        static /* synthetic */ Class class$(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public Simple(DataInput dataInput) {
            this.in = dataInput;
        }

        public Simple(DataOutput dataOutput) {
            this.out = dataOutput;
        }
    }

    public static class Map
    extends Simple {
        protected IndexedMap map;
        protected java.util.Map deferredEdges;

        public Textualizable readObject() throws IOException {
            Collection collection;
            Textualizable textualizable = super.readObject();
            int n = this.map.size();
            int n2 = this.map.get(textualizable);
            boolean bl = false;
            if (n2 == n) {
                bl = true;
            }
            Assert._assert(bl);
            if (this.deferredEdges != null && (collection = (Collection)this.deferredEdges.get(new Integer(n2))) != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    Textualizable textualizable2 = (Textualizable)pair.left;
                    String string = (String)pair.right;
                    textualizable2.addEdge(string, textualizable);
                }
                this.deferredEdges.remove(textualizable);
            }
            return textualizable;
        }

        public void readEdges(Textualizable textualizable) {
            while (this.st.hasMoreTokens()) {
                Object object;
                String string = this.st.nextToken();
                int n = Integer.parseInt(this.st.nextToken());
                if (n >= this.map.size()) {
                    object = new Integer(n);
                    LinkedList<Pair> linkedList = (LinkedList<Pair>)this.deferredEdges.get(object);
                    if (linkedList == null) {
                        linkedList = new LinkedList<Pair>();
                        this.deferredEdges.put(object, linkedList);
                    }
                    linkedList.add(new Pair(textualizable, string));
                    continue;
                }
                object = (Textualizable)this.map.get(n);
                textualizable.addEdge(string, (Textualizable)object);
            }
        }

        public Textualizable readReference() throws IOException {
            this.updateTokenizer();
            int n = Integer.parseInt(this.st.nextToken());
            return (Textualizable)this.map.get(n);
        }

        public void writeObject(Textualizable textualizable) throws IOException {
            super.writeObject(textualizable);
            if (textualizable != null) {
                textualizable.writeEdges(this);
            }
        }

        public void writeReference(Textualizable textualizable) throws IOException {
            if (!this.map.contains(textualizable)) {
                System.out.println("Not in map: " + textualizable);
                this.writeObject(textualizable);
            } else {
                int n = this.map.get(textualizable);
                this.out.writeBytes(Integer.toString(n));
            }
        }

        public void writeEdge(String string, Textualizable textualizable) throws IOException {
            this.out.writeByte(32);
            this.out.writeBytes(string);
            this.out.writeByte(32);
            this.map.get(textualizable);
            this.writeReference(textualizable);
        }

        public int getIndex(Textualizable textualizable) {
            Assert._assert(this.map.contains(textualizable));
            return this.map.get(textualizable);
        }

        public boolean contains(Textualizable textualizable) {
            return this.map.contains(textualizable);
        }

        public IndexedMap getMap() {
            return this.map;
        }

        public Map(DataInput dataInput) {
            this(dataInput, (IndexedMap)new IndexMap(""));
        }

        public Map(DataInput dataInput, IndexedMap indexedMap) {
            super(dataInput);
            this.map = indexedMap;
        }

        public Map(DataOutput dataOutput, IndexedMap indexedMap) {
            super(dataOutput);
            this.map = indexedMap;
        }
    }
}

