import Clazz.*;
import Compil3r.Quad.*;

public abstract class Flow 
{

    public static interface DataflowObject 
	 {
		  void setToTop();
		  void setToBottom();
		  void meetWith (DataflowObject o);
		  void copy (DataflowObject o);

		  /* Also, freshly constructed objects should be Top, equals
			* must be looser than object identity, and toString should
			* return things in a form that's repeatable across runs.  Use
			* SortedSets and SortedMaps instead of the normal kinds.
			*/
    }

    public static interface Analysis {

		  /* Analysis-specific customization.  You can use these to
			* precompute values or output results, if you wish. */

		  void preprocess (ControlFlowGraph cfg);
		  void postprocess (ControlFlowGraph cfg);

		  /* Is this a forward dataflow analysis? */
		  boolean isForward ();

		  /* Routines for interacting with dataflow values.  You may
			* assume that the quad passed in is part of the relevant
			* CFG. */

		  DataflowObject getEntry();
		  DataflowObject getExit();
		  DataflowObject getIn(Quad q);
		  DataflowObject getOut(Quad q);
		  void setIn(Quad q, DataflowObject value);
		  void setOut(Quad q, DataflowObject value);
		  void setEntry(DataflowObject value);
		  void setExit(DataflowObject value);	

		  DataflowObject newTempVar();

		  /* Actually perform the transfer operation on the relevant
			* quad. */
		  void processQuad(Quad q);
    }

    public static interface Solver extends ControlFlowGraphVisitor {
		  void visitCFG(ControlFlowGraph cfg);
		  void registerAnalysis(Analysis a);
    }

    public static void main(String[] args) {
		  Analysis analyzer = null;
		  Solver solver = null;
		  try 
				{
					 Class s = Class.forName(args[0]);
					 solver = (Solver) s.newInstance();
				}
		  catch (Exception e) 
				{
					 System.err.println("Error initializing solver");
					 e.printStackTrace();
					 System.exit(-1);
				}
		  try {
				Class a = Class.forName(args[1]);
				analyzer = (Analysis) a.newInstance();
		  }
		  catch (Exception e) 
				{
					 System.err.println("Error initializing analyzer");
					 e.printStackTrace();
					 System.exit(-1);
				}
		  solver.registerAnalysis(analyzer);
	
		  jq_Class[] classes = new jq_Class[args.length-2];
		  for (int i=0; i < classes.length; i++)
				classes[i] = (jq_Class)Main.Helper.load(args[i+2]);

		  for (int i=0; i < classes.length; i++) 
				{
					 System.out.println("Now analyzing "+classes[i].getName());
					 Main.Helper.runPass(classes[i], solver);
				}
    }
}
